/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.log.log4j;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.LogRegistry;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.config.LogConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.logback.LogbackLogRegistry;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.util.LogConfigUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class Log4jLogRegistry
implements LogRegistry {
    private final Logger log = LoggerFactory.getLogger(LogbackLogRegistry.class);
    private final Map<String, Set<Appender>> pluginAppenderInfo = new ConcurrentHashMap<String, Set<Appender>>();

    @Override
    public void registry(List<Resource> resources, PluginRegistryInfo pluginRegistryInfo) throws Exception {
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        LoggerConfig rootLogger = configuration.getRootLogger();
        HashSet<Appender> allAppender = new HashSet<Appender>();
        for (Resource resource : resources) {
            LogConfig logConfig;
            if (resource == null) continue;
            try {
                logConfig = LogConfigUtil.getLogConfig(resource, pluginRegistryInfo);
            }
            catch (Exception e) {
                this.log.error("Failed to read log configuration.", (Throwable)e);
                continue;
            }
            Set<Appender> appenderSet = this.getAppender(pluginRegistryInfo, logConfig);
            for (Appender appender : appenderSet) {
                configuration.addAppender(appender);
                rootLogger.addAppender(appender, Level.toLevel((String)logConfig.getLevel()), null);
                allAppender.add(appender);
            }
        }
        this.pluginAppenderInfo.put(pluginWrapper.getPluginId(), allAppender);
    }

    private Set<Appender> getAppender(PluginRegistryInfo pluginRegistryInfo, LogConfig logConfig) {
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        LogFilter filter = new LogFilter(pluginRegistryInfo.getBasePlugin().scanPackage());
        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(logConfig.getPattern()).withCharset(Charset.defaultCharset()).build();
        CompositeTriggeringPolicy policy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{SizeBasedTriggeringPolicy.createPolicy((String)logConfig.getMaxFileSize()), TimeBasedTriggeringPolicy.createPolicy((String)"1", (String)"true")});
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withFileIndex(logConfig.getTotalFileSize()).withConfig((Configuration)new DefaultConfiguration()).withMax(String.valueOf(logConfig.getMaxHistory())).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFilter((Filter)filter)).withName(pluginWrapper.getPluginId())).withLayout((Layout)patternLayout)).withIgnoreExceptions(false)).withFileName(LogConfigUtil.getLogFile(pluginRegistryInfo, logConfig).concat(".log")).withFilePattern(".%d{yyyy-MM-dd}-%i.log").withAppend(true).withPolicy((TriggeringPolicy)policy).withStrategy((RolloverStrategy)strategy).build();
        appender.start();
        filter.start();
        return Collections.singleton(appender);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Set<Appender> allAppender = this.pluginAppenderInfo.get(pluginRegistryInfo.getPluginWrapper().getPluginId());
        if (allAppender == null || allAppender.isEmpty()) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        for (Appender appender : allAppender) {
            configuration.getAppenders().remove(appender.getName());
        }
    }

    private static class LogFilter
    extends AbstractFilter {
        private final String packageName;

        private LogFilter(String packageName) {
            this.packageName = packageName;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(LogEvent event) {
            return this.filter(event.getLoggerName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return this.filter(logger.getName());
        }

        private Filter.Result filter(String loggerName) {
            if (loggerName.startsWith(this.packageName)) {
                return Filter.Result.ACCEPT;
            }
            return Filter.Result.DENY;
        }
    }
}

