/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.tenantcreator;

import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.tenant.core.support.TenantCreator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ExpansionTenantCreator
implements TenantCreator,
EnvironmentAware {
    private Environment environment;
    private static final String PLUGIN_ENABLE_NAME = "plugin.enable";
    private static final String PLUGIN_RUN_MODE_NAME = "plugin.runMode";
    private static final String USER_DETAIL_EXPANSION_KEY = "expansion_plugin_key";

    public void createTenantInfo(HttpServletRequest request) {
        TenantDetails tenant = HussarTenantContextHolder.getTenant();
        String tenantCode = tenant.getTenantCode();
        Map appcodePluginInfo = HussarFixedCacheUtil.getHash((String)"share-plugins", (String)("tenant-plugins:" + tenantCode));
        if (HussarUtils.isNotEmpty((Object)appcodePluginInfo)) {
            tenant.addExtendUserMap(USER_DETAIL_EXPANSION_KEY, (Object)appcodePluginInfo);
        }
    }

    public boolean support() {
        String property = this.environment.getProperty(PLUGIN_ENABLE_NAME);
        Boolean convert = (Boolean)HussarConverter.convert(Boolean.class, (Object)property, (Object)false);
        return convert;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

