/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.context;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.handler.ExpansionResultSetHandler;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.FieldLogicInfo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingKeyValueVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.utils.ExpansionMpPluginUtils;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.statement.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class ExpansionMybatisPlusContext {
    private SqlCommandType sqlCommandType;
    private StatementHandler statementHandler;
    private Executor executor;
    private MappedStatement mappedStatement;
    private Object parameter;
    private RowBounds rowBounds;
    private ResultSetHandler resultSetHandler;
    private BoundSql boundSql;
    private Configuration configuration;

    public ExpansionMybatisPlusContext(StatementHandler statementHandler) {
        this.statementHandler = statementHandler;
        ExpansionMpPluginUtils.MPStatementHandler mpStatementHandler = ExpansionMpPluginUtils.mpStatementHandler(statementHandler);
        this.executor = mpStatementHandler.executor();
        this.mappedStatement = mpStatementHandler.mappedStatement();
        this.sqlCommandType = this.mappedStatement.getSqlCommandType();
        BoundSql boundSql = mpStatementHandler.boundSql();
        this.parameter = boundSql.getParameterObject();
        this.rowBounds = mpStatementHandler.rowBounds();
        this.resultSetHandler = mpStatementHandler.resultSetHandler();
        this.boundSql = boundSql;
        this.configuration = mpStatementHandler.configuration();
    }

    public ExpansionMybatisPlusContext(Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultSetHandler resultSetHandler, BoundSql boundSql) {
        this.statementHandler = null;
        this.executor = executor;
        this.mappedStatement = mappedStatement;
        this.sqlCommandType = mappedStatement.getSqlCommandType();
        this.parameter = parameter;
        this.rowBounds = rowBounds;
        this.resultSetHandler = resultSetHandler;
        this.boundSql = boundSql;
        ExpansionMpPluginUtils.MPExecutor mpExecutor = ExpansionMpPluginUtils.mpExecutor(executor);
        this.configuration = mpExecutor.configuration();
    }

    public InterceptorChain getInterceptorChain() {
        MetaObject configurationObject = SystemMetaObject.forObject((Object)this.configuration);
        InterceptorChain interceptorChain = (InterceptorChain)configurationObject.getValue("interceptorChain");
        return interceptorChain;
    }

    public String getMappedStatementId() {
        String mapperId = this.mappedStatement.getId();
        return mapperId;
    }

    public List<ParameterMapping> getParameterMappingList() {
        ExpansionMpPluginUtils.MPBoundSql mpBoundSql = ExpansionMpPluginUtils.mpBoundSql(this.boundSql);
        List<ParameterMapping> parameterMappings = mpBoundSql.parameterMappings();
        return parameterMappings;
    }

    public TypeHandler getTypeHandler(ParameterMappingKeyValueVo propertyNameObj) {
        TypeHandlerRegistry typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        TypeAliasRegistry typeAliasRegistry = this.configuration.getTypeAliasRegistry();
        TypeHandler unknownTypeHandler = typeHandlerRegistry.getUnknownTypeHandler();
        TypeHandler typeHandler = null;
        if (HussarUtils.isEmpty((Object)propertyNameObj.getPropertyType()) || HussarUtils.isEmpty((Object)typeAliasRegistry.resolveAlias(propertyNameObj.getPropertyType()))) {
            typeHandler = unknownTypeHandler;
        } else {
            Class objectClass;
            JdbcType jdbcType = null;
            if (HussarUtils.isNotEmpty((Object)propertyNameObj.getColumnType())) {
                jdbcType = JdbcType.valueOf((String)propertyNameObj.getColumnType());
            }
            typeHandler = HussarUtils.isNotEmpty((Object)(objectClass = typeAliasRegistry.resolveAlias(propertyNameObj.getPropertyType()))) ? typeHandlerRegistry.getTypeHandler(objectClass, jdbcType) : unknownTypeHandler;
        }
        return typeHandler;
    }

    public void convert(FieldLogicInfo fieldLogicInfo) {
        TypeAliasRegistry typeAliasRegistry = this.configuration.getTypeAliasRegistry();
        Class objectClass = typeAliasRegistry.resolveAlias(fieldLogicInfo.getPropertyType());
        if (HussarUtils.isNotEmpty((Object)objectClass)) {
            Object convert = HussarConverter.convert((Class)objectClass, (Object)fieldLogicInfo.getValue());
            fieldLogicInfo.setValue(convert);
        }
    }

    public void changeBoundSql(Statement statement) {
        ExpansionMpPluginUtils.MPBoundSql mpBoundSql = ExpansionMpPluginUtils.mpBoundSql(this.boundSql);
        mpBoundSql.sql(statement.toString());
    }

    public void changeResultSetHandler(Map<String, FieldLogicInfo> propertyCloumnMap, HussarExpansionProperties hussarExpansionProperties) {
        if (HussarUtils.isEmpty((Object)this.statementHandler) || this.mappedStatement.getSqlCommandType() != SqlCommandType.SELECT) {
            return;
        }
        ExpansionMpPluginUtils.MPStatementHandler mpStatementHandler = ExpansionMpPluginUtils.mpStatementHandler(this.statementHandler);
        ResultSetHandler resultSetHandler = mpStatementHandler.resultSetHandler();
        ResultSetHandler realOldResultSetHandler = (ResultSetHandler)ExpansionMpPluginUtils.realTarget(resultSetHandler);
        if (realOldResultSetHandler instanceof ExpansionResultSetHandler) {
            ExpansionResultSetHandler expansionResultSetHandler = (ExpansionResultSetHandler)realOldResultSetHandler;
            Map<String, FieldLogicInfo> sourceProperMap = expansionResultSetHandler.getPropertyCloumnMap();
            if (HussarUtils.isNotEmpty(propertyCloumnMap)) {
                if (!HussarUtils.isEmpty(sourceProperMap)) {
                    sourceProperMap.putAll(propertyCloumnMap);
                } else {
                    expansionResultSetHandler.setPropertyCloumnMap(propertyCloumnMap);
                }
            }
            return;
        }
        ExpansionMpPluginUtils.MPResultSetHandler mpResultSetHandler = ExpansionMpPluginUtils.mpResultSetHandler(resultSetHandler);
        Executor executor = mpResultSetHandler.executor();
        MappedStatement mappedStatement = mpResultSetHandler.mappedStatement();
        ParameterHandler parameterHandler = mpResultSetHandler.parameterHandler();
        ResultHandler resultHandler = mpResultSetHandler.resultHandler();
        BoundSql boundSql = mpResultSetHandler.boundSql();
        RowBounds rowBounds = mpResultSetHandler.rowBounds();
        InterceptorChain interceptorChain = this.getInterceptorChain();
        ExpansionResultSetHandler expansionResultSetHandler = new ExpansionResultSetHandler(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds, hussarExpansionProperties, propertyCloumnMap);
        expansionResultSetHandler = (ResultSetHandler)interceptorChain.pluginAll((Object)expansionResultSetHandler);
        mpStatementHandler.resultSetHandler(expansionResultSetHandler);
    }

    public boolean changeBoundSql(ParameterMappingVo doneParameterMappingVo) {
        if (HussarUtils.isEmpty((Object)doneParameterMappingVo)) {
            return false;
        }
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)this.boundSql);
        List<ParameterMapping> parameterMappingList = doneParameterMappingVo.getParameterMappingList();
        List<ParameterMappingKeyValueVo> parameterMappingKeyValueVoList = doneParameterMappingVo.getParameterMappingKeyValueVoList();
        if (HussarUtils.isNotEmpty(parameterMappingList) && HussarUtils.isNotEmpty(parameterMappingKeyValueVoList)) {
            mpBoundSql.parameterMappings(parameterMappingList);
            parameterMappingKeyValueVoList.forEach(pmkv -> this.boundSql.setAdditionalParameter(pmkv.getParameterMappingKey(), pmkv.getValue()));
            return true;
        }
        return false;
    }

    public StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public MappedStatement getMappedStatement() {
        return this.mappedStatement;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public RowBounds getRowBounds() {
        return this.rowBounds;
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public BoundSql getBoundSql() {
        return this.boundSql;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public SqlCommandType getSqlCommandType() {
        return this.sqlCommandType;
    }
}

