/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.interceptor;

import com.baomidou.mybatisplus.extension.plugins.inner.BaseMultiTableInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.platform.core.base.entity.ExpansionMapEntity;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.context.ExpansionContextHolder;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.dto.ExpansionServiceDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.context.ExpansionMybatisContextHolder;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.context.ExpansionMybatisPlusContext;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.FieldLogicInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpansionInterceptor
extends BaseMultiTableInnerInterceptor
implements InnerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExpansionInterceptor.class);
    private static final String TAG_ADD_PARAMETER = "TAG_EXPANDSION_IS_ENABLE";
    private static final String EXPANSION_ENABLE = "1";
    private static final String EXPANSION_UN_ENABLE = "0";
    private static final String MP_PAGE_COUNT = "_mpCount";
    private HussarExpansionProperties hussarExpansionProperties;
    private ExpansionColumnInfoService expansionColumnInfoService;

    public AbstractExpansionInterceptor() {
    }

    public AbstractExpansionInterceptor(HussarExpansionProperties hussarExpansionProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public AbstractExpansionInterceptor(HussarExpansionProperties hussarExpansionProperties, ExpansionColumnInfoService expansionColumnInfoService) {
        this.hussarExpansionProperties = hussarExpansionProperties;
        this.expansionColumnInfoService = expansionColumnInfoService;
    }

    public boolean willDoQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        ExpansionMybatisContextHolder.remove();
        return true;
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        ExpansionMybatisPlusContext expansionMybatisPlusContext = new ExpansionMybatisPlusContext(sh);
        this.expansionService(expansionMybatisPlusContext);
    }

    public void beforeGetBoundSql(StatementHandler sh) {
        ExpansionMybatisPlusContext expansionMybatisPlusContext = new ExpansionMybatisPlusContext(sh);
        this.expansionService(expansionMybatisPlusContext);
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        ExpansionMybatisPlusContext expansionMybatisPlusContext = new ExpansionMybatisPlusContext(executor, ms, parameter, rowBounds, null, boundSql);
        this.expansionService(expansionMybatisPlusContext);
    }

    protected void expansionService(ExpansionMybatisPlusContext expansionMybatisPlusContext) {
        if (!this.existExpansionService(expansionMybatisPlusContext)) {
            return;
        }
        boolean flag = this.doExpansionService(expansionMybatisPlusContext);
        if (flag) {
            this.tagExpansionService(expansionMybatisPlusContext, EXPANSION_ENABLE);
        } else {
            this.tagExpansionService(expansionMybatisPlusContext, EXPANSION_UN_ENABLE);
        }
    }

    protected boolean doExpansionService(ExpansionMybatisPlusContext expansionMybatisPlusContext) {
        ExpansionServiceDto expansionServiceDto;
        BoundSql boundSql = expansionMybatisPlusContext.getBoundSql();
        String sql = boundSql.getSql();
        ExpansionServiceDto obj = expansionServiceDto = this.getExpansionMapValue(expansionMybatisPlusContext);
        if (HussarUtils.isEmpty((Object)expansionServiceDto)) {
            obj = expansionServiceDto = new ExpansionServiceDto(new HashMap<String, Object>(), null, expansionMybatisPlusContext);
        }
        this.parserSingle(sql, obj);
        return expansionServiceDto.isExpansionEnable();
    }

    protected ExpansionServiceDto getExpansionMapValue(ExpansionMybatisPlusContext expansionMybatisPlusContext) {
        Object parameterObject = expansionMybatisPlusContext.getParameter();
        if (HussarUtils.isEmpty((Object)this.hussarExpansionProperties) || !this.hussarExpansionProperties.isEnable() || HussarUtils.isEmpty((Object)parameterObject)) {
            return null;
        }
        Object actualParameterObject = null;
        if (ClassUtil.isAssignable(MapperMethod.ParamMap.class, parameterObject.getClass())) {
            MapperMethod.ParamMap methodParamMap = (MapperMethod.ParamMap)parameterObject;
            logger.debug("expansion \u5f00\u59cb\u4eceMapperMethod.ParamMap \u83b7\u53d6\u53c2\u6570");
            if (methodParamMap.containsKey((Object)"param1")) {
                actualParameterObject = methodParamMap.get((Object)"param1");
            } else if (methodParamMap.containsKey((Object)"et")) {
                actualParameterObject = methodParamMap.get((Object)"et");
            } else {
                logger.debug("expansion \u5f00\u59cb\u4eceMapperMethod.ParamMap\uff0c\u6ca1\u6709\u83b7\u53d6\u53c2\u6570");
            }
        } else {
            logger.debug("expansion \u76f4\u63a5\u83b7\u53d6\u5230\u53c2\u6570");
            actualParameterObject = parameterObject;
        }
        if (HussarUtils.isEmpty((Object)actualParameterObject) || ClassUtil.isBasicType(actualParameterObject.getClass())) {
            logger.debug("expansion \u53c2\u6570\u503c\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e0d\u662f\u57fa\u672c\u7c7b\u578b");
            return null;
        }
        ExpansionServiceDto expansionServiceDto = null;
        String propertyMapPropertyName = this.hussarExpansionProperties.getPropertyMapPropertyName();
        if (ReflectUtil.hasField(actualParameterObject.getClass(), (String)propertyMapPropertyName) && HussarUtils.isNotEmpty((Object)ReflectUtil.getFieldValue((Object)actualParameterObject, (String)propertyMapPropertyName))) {
            Map expansionMap = (Map)ReflectUtil.getFieldValue((Object)actualParameterObject, (String)propertyMapPropertyName);
            expansionServiceDto = new ExpansionServiceDto(expansionMap, propertyMapPropertyName, expansionMybatisPlusContext);
            return expansionServiceDto;
        }
        if (ClassUtil.isAssignable(ExpansionMapEntity.class, actualParameterObject.getClass())) {
            ExpansionMapEntity expansionMapEntity = (ExpansionMapEntity)actualParameterObject;
            Map expansionMap = expansionMapEntity.getExpansionMap();
            expansionServiceDto = new ExpansionServiceDto(expansionMap, "expansionMap", expansionMybatisPlusContext);
            return expansionServiceDto;
        }
        return null;
    }

    private void tagExpansionService(ExpansionMybatisPlusContext expansionMybatisPlusContext, String isEnableExpansion) {
        BoundSql boundSql = expansionMybatisPlusContext.getBoundSql();
        if (boundSql.hasAdditionalParameter(TAG_ADD_PARAMETER)) {
            return;
        }
        boundSql.setAdditionalParameter(TAG_ADD_PARAMETER, (Object)isEnableExpansion);
    }

    private boolean existExpansionService(ExpansionMybatisPlusContext expansionMybatisPlusContext) {
        if (HussarUtils.isEmpty((Object)this.hussarExpansionProperties) || !this.hussarExpansionProperties.isEnable() || HussarUtils.isEmpty((Object)ExpansionContextHolder.get())) {
            expansionMybatisPlusContext.changeResultSetHandler(null, this.hussarExpansionProperties);
            return false;
        }
        String mappedStatementId = expansionMybatisPlusContext.getMappedStatementId();
        if (StringUtil.endWith((CharSequence)mappedStatementId, (CharSequence)MP_PAGE_COUNT)) {
            return false;
        }
        Map<String, FieldLogicInfo> propertyColumnMap = ExpansionMybatisContextHolder.get();
        expansionMybatisPlusContext.changeResultSetHandler(propertyColumnMap, this.hussarExpansionProperties);
        BoundSql boundSql = expansionMybatisPlusContext.getBoundSql();
        return !boundSql.hasAdditionalParameter(TAG_ADD_PARAMETER);
    }

    public HussarExpansionProperties getHussarExpansionProperties() {
        return this.hussarExpansionProperties;
    }

    public void setHussarExpansionProperties(HussarExpansionProperties hussarExpansionProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public ExpansionColumnInfoService getExpansionColumnInfoService() {
        return this.expansionColumnInfoService;
    }

    public void setExpansionColumnInfoService(ExpansionColumnInfoService expansionColumnInfoService) {
        this.expansionColumnInfoService = expansionColumnInfoService;
    }
}

