/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.db.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.platform.core.support.service.dto.SharePluginInfo;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.expansion.core.service.SharePluginService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoHistoryDto;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginRollbackDto;
import com.jxdinfo.hussar.support.expansion.db.share.model.PluginInfo;
import com.jxdinfo.hussar.support.expansion.db.share.model.PluginInfoHistory;
import com.jxdinfo.hussar.support.expansion.db.share.model.PluginInfoRollback;
import com.jxdinfo.hussar.support.expansion.db.share.service.PluginInfoHistoryService;
import com.jxdinfo.hussar.support.expansion.db.share.service.PluginInfoRollbackService;
import com.jxdinfo.hussar.support.expansion.db.share.service.PluginInfoService;
import com.jxdinfo.hussar.support.expansion.db.share.util.AppCodeCheckUtil;
import com.jxdinfo.hussar.support.expansion.db.share.util.DtoModelConvertUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class SharePluginServiceImpl
implements SharePluginService {
    private static final Logger logger = LoggerFactory.getLogger(SharePluginServiceImpl.class);
    @Autowired
    private PluginInfoService pluginInfoService;
    @Autowired
    private PluginInfoHistoryService pluginInfoHistoryService;
    @Autowired
    private PluginInfoRollbackService pluginInfoRollbackService;
    @Autowired
    private RedisTemplate<Object, ?> redisTemplate;
    @Autowired(required=false)
    private RedisCacheConfiguration cacheConfig;

    @HussarTransactional
    public void savePluginInfo(SharePluginInfoDto pluginInfoDto) {
        String path;
        String serviceName;
        PluginInfo pluginInfo = DtoModelConvertUtil.convertPluginInfo(pluginInfoDto);
        String tenantCode = pluginInfoDto.getTenantCode();
        String appCode = pluginInfoDto.getAppCode();
        boolean updateExpansionPluginId = false;
        if (HussarUtils.isNotBlank((CharSequence)tenantCode) && HussarUtils.isNotBlank((CharSequence)appCode) && HussarUtils.isEmpty((Object)pluginInfoDto.getId())) {
            PluginInfo info = (PluginInfo)((Object)this.pluginInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PluginInfo::getTenantCode, (Object)tenantCode)).eq(PluginInfo::getAppCode, (Object)appCode)));
            boolean bl = updateExpansionPluginId = HussarUtils.isNotBlank((CharSequence)pluginInfo.getExpansionPluginId()) && HussarUtils.isBlank((CharSequence)pluginInfo.getAppVersion());
            if (HussarUtils.isNotEmpty((Object)((Object)info))) {
                if (info.getAppVersion().equals(pluginInfo.getAppVersion())) {
                    ExceptionUtil.wrapRuntimeAndThrow((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7248\u672c\u7684\u63d2\u4ef6\u4fe1\u606f");
                }
                if (!updateExpansionPluginId && Boolean.FALSE.equals(AppCodeCheckUtil.checkVersion(info.getAppVersion(), pluginInfo.getAppVersion()))) {
                    ExceptionUtil.wrapRuntimeAndThrow((String)"\u8bf7\u4e0a\u4f20\u66f4\u65b0\u7248\u672c\u7684\u63d2\u4ef6");
                }
                pluginInfo.setId(info.getId());
            } else if (updateExpansionPluginId) {
                ExceptionUtil.wrapRuntimeAndThrow((String)"\u8bf7\u5148\u4e0a\u4f20\u6807\u51c6\u63d2\u4ef6");
            }
        }
        if (HussarUtils.isNotBlank((CharSequence)(serviceName = pluginInfoDto.getServiceName())) && HussarUtils.isNotBlank((CharSequence)(path = this.getPathByServiceName(serviceName)))) {
            pluginInfo.setRoutePath(path);
        }
        this.pluginInfoService.saveOrUpdate((Object)pluginInfo);
        if (!updateExpansionPluginId) {
            PluginInfoHistory history = DtoModelConvertUtil.convertPluginInfoHistory(pluginInfoDto);
            history.setRoutePath(pluginInfo.getRoutePath());
            this.pluginInfoHistoryService.save((Object)history);
        }
        SharePluginServiceImpl.updateCache(pluginInfo);
    }

    @HussarTransactional
    public void savePluginInfos(List<SharePluginInfoDto> pluginInfoDtoList) {
        if (HussarUtils.isEmpty(pluginInfoDtoList)) {
            return;
        }
        int size = pluginInfoDtoList.size();
        HashSet set = Sets.newHashSetWithExpectedSize((int)size);
        ArrayList pluginInfos = Lists.newArrayListWithCapacity((int)size);
        ArrayList histories = Lists.newArrayListWithCapacity((int)size);
        for (SharePluginInfoDto pluginInfoDto : pluginInfoDtoList) {
            String key = pluginInfoDto.getTenantCode() + ":" + pluginInfoDto.getAppCode();
            PluginInfo pluginInfo = DtoModelConvertUtil.convertPluginInfo(pluginInfoDto);
            if (set.contains(key) || HussarUtils.isEmpty((Object)((Object)pluginInfo))) continue;
            set.add(key);
            pluginInfos.add(pluginInfo);
            histories.add(DtoModelConvertUtil.convertPluginInfoHistory(pluginInfoDto));
        }
        if (HussarUtils.isEmpty((Object)pluginInfos)) {
            return;
        }
        this.pluginInfoService.saveBatch(pluginInfos);
        this.pluginInfoHistoryService.saveBatch(histories);
        for (PluginInfo info : pluginInfos) {
            SharePluginServiceImpl.updateCache(info);
        }
    }

    public List<SharePluginInfoHistoryDto> queryHistoryList(String tenantCode, String appCode) {
        if (HussarUtils.isBlank((CharSequence)tenantCode) && HussarUtils.isBlank((CharSequence)appCode)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotBlank((CharSequence)tenantCode), PluginInfoHistory::getTenantCode, (Object)tenantCode)).eq(HussarUtils.isNotBlank((CharSequence)appCode), PluginInfoHistory::getAppCode, (Object)appCode);
        List histories = this.pluginInfoHistoryService.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)histories)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)histories.size());
        for (PluginInfoHistory history : histories) {
            result.add(DtoModelConvertUtil.convertPluginInfoHistoryDto(history));
        }
        return result;
    }

    @HussarTransactional
    public void rollbackPlugin(SharePluginRollbackDto rollbackDto) {
        boolean paramInvalid;
        boolean bl = paramInvalid = !HussarUtils.isEmpty((Object)rollbackDto) && !HussarUtils.isBlank((CharSequence)rollbackDto.getTenantCode()) && !HussarUtils.isBlank((CharSequence)rollbackDto.getAppCode());
        if (!paramInvalid || HussarUtils.isBlank((CharSequence)rollbackDto.getAfterVersion()) || HussarUtils.isBlank((CharSequence)rollbackDto.getBeforeVersion())) {
            return;
        }
        PluginInfo pluginInfo = new PluginInfo();
        pluginInfo.setTenantCode(rollbackDto.getTenantCode());
        pluginInfo.setAppCode(rollbackDto.getAppCode());
        pluginInfo.setAppVersion(rollbackDto.getAfterVersion());
        PluginInfoRollback rollback = DtoModelConvertUtil.convertPluginInfoRollback(rollbackDto);
        if (HussarUtils.isNotEmpty((Object)rollbackDto.getBeforeHistId())) {
            rollback.setBeforeHistId(rollbackDto.getBeforeHistId());
        } else {
            PluginInfoHistory beforeHistory = (PluginInfoHistory)((Object)this.pluginInfoHistoryService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PluginInfoHistory::getTenantCode, (Object)rollbackDto.getTenantCode())).eq(PluginInfoHistory::getAppCode, (Object)rollbackDto.getAppCode())).eq(PluginInfoHistory::getAppVersion, (Object)rollbackDto.getBeforeVersion())));
            rollback.setBeforeHistId(beforeHistory.getId());
        }
        if (HussarUtils.isNotEmpty((Object)rollbackDto.getAfterHistId())) {
            rollback.setAfterHistId(rollbackDto.getAfterHistId());
        } else {
            PluginInfoHistory afterHistory = (PluginInfoHistory)((Object)this.pluginInfoHistoryService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PluginInfoHistory::getTenantCode, (Object)rollbackDto.getTenantCode())).eq(PluginInfoHistory::getAppCode, (Object)rollbackDto.getAppCode())).eq(PluginInfoHistory::getAppVersion, (Object)rollbackDto.getAfterVersion())));
            rollback.setAfterHistId(afterHistory.getId());
            pluginInfo.setSharePluginId(afterHistory.getSharePluginId());
        }
        this.pluginInfoService.update((Object)pluginInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PluginInfo::getTenantCode, (Object)rollbackDto.getTenantCode())).eq(PluginInfo::getAppCode, (Object)rollbackDto.getAppCode()));
        this.pluginInfoRollbackService.save((Object)rollback);
        pluginInfo = (PluginInfo)((Object)this.pluginInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PluginInfo::getTenantCode, (Object)rollbackDto.getTenantCode())).eq(PluginInfo::getAppCode, (Object)rollbackDto.getAppCode())));
        SharePluginServiceImpl.updateCache(pluginInfo);
    }

    public SharePluginInfoDto queryPluginInfo(String tenantCode, String appCode) {
        if (HussarUtils.isBlank((CharSequence)tenantCode) || HussarUtils.isBlank((CharSequence)appCode)) {
            return null;
        }
        Object sharePluginInfo = HussarFixedCacheUtil.getFieldValue((String)"share-plugins", (String)("tenant-plugins:" + tenantCode), (String)appCode);
        if (HussarUtils.isNotEmpty((Object)sharePluginInfo)) {
            return DtoModelConvertUtil.cacheValue2Dto((SharePluginInfo)sharePluginInfo);
        }
        PluginInfo pluginInfo = (PluginInfo)((Object)this.pluginInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PluginInfo::getTenantCode, (Object)tenantCode)).eq(PluginInfo::getAppCode, (Object)appCode)));
        if (HussarUtils.isEmpty((Object)((Object)pluginInfo))) {
            return null;
        }
        return DtoModelConvertUtil.convertPluginInfoDto(pluginInfo);
    }

    public void removePluginInfo(String tenantCode, String appCode) {
        if (HussarUtils.isBlank((CharSequence)tenantCode) || HussarUtils.isBlank((CharSequence)appCode)) {
            return;
        }
        this.pluginInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PluginInfo::getTenantCode, (Object)tenantCode)).eq(PluginInfo::getAppCode, (Object)appCode));
        HussarFixedCacheUtil.removeField((String)"share-plugins", (String)("tenant-plugins:" + tenantCode), (String)appCode);
    }

    public List<SharePluginInfoDto> queryAllPluginInfo() {
        List cacheValues = HussarFixedCacheUtil.getHashValsWithKeys((String)"share-plugins", (String)"tenant-plugins");
        if (HussarUtils.isNotEmpty((Object)cacheValues)) {
            ArrayList result = Lists.newArrayListWithCapacity((int)cacheValues.size());
            for (Object val : cacheValues) {
                result.add(DtoModelConvertUtil.cacheValue2Dto((SharePluginInfo)val));
            }
            return result;
        }
        List pluginInfos = this.pluginInfoService.list();
        if (HussarUtils.isEmpty((Object)pluginInfos)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)pluginInfos.size());
        HashMap cacheMap = Maps.newHashMapWithExpectedSize((int)20);
        for (PluginInfo pluginInfo : pluginInfos) {
            Map<String, SharePluginInfo> appCodeMap;
            SharePluginInfoDto pluginInfoDto = DtoModelConvertUtil.convertPluginInfoDto(pluginInfo);
            result.add(pluginInfoDto);
            String tenantCode = pluginInfo.getTenantCode();
            if (cacheMap.containsKey(tenantCode)) {
                appCodeMap = (Map)cacheMap.get(tenantCode);
            } else {
                appCodeMap = Maps.newHashMapWithExpectedSize((int)1);
                cacheMap.put(tenantCode, appCodeMap);
            }
            appCodeMap.put(pluginInfo.getAppCode(), DtoModelConvertUtil.toCacheValue(pluginInfo));
        }
        for (Map.Entry entry : cacheMap.entrySet()) {
            HussarFixedCacheUtil.putHash((String)"share-plugins", (String)("tenant-plugins:" + entry.getKey().toString()), (Map)((Map)entry.getValue()), (long)-1L);
        }
        return result;
    }

    public List<SharePluginInfoDto> queryPluginInfoList(SharePluginInfoDto pluginInfoDto) {
        boolean onlyTCode = HussarUtils.isNotEmpty((Object)pluginInfoDto) && HussarUtils.isEmpty((Object)pluginInfoDto.getId()) && HussarUtils.isBlank((CharSequence)pluginInfoDto.getSharePluginId()) && HussarUtils.isBlank((CharSequence)pluginInfoDto.getAppCode()) && HussarUtils.isBlank((CharSequence)pluginInfoDto.getAppVersion()) && HussarUtils.isBlank((CharSequence)pluginInfoDto.getConnName()) && HussarUtils.isNotBlank((CharSequence)pluginInfoDto.getTenantCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)pluginInfoDto.getId()), PluginInfo::getId, (Object)pluginInfoDto.getId())).eq(HussarUtils.isNotBlank((CharSequence)pluginInfoDto.getSharePluginId()), PluginInfo::getSharePluginId, (Object)pluginInfoDto.getSharePluginId())).eq(HussarUtils.isNotBlank((CharSequence)pluginInfoDto.getTenantCode()), PluginInfo::getTenantCode, (Object)pluginInfoDto.getTenantCode())).eq(HussarUtils.isNotBlank((CharSequence)pluginInfoDto.getAppCode()), PluginInfo::getAppCode, (Object)pluginInfoDto.getAppCode())).eq(HussarUtils.isNotBlank((CharSequence)pluginInfoDto.getAppVersion()), PluginInfo::getAppVersion, (Object)pluginInfoDto.getAppVersion())).eq(HussarUtils.isNotBlank((CharSequence)pluginInfoDto.getConnName()), PluginInfo::getConnName, (Object)pluginInfoDto.getConnName());
        List pluginInfos = this.pluginInfoService.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)pluginInfos)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)pluginInfos.size());
        HashMap cacheMap = Maps.newHashMapWithExpectedSize((int)pluginInfos.size());
        for (PluginInfo pluginInfo : pluginInfos) {
            result.add(DtoModelConvertUtil.convertPluginInfoDto(pluginInfo));
            cacheMap.put(pluginInfo.getAppCode(), DtoModelConvertUtil.toCacheValue(pluginInfo));
        }
        if (onlyTCode) {
            HussarFixedCacheUtil.putHash((String)"share-plugins", (String)("tenant-plugins:" + pluginInfoDto.getTenantCode()), (Map)cacheMap, (long)-1L);
        }
        return result;
    }

    private static void updateCache(PluginInfo pluginInfo) {
        SharePluginInfo sharePluginInfo = DtoModelConvertUtil.toCacheValue(pluginInfo);
        String tenantCode = sharePluginInfo.getTenantCode();
        String appCode = sharePluginInfo.getAppCode();
        HussarFixedCacheUtil.addField((String)"share-plugins", (String)("tenant-plugins:" + tenantCode), (String)appCode, (Object)sharePluginInfo);
    }

    private String getPathByServiceName(String serviceName) {
        Object val = this.redisTemplate.execute(redisConnection -> {
            byte[] value = redisConnection.hGet(this.serializeCacheKey("\"global:gateway_route_key\""), this.serializeCacheKey("\"" + serviceName + "\""));
            if (HussarUtils.isEmpty((Object)value)) {
                return null;
            }
            return this.deserializeCacheValue(value);
        });
        if (HussarUtils.isEmpty((Object)val)) {
            return null;
        }
        Map valueMap = (Map)JsonUtil.parse((String)val.toString(), Map.class);
        if (HussarUtils.isEmpty((Object)valueMap)) {
            return null;
        }
        List predicates = (List)valueMap.get("predicates");
        if (HussarUtils.isEmpty((Object)predicates)) {
            return null;
        }
        for (Object predicate : predicates) {
            if (!(predicate instanceof ArrayList)) continue;
            Map map = (Map)((List)predicate).get(0);
            if (HussarUtils.isEmpty((Object)map)) {
                return null;
            }
            Object args = map.get("args");
            if (HussarUtils.isEmpty(args)) {
                return null;
            }
            Map pathMap = (Map)args;
            Object pathValue = pathMap.get("_genkey_0");
            if (!HussarUtils.isNotEmpty(pathValue)) continue;
            return pathValue.toString();
        }
        return null;
    }

    protected RedisCacheConfiguration cacheConfig() {
        if (null == this.cacheConfig) {
            return RedisCacheConfiguration.defaultCacheConfig();
        }
        return this.cacheConfig;
    }

    protected byte[] serializeCacheKey(String key) {
        return ByteUtils.getBytes((ByteBuffer)this.cacheConfig().getKeySerializationPair().write((Object)key));
    }

    protected Object deserializeCacheValue(byte[] value) {
        return this.cacheConfig().getKeySerializationPair().read(ByteBuffer.wrap(value));
    }
}

