/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEngineDictTransHandler {
    public void transQueryValue(String ruleContent, Map<String, Object> annotationValue) {
        JSONObject jsonObject = JSON.parseObject((String)ruleContent);
        if (jsonObject.containsKey((Object)"namespace")) {
            annotationValue.put("namespace", jsonObject.getString("namespace"));
        }
        if (jsonObject.containsKey((Object)"queryFields")) {
            annotationValue.put("queryFields", jsonObject.getString("queryFields").split(","));
        }
        if (jsonObject.containsKey((Object)"keyRef") && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{jsonObject.getString("keyRef")})) {
            annotationValue.put("keyRef", jsonObject.getString("keyRef").split(","));
        }
        if (jsonObject.containsKey((Object)"ref") && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{jsonObject.getString("ref")})) {
            annotationValue.put("ref", jsonObject.getString("ref"));
        }
        if (jsonObject.containsKey((Object)"refs") && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{jsonObject.getString("refs")})) {
            annotationValue.put("refs", jsonObject.getString("refs").split(","));
        }
        if (jsonObject.containsKey((Object)"type")) {
            annotationValue.put("type", jsonObject.getString("type"));
        }
        if (jsonObject.containsKey((Object)"key")) {
            annotationValue.put("key", jsonObject.getString("key"));
        }
    }

    public void getRefSettings(List<Map<String, Object>> annotationValueList, Set<String> refSet) {
        for (Map<String, Object> map : annotationValueList) {
            if (map.containsKey("refs") && HussarUtils.isNotEmpty((Object)map.get("refs"))) {
                String[] split;
                for (String ref : split = (String[])map.get("refs")) {
                    String[] refSetting = ref.split("#");
                    refSet.add(refSetting[0]);
                }
            }
            if (!map.containsKey("ref") || !HussarUtils.isNotEmpty((Object)map.get("ref"))) continue;
            String ref = HussarUtils.toStr((Object)map.get("ref"));
            String[] refSetting = ref.split("#");
            refSet.add(refSetting[0]);
        }
    }

    public void addProperties(List<EngineResultEntity> entityList, Set<String> currentRefSet, Map<String, Set<String>> refSetMap) {
        for (EngineResultEntity entity : entityList) {
            for (String string : currentRefSet) {
                entity.put((Object)string, null);
            }
            if (HussarUtils.isEmpty(refSetMap)) continue;
            for (Map.Entry entry : refSetMap.entrySet()) {
                if (!entity.containsKey(entry.getKey()) || !(entity.get(entry.getKey()) instanceof List)) continue;
                this.addProperties((List)entity.get(entry.getKey()), (Set)entry.getValue(), refSetMap);
            }
        }
    }
}

