/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.core.enums.ColumnRuleType;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.handler.AbstractEngineDictTransHandler;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.extend.CustomClassContent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.engine", name={"trans"}, havingValue="true", matchIfMissing=true)
public class DefaultEngineDictTransHandler
extends AbstractEngineDictTransHandler
implements EngineParamHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultEngineDictTransHandler.class);
    private final IEnginePluginModelApp iEnginePluginModelApp;
    private static final String[] actionName = new String[]{"selectOne", "selectList", "selectPage", "selectMsPage", "selectExpressionList", "selectExpressionPage"};

    public DefaultEngineDictTransHandler(IEnginePluginModelApp iEnginePluginModelApp) {
        this.iEnginePluginModelApp = iEnginePluginModelApp;
    }

    public void resultHandling(Object result, NodeBusinessVo nodeBusiness) {
        Set<String> refSet;
        String dataServiceCode = nodeBusiness.getActionName();
        Boolean check = false;
        for (int i = 0; i < actionName.length; ++i) {
            if (!dataServiceCode.equals(actionName[i])) continue;
            check = true;
            break;
        }
        if (!check.booleanValue()) {
            return;
        }
        Long modelId = nodeBusiness.getModelId();
        ModelTableMappingDTO modelTableMapping = this.iEnginePluginModelApp.getModelTableMapping(modelId);
        CustomClassContent.Builder builder = new CustomClassContent.Builder();
        List<ModelColumnsRules> res = DefaultEngineDictTransHandler.findRule(modelTableMapping);
        if (res.isEmpty()) {
            return;
        }
        Map<Long, ModelColumnsRules> rulesMap = res.stream().collect(Collectors.toMap(ModelColumnsRules::getModelColumnId, Function.identity()));
        HashMap<String, Set<String>> refSetMap = new HashMap<String, Set<String>>();
        if (HussarUtils.isEmpty((Object)modelTableMapping.getSlaveTables())) {
            refSet = this.transSingleTable(modelTableMapping.getColumns(), modelId, rulesMap, builder);
        } else {
            refSet = this.transSingleTable(modelTableMapping.getColumns(), modelId, rulesMap, builder);
            this.transMsTable(modelTableMapping.getSlaveTables(), rulesMap, builder, refSetMap);
        }
        if (result instanceof PageVo) {
            result = ((PageVo)result).getData();
        } else if (result instanceof EngineResultEntity) {
            List<EngineResultEntity> singleList = Collections.singletonList((EngineResultEntity)result);
            this.addProperties(singleList, refSet, refSetMap);
            TransUtil.trans((Object)result, (CustomClassContent)builder.builder());
            return;
        }
        if (HussarUtils.isNotEmpty((Object)((List)result)) && ((List)result).get(0) instanceof EngineResultEntity) {
            this.addProperties((List)result, refSet, refSetMap);
        }
        TransUtil.trans((List)((List)result), (CustomClassContent)builder.builder());
    }

    private static List<ModelColumnsRules> findRule(ModelTableMappingDTO modelTableMapping) {
        ArrayList<ModelColumnsRules> res = new ArrayList<ModelColumnsRules>();
        modelTableMapping.getRuleByRuleType(res, ColumnRuleType.TRANSLATION);
        return res;
    }

    public int getOrder() {
        return 0;
    }

    private Set<String> transSingleTable(List<ModelColumnDto> columns, Long modelId, Map<Long, ModelColumnsRules> rulesMap, CustomClassContent.Builder builder) {
        builder.setId(String.valueOf(modelId));
        ArrayList<Map<String, Object>> annotationValueList = new ArrayList<Map<String, Object>>();
        HashSet<String> columnName = new HashSet<String>();
        for (int i = 0; i < columns.size(); ++i) {
            int finalI = i;
            Class<Trans> transClass = Trans.class;
            String columnAlias = columns.get(i).getColumnAlias();
            if (!columnName.add(columnAlias)) continue;
            ModelColumnsRules columnsRules = rulesMap.get(columns.get(i).getModelColumnId());
            Class javaClass = null;
            try {
                javaClass = columns.get(i).javaType();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> annotationValue = null;
            if (HussarUtils.isNotEmpty((Object)columnsRules)) {
                annotationValue = new HashMap<String, Object>();
                String ruleContent = columnsRules.getRuleContent();
                this.transQueryValue(ruleContent, annotationValue);
                annotationValueList.add(annotationValue);
            } else {
                transClass = null;
            }
            builder.defineField(columnAlias, (Type)javaClass, transClass, annotationValue);
        }
        HashSet<String> refSet = new HashSet<String>();
        this.getRefSettings(annotationValueList, refSet);
        for (String ref : refSet) {
            builder.defineField(ref, Object.class);
        }
        return refSet;
    }

    private void transMsTable(List<ModelTableMappingDTO> modelTableMapping, Map<Long, ModelColumnsRules> rulesMap, CustomClassContent.Builder builder, Map<String, Set<String>> refSetMap) {
        for (ModelTableMappingDTO modelTableMappingDTO : modelTableMapping) {
            List columns = modelTableMappingDTO.getColumns();
            Set<Object> refSet = new HashSet();
            if (modelTableMappingDTO.getRelation().equals((Object)ModelRelation.ONE_ONE)) {
                refSet = this.transSingleTable(columns, modelTableMappingDTO.getRelatedId(), rulesMap, builder);
            } else if (ModelRelation.isMS((ModelRelation)modelTableMappingDTO.getRelation())) {
                if (!columns.stream().anyMatch(c -> rulesMap.get(c.getModelColumnId()) != null)) continue;
                CustomClassContent.Builder builderslave = new CustomClassContent.Builder();
                refSet = this.transSingleTable(columns, modelTableMappingDTO.getRelatedId(), rulesMap, builderslave);
                builder.defineField(modelTableMappingDTO.getParamName(), List.class, builderslave.builder());
            }
            if (HussarUtils.isNotEmpty(refSet)) {
                refSetMap.put(modelTableMappingDTO.getParamName(), refSet);
            }
            if (!HussarUtils.isNotEmpty((Object)modelTableMappingDTO.getSlaveTables())) continue;
            this.transMsTable(modelTableMappingDTO.getSlaveTables(), rulesMap, builder, refSetMap);
        }
    }
}

