/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.upgrade.backup;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.BackupEntity;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.BackupProperties;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class BackupHelper {
    private static final Logger logger = LoggerFactory.getLogger(BackupHelper.class);

    private BackupHelper() {
    }

    public static void backup(BackupEntity backupEntity, BackupProperties properties) {
        String commandTemplate = properties.getDbType2Command().get(backupEntity.getDbType());
        if (HussarUtils.isBlank((CharSequence)commandTemplate)) {
            logger.error("\u6ca1\u6709\u627e\u5230\u5907\u4efd\u547d\u4ee4\uff0c\u6570\u636e\u5e93\u7c7b\u578b\uff1a{}", (Object)backupEntity.getDbType().getDb());
            return;
        }
        String command = BackupHelper.format(commandTemplate, backupEntity.toMap());
        logger.info("\u5907\u4efd\u547d\u4ee4\uff1a{}", (Object)command);
        try {
            Process process = Runtime.getRuntime().exec(command);
            boolean i = process.waitFor(5L, TimeUnit.SECONDS);
            if (i) {
                logger.info("\u5907\u4efd\u6210\u529f\uff0c\u7248\u672c\u53f7\uff1a{}", (Object)backupEntity.getVersion());
            } else {
                logger.error("\u5907\u4efd\u5931\u8d25\uff0c\u7248\u672c\u53f7\uff1a{}\uff0c\u9519\u8bef\u7801\uff1a{}", (Object)backupEntity.getVersion(), (Object)i);
            }
        }
        catch (Exception e) {
            logger.error("\u5907\u4efd\u5931\u8d25\uff0c\u7248\u672c\u53f7\uff1a{}, \u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)backupEntity.getVersion(), (Object)e.getMessage());
        }
    }

    public static String format(@Nullable String message, @Nullable Map<String, ?> params) {
        if (message == null) {
            return "";
        }
        if (params != null && !params.isEmpty()) {
            int end;
            int start;
            StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
            int cursor = 0;
            while ((start = message.indexOf("$<", cursor)) != -1 && (end = message.indexOf(">", start)) != -1) {
                sb.append(message, cursor, start);
                String key = message.substring(start + 2, end);
                Object value = params.get(StringUtil.trimWhitespace((String)key));
                sb.append((Object)(value == null ? "" : value));
                cursor = end + 1;
            }
            sb.append(message.substring(cursor));
            return sb.toString();
        }
        return message;
    }
}

