/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.upgrade.manage.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.ImmutableList;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeInfo;
import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeRelationHolder;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSyncDto;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.entity.Relationship;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipJoin;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessInout;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.service.ModelSyncService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessInoutService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessPmService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.api.service.RelationshipService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.ModelInfo;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipJoinService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipOnService;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.business.entity.LogicBusiness;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.business.service.LogicBusinessService;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.context.UpgradeContext7;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.context.UpgradeIteContext7;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.entity.UpgradeRecord;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.manage.AbstractEngineUpgrade;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.service.UpgradeRecordService;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.util.ListUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnginePluginUpgradeApp7
extends AbstractEngineUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(EnginePluginUpgradeApp7.class);
    @Autowired
    private LogicBusinessService logicBusinessService;
    @Autowired
    private ApiNamingService apiNamingService;
    @Autowired
    private NodeBusinessService nodeBusinessService;
    @Autowired
    private UpgradeRecordService upgradeRecordService;
    @Resource
    private DataserviceService dataserviceService;
    @Autowired
    private NodeBusinessPmService nodeBusinessPmService;
    @Autowired
    private NodeBusinessInoutService nodeBusinessInoutService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private RelationshipJoinService relationshipJoinService;
    @Autowired
    private RelationshipOnService relationshipOnService;
    @Autowired
    private MetadataTableService metadataTableService;
    @Autowired
    private MetadataColumnService metadataColumnService;
    @Autowired
    private ModelRelationshipService modelRelationshipService;
    @Autowired
    private ModelColumnsService modelColumnsService;

    @Override
    @DSTransactional
    public void upgrade() {
        UpgradeRecord record = new UpgradeRecord();
        record.setId(EngineUtil.getId());
        record.setVersion(this.getVersion());
        record.setSuccess(1);
        this.upgradeRecordService.save((Object)record);
        try {
            this.businessUpgrade();
            try {
                this.fillTfModel();
            }
            catch (Exception e) {
                logger.error("\u586b\u5145\u5929\u65a7\u6a21\u578b\u4fe1\u606f\u65f6\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            }
            this.thinTableRelations();
            record.setSuccess(1);
            this.afterClean();
            record.setException(UpgradeContext7.getLogs());
        }
        catch (Exception e) {
            record.setSuccess(0);
            record.setException(UpgradeContext7.getLogs() + "\n" + e.getMessage());
        }
        finally {
            this.upgradeRecordService.updateById((Object)record);
            UpgradeContext7.clear();
        }
    }

    private void logError(String format, Object ... objects) {
        String log = StringUtil.format((String)format, (Object[])objects);
        logger.error(log);
        UpgradeContext7.addLog(log);
    }

    private void businessUpgrade() {
        List apiNamingList = this.apiNamingService.list();
        if (HussarUtils.isEmpty((Object)apiNamingList)) {
            return;
        }
        apiNamingList.forEach(apiNaming -> {
            if (apiNaming.getServiceId() == null) {
                return;
            }
            UpgradeIteContext7 context = new UpgradeIteContext7();
            context.setApiNaming((ApiNaming)apiNaming);
            LogicBusiness logicBusiness = (LogicBusiness)((Object)((Object)this.logicBusinessService.getById(apiNaming.getServiceId())));
            if (logicBusiness == null) {
                return;
            }
            NodeBusiness nodeBusiness = this.nodeBusinessService.getBusinessByNodeName(logicBusiness.getBusinessName().substring(0, logicBusiness.getBusinessName().indexOf("_")));
            if (nodeBusiness == null) {
                return;
            }
            context.setNodeBusiness(nodeBusiness);
            apiNaming.setServiceName(apiNaming.getServiceNameByBusinessId());
            nodeBusiness.setNodeName(apiNaming.getServiceName());
            DataserviceDto dataserviceDto = this.dataserviceService.getDataserviceDto(nodeBusiness.getDataServiceCode());
            if (dataserviceDto != null) {
                ModelTypeInfo modelType = ModelTypeRelationHolder.getInstance().getModelTypeBySolidClass(dataserviceDto.getClassName());
                nodeBusiness.setDataServiceActionName(modelType.getParamProviderClassName());
                nodeBusiness.setNodeType(modelType.getNodeType().getValue());
            } else {
                this.logError("\u6ca1\u6709\u627e\u5230\u56fa\u5316\u5c42", new Object[0]);
            }
            if (HussarUtils.isBlank((CharSequence)nodeBusiness.getJsonParams())) {
                nodeBusiness.setJsonParams(this.pm2JsonParams(context));
            }
            if (UpgradeContext7.contains(nodeBusiness.getNodeClass())) {
                nodeBusiness.setModelId(UpgradeContext7.get(nodeBusiness.getNodeClass()));
            } else {
                this.relationship2Model(context);
                this.pm2ModelColumns(context);
                nodeBusiness.setModelId(context.getRootRelatedId());
            }
            this.logicBusinessService.removeById((Object)logicBusiness);
            this.apiNamingService.updateById(apiNaming);
            this.nodeBusinessService.updateById((Object)nodeBusiness);
        });
    }

    private void fillTfModel() {
        ModelSyncService modelSyncService = (ModelSyncService)SpringContextUtil.getBean(ModelSyncService.class);
        if (modelSyncService == null) {
            return;
        }
        List nodeBusinessList = this.nodeBusinessService.list();
        if (HussarUtils.isEmpty((Object)nodeBusinessList)) {
            return;
        }
        Map path2NodeBusiness = nodeBusinessList.stream().collect(Collectors.toMap(x -> this.extractPathFromNodeName(x.getNodeName()), Function.identity(), (x1, x2) -> x1));
        List models = modelSyncService.getModelsByPath(new ArrayList<String>(path2NodeBusiness.keySet()));
        if (HussarUtils.isEmpty((Object)models)) {
            logger.error("modelSyncService \u83b7\u53d6\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6a21\u578b\u8def\u5f84\uff1a{}", path2NodeBusiness.keySet());
            return;
        }
        Map<String, List<ModelSyncDto>> path2Models = models.stream().collect(Collectors.groupingBy(ModelSyncDto::getModelPath));
        path2Models.forEach((path, tfmodels) -> {
            if (!path2NodeBusiness.containsKey(path)) {
                return;
            }
            NodeBusiness nodeBusiness = (NodeBusiness)path2NodeBusiness.get(path);
            List modelInfos = this.modelRelationshipService.getModelInfos(nodeBusiness.getModelId());
            if (HussarUtils.isNotEmpty((Object)modelInfos)) {
                this.matchAndFill((List<ModelSyncDto>)tfmodels, modelInfos);
                this.modelRelationshipService.updateModelInfos(modelInfos);
            }
        });
    }

    private void matchAndFill(List<ModelSyncDto> tfmodels, List<ModelInfo> modelInfos) {
        if (HussarUtils.isEmpty(tfmodels) || HussarUtils.isEmpty(modelInfos)) {
            return;
        }
        List tableIds = modelInfos.stream().map(ModelRelationship::getTableId).collect(Collectors.toList());
        List metadataTables = this.metadataTableService.listByIds(tableIds);
        Map tableName2Table = metadataTables.stream().collect(Collectors.toMap(MetadataTable::getTableName, Function.identity()));
        Map tableId2ModelInfo = modelInfos.stream().collect(Collectors.toMap(ModelRelationship::getTableId, Function.identity()));
        tfmodels.forEach(tfmodel -> {
            if (!tableName2Table.containsKey(tfmodel.getTableName())) {
                return;
            }
            MetadataTable theTable = (MetadataTable)tableName2Table.get(tfmodel.getTableName());
            if (!tableId2ModelInfo.containsKey(theTable.getTableId())) {
                return;
            }
            ModelInfo theModelInfo = (ModelInfo)tableId2ModelInfo.get(theTable.getTableId());
            theModelInfo.setTfmodelId(tfmodel.getTfModelId());
            theModelInfo.setType(tfmodel.getNodeType().getValue());
            theModelInfo.setParamName(tfmodel.getParamName());
            List tfcolumns = tfmodel.getColumns();
            if (HussarUtils.isNotEmpty((Object)tfcolumns)) {
                Map id2ModelColumn = theModelInfo.getModelColumns().stream().collect(Collectors.toMap(ModelColumns::getColumnAlias, Function.identity()));
                tfcolumns.forEach(tfcolumn -> {
                    if (id2ModelColumn.containsKey(tfcolumn.getColumnAlias())) {
                        ((ModelColumns)id2ModelColumn.get(tfcolumn.getColumnAlias())).setTfmodelColumnId(tfcolumn.getTfColumnId());
                    }
                });
            }
        });
    }

    private String extractPathFromNodeName(String nodeName) {
        if (StringUtil.isBlank((CharSequence)nodeName)) {
            return null;
        }
        String[] split = nodeName.split("\\.");
        return split.length > 3 ? split[1] + "." + split[2] : null;
    }

    private void afterClean() {
        this.nodeBusinessInoutService.remove(null);
        this.nodeBusinessPmService.remove(null);
        this.relationshipService.remove(null);
    }

    private String pm2JsonParams(UpgradeIteContext7 context) {
        NodeBusiness nodeBusiness = context.getNodeBusiness();
        ApiNaming apiNaming = context.getApiNaming();
        List inoutList = this.nodeBusinessInoutService.list((Wrapper)Wrappers.lambdaQuery(NodeBusinessInout.class).eq(NodeBusinessInout::getNodeId, (Object)nodeBusiness.getNodeId()));
        if (HussarUtils.isEmpty((Object)inoutList)) {
            return "";
        }
        List inoutIds = inoutList.stream().map(NodeBusinessInout::getInoutId).collect(Collectors.toList());
        List pmList = this.nodeBusinessPmService.list((Wrapper)Wrappers.lambdaQuery(NodeBusinessPm.class).in(NodeBusinessPm::getInoutId, inoutIds));
        this.ignoreSeriaFiledsForPm(pmList);
        context.setPmList(pmList);
        SingleTableDto singleTableDto = new SingleTableDto();
        singleTableDto.setBusinessId(apiNaming.getBusinessId());
        singleTableDto.setMethodDesc(nodeBusiness.getNodeDec());
        singleTableDto.setMethodName(nodeBusiness.getActionName());
        singleTableDto.setPagination(inoutList.stream().anyMatch(x -> x.getInoutType().equals("in") && x.getInoutAlias().equals("size")));
        singleTableDto.setResultTypeList(inoutList.stream().anyMatch(x -> x.getInoutType().equals("out") && x.getInoutAlias().equals("list")));
        Map<ParameterType, List<NodeBusinessPm>> type2PmList = pmList.stream().collect(Collectors.groupingBy(NodeBusinessPm::getParameterType));
        singleTableDto.setPmList(ListUtils.concat(type2PmList.get(ParameterType.column), type2PmList.get(ParameterType.set), type2PmList.get(ParameterType.values)));
        singleTableDto.setWhereList(type2PmList.get(ParameterType.where));
        singleTableDto.setSortVOList(type2PmList.get(ParameterType.order));
        logger.debug("pm transfer to jsonParams in node success");
        return JSON.toJSONString((Object)singleTableDto);
    }

    private void ignoreSeriaFiledsForPm(List<NodeBusinessPm> pmList) {
        if (HussarUtils.isEmpty(pmList)) {
            return;
        }
        pmList.forEach(x -> {
            x.setCreateTime(null);
            x.setCreator(null);
            x.setDelFlag(null);
            x.setInoutId(null);
            x.setLastEditor(null);
            x.setLastTime(null);
            x.setNodeId(null);
            x.setParameterId(null);
            x.setParameterDec(null);
        });
    }

    private void relationship2Model(UpgradeIteContext7 context) {
        if (NodeTypeEnum.isMs((String)context.getNodeType()).booleanValue()) {
            Relationship relationship = (Relationship)this.relationshipService.getById((Serializable)context.getModelId());
            if (relationship == null) {
                return;
            }
            List joinList = this.relationshipJoinService.list((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).eq(RelationshipJoin::getModelId, (Object)context.getModelId()));
            ArrayList<ModelRelationship> modelRelationships = new ArrayList<ModelRelationship>();
            ModelRelationship root = new ModelRelationship();
            root.setRelatedId(EngineUtil.getId());
            root.setParentPath("0");
            root.setTableId(relationship.getMasterTableId());
            root.setType(context.getNodeType());
            modelRelationships.add(root);
            context.setRootRelatedId(root.getRelatedId());
            UpgradeContext7.put(context.getNodeBusiness().getNodeClass(), context.getRootRelatedId());
            joinList.forEach(join -> {
                if (!join.getLeftTableId().equals(relationship.getMasterTableId())) {
                    this.logError("\u6709\u4e3b\u5b50\u5b50\u7684\u60c5\u51b5,\u65e0\u6cd5\u5904\u7406\uff0cmodelId: {}", context.getModelId());
                    return;
                }
                ModelRelationship model = new ModelRelationship();
                model.setRelatedId(EngineUtil.getId());
                model.setParentPath(root.getParentPath() + "," + root.getRelatedId());
                model.setTableId(join.getRightTableId());
                model.setType(context.getNodeType());
                model.setRelation(HussarUtils.isBlank((CharSequence)join.getParamName()) ? ModelRelation.ONE_ONE : ModelRelation.ONE_N);
                model.setParamName(join.getParamName());
                modelRelationships.add(model);
            });
            if (HussarUtils.isNotEmpty(modelRelationships)) {
                this.modelRelationshipService.saveBatch(modelRelationships);
                context.setModels(modelRelationships);
            }
        } else if (this.metadataTableService.getById((Serializable)context.getModelId()) != null) {
            ModelRelationship root = new ModelRelationship();
            root.setRelatedId(EngineUtil.getId());
            root.setParentPath("0");
            root.setTableId(context.getModelId());
            root.setType(context.getNodeType());
            this.modelRelationshipService.save((Object)root);
            context.setModels((List<ModelRelationship>)ImmutableList.of((Object)root));
            context.setRootRelatedId(root.getRelatedId());
            UpgradeContext7.put(context.getNodeBusiness().getNodeClass(), context.getRootRelatedId());
        } else {
            this.logError("\u5143\u6570\u636e\u4e2d\u6ca1\u6709\u627e\u5230tableId\uff1a{}", context.getModelId());
        }
    }

    private void pm2ModelColumns(UpgradeIteContext7 context) {
        List<NodeBusinessPm> pmList = context.getPmList();
        List<ModelRelationship> models = context.getModels();
        if (HussarUtils.isEmpty(pmList) || HussarUtils.isEmpty(models)) {
            return;
        }
        ArrayList modelColumns = new ArrayList();
        Map<Long, NodeBusinessPm> columnId2Pm = pmList.stream().collect(Collectors.toMap(NodeBusinessPm::getColumnId, x -> x, (x1, x2) -> x1));
        models.forEach(model -> {
            List columns = this.metadataColumnService.listByTableId(model.getTableId());
            if (HussarUtils.isEmpty((Object)columns)) {
                this.logError("\u5143\u6570\u636e\u8868\u5b57\u6bb5\u4e2d\u6ca1\u6709\u627e\u5230\u8868\u7684\u5b57\u6bb5\uff0c\u8868id\uff1a{}", model.getTableId());
                return;
            }
            columns.forEach(column -> {
                ModelColumns modelColumn = new ModelColumns();
                modelColumn.setModelColumnId(EngineUtil.getId());
                modelColumn.setColumnId(column.getColumnId());
                modelColumn.setColumnName(column.getColumnName());
                modelColumn.setRelatedId(model.getRelatedId());
                modelColumn.setColumnAlias(columnId2Pm.containsKey(column.getColumnId()) ? ((NodeBusinessPm)columnId2Pm.get(column.getColumnId())).getParameterAlias() : "");
                modelColumns.add(modelColumn);
            });
        });
        if (HussarUtils.isNotEmpty(modelColumns)) {
            this.modelColumnsService.saveBatch(modelColumns);
        }
    }

    private void thinTableRelations() {
        List relationshipJoins = this.relationshipJoinService.list();
        if (HussarUtils.isEmpty((Object)relationshipJoins)) {
            return;
        }
        ArrayList<RelationshipJoin> results = new ArrayList<RelationshipJoin>();
        ArrayList<RelationshipOn> ons = new ArrayList<RelationshipOn>();
        Map<String, List<RelationshipJoin>> unionId2Joins = relationshipJoins.stream().collect(Collectors.groupingBy(x -> x.getLeftTableId() + "," + x.getRightTableId() + "," + HussarUtils.isEmpty((Object)x.getParamName())));
        for (Map.Entry<String, List<RelationshipJoin>> next : unionId2Joins.entrySet()) {
            this.checkTableRelations(next.getValue());
            RelationshipJoin theJoin = next.getValue().get(0);
            theJoin.setRelation(HussarUtils.isBlank((CharSequence)theJoin.getParamName()) ? ModelRelation.ONE_ONE : ModelRelation.ONE_N);
            results.add(theJoin);
            List<RelationshipOn> tableOns = this.getTableOns(next.getValue().stream().map(RelationshipJoin::getId).collect(Collectors.toList()), theJoin.getLeftTableId(), theJoin.getRightTableId());
            tableOns.forEach(x -> {
                x.setId(EngineUtil.getId());
                x.setJoinId(theJoin.getId());
            });
            ons.addAll(tableOns);
        }
        if (HussarUtils.isNotEmpty(results)) {
            this.relationshipJoinService.remove(null);
            this.relationshipOnService.remove(null);
            this.relationshipJoinService.saveBatch(results);
            this.relationshipOnService.saveBatch(ons);
        }
    }

    private void checkTableRelations(List<RelationshipJoin> joins) {
        if (joins.size() > 1) {
            logger.debug("\u5b58\u5728\u91cd\u590d\u7684\u8868\u5173\u7cfb");
            long count = joins.stream().filter(x -> x.getParamName() == null).count();
            if (count != 0L && count != (long)joins.size()) {
                this.logError("\u5b58\u5728\u51b2\u7a81\u7684\u8868\u5173\u7cfb\uff0c\u5de6\u8868id\uff1a{}\uff0c\u53f3\u8868id\uff1a{}", joins.get(0).getLeftTableId(), joins.get(0).getRightTableId());
            }
        }
    }

    private List<RelationshipOn> getTableOns(List<Long> joins, Long leftTableId, Long rightTableId) {
        if (HussarUtils.isEmpty(joins)) {
            return new ArrayList<RelationshipOn>();
        }
        List relationShipOns = this.relationshipOnService.getRelationShipOns(joins);
        Map<Long, List<RelationshipOn>> joinId2Ons = relationShipOns.stream().collect(Collectors.groupingBy(RelationshipOn::getJoinId));
        this.checkTableOns(leftTableId, rightTableId, joinId2Ons.values().toArray());
        return joinId2Ons.get(joins.get(0));
    }

    private void checkTableOns(Long leftTableId, Long rightTableId, Object[] ons) {
        if (ons.length == 1) {
            return;
        }
        for (int i = 0; i < ons.length - 1; ++i) {
            boolean isEqual = this.relationshipJoinService.onEqual((List)ons[i], (List)ons[i + 1]);
            if (isEqual) continue;
            this.logError("\u5b58\u5728\u51b2\u7a81\u7684\u8868\u5b57\u6bb5\u5173\u8054\u5173\u7cfb\uff0c\u5de6\u8868id\uff1a{}\uff0c\u53f3\u8868id\uff1a{}", leftTableId, rightTableId);
        }
    }

    @Override
    public String getVersion() {
        return "8.2.1-beta.7-SNAPSHOT";
    }

    @Override
    public List<String> tablesForBackups() {
        return ImmutableList.of((Object)"SYS_HPE_UPGRADE_RECORD", (Object)"SYS_HPE_NODE_BUSINESS", (Object)"SYS_HPE_LOGIC_BUSINESS", (Object)"SYS_HE_API_NAMING", (Object)"SYS_HPE_NODE_BUSINESS_PM", (Object)"SYS_HPE_NODE_BUSINESS_INOUT", (Object)"SYS_HPE_RELATIONSHIP", (Object)"SYS_HPE_RELATIONSHIP_JOIN", (Object)"SYS_HPE_RELATIONSHIP_ON", (Object)"SYS_HPE_METADATA_TABLE", (Object)"SYS_HPE_METADATA_COLUMN", (Object)"SYS_HPE_MODEL_RELATIONSHIP", (Object[])new String[]{"SYS_HPE_MODEL_COLUMNS"});
    }
}

