/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.HttpBodyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.interceptor.BaseInterceptor;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.params.RmiParamsDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.RmiClientService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.SchemaDataGeneratorService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequestType;
import com.jxdinfo.hussar.support.rmi.core.interceptor.Interceptor;
import com.jxdinfo.hussar.support.rmi.core.utils.RmiApiDataType;
import com.jxdinfo.hussar.support.rmi.plugin.spring.file.SpringMultipartFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.support.engine.plugin.rmi.service.impl.rmiClientServiceImpl")
public class RmiClientServiceImpl
implements RmiClientService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmiClientServiceImpl.class);
    private final BaseInterceptor baseInterceptor;
    @Autowired
    private SchemaDataGeneratorService schemaDataGeneratorService;
    @Value(value="${hussar.support.engine.timeout:10000}")
    private Integer timeout;

    public RmiClientServiceImpl(ObjectProvider<BaseInterceptor> baseInterceptorObjectProvider) {
        this.baseInterceptor = (BaseInterceptor)baseInterceptorObjectProvider.getIfUnique();
    }

    @Override
    public Object invokeUrl(RmiParamsDto rmiParam) {
        HussarException.throwByNull((Object)rmiParam, (Integer)RmiExceptionEnum.PARAMS_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.PARAMS_EMPTY.getMessage());
        RmiApiRequest request = RmiApi.request();
        request.setTimeout(this.timeout.intValue());
        this.baseInterceptor.addAttribute(request, "isVerfy", rmiParam.isVerfy());
        if ("1".equals(rmiParam.isVerfy())) {
            this.baseInterceptor.addAttribute(request, "connectorApi", rmiParam.getApiConnector());
            this.baseInterceptor.addAttribute(request, "authCode", rmiParam.getAuthCode());
            if (HussarUtils.isNotEmpty((Object)rmiParam.getTokenKey())) {
                this.baseInterceptor.addAttribute(request, "tokenKey", rmiParam.getTokenKey());
            }
        }
        RmiApiRequestType rmiApiRequestType = RmiApiRequestType.findType((String)rmiParam.getMethodName());
        request.setType(rmiApiRequestType);
        if (HussarUtils.isNotEmpty((Object)rmiParam.getHost())) {
            if (rmiParam.getHost().contains(":")) {
                String[] hostarray = rmiParam.getHost().split(":");
                request.setHost(hostarray[0]);
                request.setPort(Integer.valueOf(hostarray[1]).intValue());
            } else {
                request.setHost(rmiParam.getHost());
            }
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getPort())) {
            request.setPort(Integer.valueOf(rmiParam.getPort()).intValue());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getPath())) {
            request.setPath(rmiParam.getPath());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getScheme())) {
            request.setScheme(rmiParam.getScheme());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getUrl())) {
            request.setUrl(rmiParam.getUrl());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getQueryMap())) {
            request.addQuery(rmiParam.getQueryMap());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getHeaderMap())) {
            request.addHeader(rmiParam.getHeaderMap());
        } else {
            HttpServletRequest currentRequest;
            Enumeration headerNames;
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null && !HussarUtils.isEmpty((Object)requestAttributes) && (headerNames = (currentRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getHeaderNames()) != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    if (this.isAntiReplayHeader(headerName)) continue;
                    String headerValue = currentRequest.getHeader(headerName);
                    request.addHeader(headerName, (Object)headerValue);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getBodyObj())) {
            request.addBody(rmiParam.getBodyObj());
            if (request.getType().equals((Object)RmiApiRequestType.GET)) {
                request.setBackend("httpclient");
            }
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getDataTypeStr())) {
            request.setDataType(RmiApiDataType.findByName((String)rmiParam.getDataTypeStr()));
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getContentType()) && RmiApiRequestType.POST.equals((Object)rmiApiRequestType)) {
            HttpBodyEnum httpBodyEnum = HttpBodyEnum.findByType(rmiParam.getContentType());
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)httpBodyEnum)), (Integer)RmiExceptionEnum.CONNECT_TYPE_ERROR.getExceptionCode(), (String)RmiExceptionEnum.CONNECT_TYPE_ERROR.getMessage());
            request.setContentType(httpBodyEnum.getVal());
            if (HussarUtils.equals((Object)((Object)HttpBodyEnum.FORM), (Object)((Object)httpBodyEnum))) {
                MultiValueMap<String, MultipartFile> multiFileMap = rmiParam.getMultiFileMap();
                ArrayList rmiApiMultiparts = new ArrayList();
                for (Map.Entry entry : multiFileMap.entrySet()) {
                    if (!HussarUtils.isNotEmpty(entry.getValue())) continue;
                    ((List)entry.getValue()).forEach(m -> {
                        SpringMultipartFile rmiApiMultipart = new SpringMultipartFile();
                        rmiApiMultipart.setFileName(m.getOriginalFilename());
                        rmiApiMultipart.setName((String)entry.getKey());
                        rmiApiMultipart.setContentType(m.getContentType());
                        rmiApiMultipart.setData(m);
                        rmiApiMultiparts.add(rmiApiMultipart);
                    });
                }
                request.setMultiparts(rmiApiMultiparts);
            }
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getOnSuccess())) {
            request.setOnSuccess(rmiParam.getOnSuccess());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getOnError())) {
            request.setOnError(rmiParam.getOnError());
        }
        if (HussarUtils.isNotEmpty((Object)rmiParam.getSuccessWhen())) {
            request.setSuccessWhen(rmiParam.getSuccessWhen());
        }
        request.addInterceptor((Interceptor)this.baseInterceptor);
        String outParamsSchema = rmiParam.getOutParamsSchema();
        boolean format = rmiParam.isFormat();
        if (HussarUtils.isNotEmpty((Object)outParamsSchema) && format) {
            request.onSuccess((data, req, res) -> {
                try {
                    Object result = this.schemaDataGeneratorService.generateFormattedData(outParamsSchema, data);
                    res.setResult(result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HussarException("\u8fde\u63a5\u5668\u63a5\u53e3\u51fa\u53c2\u8f6c\u6362\u5931\u8d25");
                }
            });
        }
        request.onError((ex, req, res) -> {
            LOGGER.error(ex.getMessage());
            HussarException.throwBy((boolean)true, (String)ex.getMessage());
        });
        if (HussarUtils.isNotEmpty(rmiParam.getReturnClassType())) {
            return request.execute(rmiParam.getReturnClassType());
        }
        return request.execute();
    }

    private boolean isAntiReplayHeader(String headerName) {
        String lowerHeaderName = headerName.toLowerCase();
        return lowerHeaderName.contains("timestamp") || lowerHeaderName.contains("nonce") || lowerHeaderName.contains("signature") || lowerHeaderName.contains("checkcode") || lowerHeaderName.contains("data-digest") || lowerHeaderName.contains("jstime") || lowerHeaderName.contains("uniqueid") || lowerHeaderName.equals("x-request-id") || lowerHeaderName.startsWith("anti-replay");
    }
}

