/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.gateway.executor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.plugin.node.gateway.executor.GatewayExecutor;
import com.jxdinfo.hussar.support.engine.plugin.node.gateway.handler.NodeBusinessGatewayHandler;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;

@Component
public class HandlerExecutor
implements GatewayExecutor {
    private NodeBusinessGatewayHandler<T> handlerChain;
    @Autowired
    private ObjectProvider<List<NodeBusinessGatewayHandler>> gatewayHandlers;

    @PostConstruct
    public void init() {
        List gatewayHandlerList = (List)this.gatewayHandlers.getIfAvailable();
        if (HussarUtils.isNotEmpty((Object)gatewayHandlerList)) {
            NodeBusinessGatewayHandler nodeBusinessGatewayHandler = null;
            AnnotationAwareOrderComparator.sort((List)gatewayHandlerList);
            for (NodeBusinessGatewayHandler handler : gatewayHandlerList) {
                if (nodeBusinessGatewayHandler != null) {
                    nodeBusinessGatewayHandler.setNext(handler);
                }
                nodeBusinessGatewayHandler = handler;
                handler.setLast((NodeBusinessGatewayHandler)gatewayHandlerList.get(gatewayHandlerList.size() - 1));
            }
            this.handlerChain = (NodeBusinessGatewayHandler)gatewayHandlerList.get(0);
        }
    }

    public void execute(String nodeName, Map<String, Object> params, NodeBusinessVo nodeBusinessVo) {
        this.handlerChain.execute(nodeName, params, nodeBusinessVo);
    }
}

