/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.gateway.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.factory.ApiActionFactory;
import com.jxdinfo.hussar.support.engine.core.enums.FlowMethodEnum;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.node.gateway.AbstractNodeBusinessGatewayHandler;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class DynamicApiGatewayHandler
extends AbstractNodeBusinessGatewayHandler<Boolean> {
    @Override
    public Boolean support(String nodeName, Map<String, Object> params, NodeBusinessVo nodeBusinessVo) {
        if (HussarUtils.isNotEmpty((Object)nodeBusinessVo.getActionName())) {
            return true;
        }
        NodeBusinessVo businessVo = ApiActionFactory.getDynamicApiAction((String)(nodeName = this.getDynamicNodeName(nodeName, (ModelTableMappingDTO)params.get("modelTableMapping"))));
        if (HussarUtils.isNotEmpty((Object)businessVo)) {
            BeanUtils.copyProperties((Object)businessVo, (Object)nodeBusinessVo, (String[])new String[]{"nodeName"});
            return true;
        }
        return false;
    }

    private String getDynamicNodeName(String nodeName, ModelTableMappingDTO modelTableMapping) {
        String nodeType;
        String string = nodeType = HussarUtils.isEmpty((Object)modelTableMapping.getSlaveTables()) ? NodeTypeEnum.SINGLE.getValue() : NodeTypeEnum.MASTER.getValue();
        if (nodeName.endsWith("SaveBatchMore")) {
            nodeType = NodeTypeEnum.SINGLE.getValue();
        }
        String httpType = nodeName.substring(0, nodeName.indexOf(".") + 1);
        String engineBusinessId = nodeName.substring(nodeName.lastIndexOf(".") + 1);
        if (this.processQueryList.contains(engineBusinessId) && modelTableMapping.getAllModels().size() > 2) {
            engineBusinessId = "Ms" + engineBusinessId;
        } else if (this.mssMethodList.contains(engineBusinessId) || this.mssMethods.contains(engineBusinessId) && modelTableMapping.hasGrandSonTable()) {
            nodeType = NodeTypeEnum.MULTI_MASTER.getValue();
        } else if (HussarUtils.isNotEmpty((Object)FlowMethodEnum.getByValue((String)engineBusinessId)) && modelTableMapping.hasGrandSonTable()) {
            nodeType = NodeTypeEnum.MULTI_MASTER.getValue();
        }
        return httpType + nodeType + engineBusinessId;
    }

    public int getOrder() {
        return 30000;
    }
}

