/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.RelationshipOnMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipOnService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RelationshipOnServiceImpl
extends HussarServiceImpl<RelationshipOnMapper, RelationshipOn>
implements RelationshipOnService {
    @Override
    public List<RelationshipOnDto> getRelationShipOnDto(List<Long> relationShipIds) {
        List<RelationshipOn> list = this.getRelationShipOns(relationShipIds);
        if (HussarUtils.isEmpty(list)) {
            return new ArrayList<RelationshipOnDto>();
        }
        return BeanUtil.copyToList(list, RelationshipOnDto.class);
    }

    @Override
    public List<RelationshipOn> getRelationShipOns(List<Long> relationShipIds) {
        if (HussarUtils.isEmpty(relationShipIds)) {
            return new ArrayList<RelationshipOn>();
        }
        return this.list((Wrapper)Wrappers.lambdaQuery(RelationshipOn.class).in(RelationshipOn::getJoinId, relationShipIds));
    }

    @Override
    public boolean removeByJoinIds(List<Long> joinIds) {
        if (HussarUtils.isEmpty(joinIds)) {
            return false;
        }
        return this.remove((Wrapper)Wrappers.lambdaQuery(RelationshipOn.class).in(RelationshipOn::getJoinId, joinIds));
    }

    @Override
    public void batchUpdateByJoinId(List<RelationshipOn> ons) {
        if (HussarUtils.isEmpty(ons)) {
            return;
        }
        ons.forEach(x -> HussarException.throwBy((x.getJoinId() == null ? 1 : 0) != 0, (String)"\u5b58\u5728\u5173\u8054id\u4e3a\u7a7a\u7684\u5b57\u6bb5\u5173\u8054\u5173\u7cfb"));
        this.removeByJoinIds(ons.stream().map(RelationshipOn::getJoinId).distinct().collect(Collectors.toList()));
        this.saveBatch(ons);
    }
}

