/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.sqlmodel.builder;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.JoinInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.plugin.model.constant.SQLModelConstant;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BasicSQLBuilder {
    @Autowired
    private DynamicDatasourceService datasourceService;

    public String buildSQLModelStatement(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        ArrayList<SQLModelColumnDto> allColumns = new ArrayList<SQLModelColumnDto>();
        ArrayList<JoinInfoDto> allJoinInfo = new ArrayList<JoinInfoDto>();
        this.addColumns(modelInfoDto, allColumns, allJoinInfo);
        JoinInfoDto firstRelationShip = (JoinInfoDto)allJoinInfo.get(0);
        Map tfModelId2TableAlias = modelMapDto.getTableAliasMap();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT \n");
        int count = 0;
        for (SQLModelColumnDto sqlModelColumnDto : allColumns) {
            ++count;
            String tableAlias = (String)tfModelId2TableAlias.get(sqlModelColumnDto.getTfModelId());
            if (this.getDbType() == DbType.MYSQL) {
                stringBuilder.append(String.format("%s.`%s` \"%s\"", tableAlias, sqlModelColumnDto.getColumnName(), sqlModelColumnDto.getColumnAlias()));
            } else {
                stringBuilder.append(String.format("%s.%s \"%s\"", tableAlias, sqlModelColumnDto.getColumnName(), sqlModelColumnDto.getColumnAlias()));
            }
            if (count < allColumns.size()) {
                stringBuilder.append(",\n");
                continue;
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("FROM \n");
        stringBuilder.append(String.format("(%s) %s\n", this.getSubQuerySQL(firstRelationShip.getLeftTableName(), firstRelationShip.getLeftTfModelId()), tfModelId2TableAlias.get(firstRelationShip.getLeftTfModelId())));
        for (JoinInfoDto joinInfoDto : allJoinInfo) {
            String joinTypeValue = joinInfoDto.getJoinType().value;
            String rightTableName = joinInfoDto.getRightTableName();
            String leftTfModelId = joinInfoDto.getLeftTfModelId();
            String leftTableAlias = (String)tfModelId2TableAlias.get(leftTfModelId);
            String rightTfModelId = joinInfoDto.getRightTfModelId();
            String rightTableAlias = (String)tfModelId2TableAlias.get(rightTfModelId);
            String leftColumnName = joinInfoDto.getLeftColumnName();
            String rightColumnName = joinInfoDto.getRightColumnName();
            if (this.getDbType() == DbType.MYSQL) {
                stringBuilder.append(String.format("%s (%s) %s ON %s.`%s` = %s.`%s`\n", joinTypeValue, this.getSubQuerySQL(rightTableName, rightTfModelId), rightTableAlias, leftTableAlias, leftColumnName, rightTableAlias, rightColumnName));
                continue;
            }
            stringBuilder.append(String.format("%s (%s) %s ON %s.%s = %s.%s\n", joinTypeValue, this.getSubQuerySQL(rightTableName, rightTfModelId), rightTableAlias, leftTableAlias, leftColumnName, rightTableAlias, rightColumnName));
        }
        return stringBuilder.toString();
    }

    private void addColumns(ModelInfoDto modelInfoDto, List<SQLModelColumnDto> columnList, List<JoinInfoDto> allJoinInfo) {
        List fieldList = modelInfoDto.getFieldList();
        for (ModelFieldDto field : fieldList) {
            SQLModelColumnDto sqlModelColumnDto = new SQLModelColumnDto();
            sqlModelColumnDto.setColumnName(field.getFieldName());
            sqlModelColumnDto.setColumnAlias(field.getFieldAlias());
            sqlModelColumnDto.setTfModelId(modelInfoDto.getModelId());
            columnList.add(sqlModelColumnDto);
        }
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getJoinInfo())) {
            allJoinInfo.add(modelInfoDto.getJoinInfo());
        }
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) {
            for (ModelInfoDto child : modelInfoDto.getChildren()) {
                this.addColumns(child, columnList, allJoinInfo);
            }
        }
    }

    private String getSubQuerySQL(String tableName, String tfModelId) {
        return String.format("SELECT * FROM %s ${%s}", tableName, SQLModelConstant.DATA_ACCESS_SQL_PREFIX + tfModelId);
    }

    private DbType getDbType() {
        return this.datasourceService.getCurrentDatasource().getDbType();
    }

    public static class SQLModelColumnDto {
        @ApiModelProperty(value="\u5217\u540d")
        private String columnName;
        @ApiModelProperty(value="\u5217\u522b\u540d")
        private String columnAlias;
        @ApiModelProperty(value="\u5929\u65a7\u6a21\u578bid")
        private String tfModelId;

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnAlias() {
            return this.columnAlias;
        }

        public void setColumnAlias(String columnAlias) {
            this.columnAlias = columnAlias;
        }

        public String getTfModelId() {
            return this.tfModelId;
        }

        public void setTfModelId(String tfModelId) {
            this.tfModelId = tfModelId;
        }
    }
}

