/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.entity.Relationship;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipJoin;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.service.RelationshipService;
import com.jxdinfo.hussar.support.engine.core.util.CacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.RelationshipMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipJoinService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipOnService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RelationshipServiceImpl
extends HussarServiceImpl<RelationshipMapper, Relationship>
implements RelationshipService {
    private final RelationshipJoinService relationshipJoinService;
    private final RelationshipOnService relationshipOnService;
    private final HussarMetadataService metadataService;

    public RelationshipServiceImpl(RelationshipJoinService relationshipJoinService, RelationshipOnService relationshipOnService, HussarMetadataService metadataService) {
        this.relationshipJoinService = relationshipJoinService;
        this.relationshipOnService = relationshipOnService;
        this.metadataService = metadataService;
    }

    public RelationshipDto getRelationshipById(Long id) {
        return (RelationshipDto)CacheUtil.get((String)("engine:relationship:" + id), () -> ((RelationshipMapper)this.baseMapper).getRelationshipById(id));
    }

    public RelationshipDto getRelationshipByName(String modelName) {
        return ((RelationshipMapper)this.baseMapper).getRelationshipByName(modelName);
    }

    @DSTransactional
    public boolean saveRelationship(RelationshipDto relationshipDto) {
        Relationship copy = (Relationship)BeanUtil.copy((Object)relationshipDto, Relationship.class);
        assert (copy != null);
        this.saveOrUpdate((BaseEntity)copy);
        List joinDtoList = relationshipDto.getJoinDtoList();
        ArrayList<RelationshipJoin> joinList = new ArrayList<RelationshipJoin>();
        ArrayList onList = new ArrayList();
        for (RelationshipJoinDto joinDto : joinDtoList) {
            RelationshipJoin join = (RelationshipJoin)BeanUtil.copy((Object)joinDto, RelationshipJoin.class);
            assert (join != null);
            join.setModelId(copy.getId());
            joinList.add(join);
            List onCopyList = BeanUtil.copy((Collection)joinDto.getOnDtoList(), RelationshipOn.class);
            Long id = HussarUtils.isNotEmpty((Object)join.getId()) ? join.getId() : EngineUtil.getId();
            join.setId(id);
            this.setOnParentId(onCopyList, id);
            onList.addAll(onCopyList);
        }
        List list = this.relationshipJoinService.list((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).select(new SFunction[]{RelationshipJoin::getId}).eq(RelationshipJoin::getModelId, (Object)copy.getId()));
        List joinId = list.stream().map(RelationshipJoin::getId).collect(Collectors.toList());
        this.relationshipJoinService.remove((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).eq(RelationshipJoin::getModelId, (Object)copy.getId()));
        this.relationshipJoinService.saveOrUpdateBatch(joinList);
        if (!joinId.isEmpty()) {
            this.relationshipOnService.remove((Wrapper)Wrappers.lambdaQuery(RelationshipOn.class).in(RelationshipOn::getJoinId, joinId));
        }
        this.relationshipOnService.saveOrUpdateBatch(onList);
        this.metadataService.cleanResultMap(String.format("ms.%s.%s", copy.getId(), copy.getModelName()));
        CacheUtil.evict((String)("engine:relationship:" + copy.getId()));
        return true;
    }

    private void setOnParentId(List<RelationshipOn> onCopyList, Long id) {
        for (RelationshipOn on : onCopyList) {
            on.setJoinId(id);
        }
    }
}

