/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.google.common.collect.ImmutableList;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.model.ModelRelationshipDto;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IModelResultMapService;
import com.jxdinfo.hussar.support.engine.plugin.model.assembler.ModelTableAssembler;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.ModelStructure;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.TableRelation;
import com.jxdinfo.hussar.support.engine.plugin.model.exception.ModelTableMappingException;
import com.jxdinfo.hussar.support.engine.plugin.model.exception.PluginModelValidateException;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsRulesService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelSerialNumService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelTitleService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipJoinService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class EnginePluginModelApp
implements IEnginePluginModelApp {
    private static final String MODEL_CACHE = "engine:model:";
    private static final String TF_MODEL_CACHE = "engine:tf:model:";
    private static final Logger logger = LoggerFactory.getLogger(EnginePluginModelApp.class);
    @Autowired
    private RelationshipJoinService relationshipJoinService;
    @Autowired
    private ModelRelationshipService modelRelationshipService;
    @Autowired
    private MetadataColumnService metadataColumnService;
    @Autowired
    private MetadataTableService metadataTableService;
    @Autowired
    private ModelColumnsService modelColumnsService;
    @Autowired
    private ModelColumnsRulesService rulesService;
    @Autowired
    private IModelResultMapService modelResultMapService;
    @Resource
    private NodeBusinessService nodeBusinessService;
    @Resource
    private ApiNamingService apiNamingService;
    @Autowired
    private ModelSerialNumService modelSerialNumService;
    @Autowired
    private ModelTitleService modelTitleService;

    public void save(List<ModelPublishDTO> modelPublish) {
        this.validate(modelPublish);
        List<ModelRelationship> oldModels = this.modelRelationshipService.batchSaveModels(modelPublish);
        modelPublish.forEach(x -> {
            DefaultCacheUtil.evict((Object)(MODEL_CACHE + x.getRelatedId()));
            DefaultCacheUtil.evict((Object)(TF_MODEL_CACHE + x.getTfmodelId()));
        });
        if (modelPublish.size() > 1) {
            List<Long> oldModelIds = oldModels.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
            this.relationshipJoinService.modelPublishSave(modelPublish, oldModelIds);
        }
        Optional<ModelPublishDTO> root = modelPublish.stream().filter(x -> "0".equals(x.getParentPath())).findFirst();
        root.ifPresent(modelPublishDTO -> {
            ModelTableMappingDTO modelTableMapping = this.getModelTableMapping(modelPublishDTO.getTfmodelId());
            this.modelResultMapService.cleanResultMap(modelTableMapping);
            this.modelResultMapService.createResultMap(modelTableMapping);
        });
    }

    @DSTransactional
    public void delete(String tfModelId) {
        List nodeList;
        List<ModelRelationship> deleteModels = this.modelRelationshipService.deleteRelations(tfModelId);
        if (HussarUtils.isEmpty(deleteModels)) {
            logger.error("\u5220\u9664\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6a21\u578b\uff0c\u5929\u65a7\u6a21\u578bID\uff1a{}", (Object)tfModelId);
            return;
        }
        this.metadataTableService.deleteByTableIds(deleteModels.stream().map(ModelRelationship::getTableId).collect(Collectors.toList()), this.modelRelationshipService::getExistTableIds);
        List<Long> relatedIds = deleteModels.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        this.modelColumnsService.deleteByRelatedIds(relatedIds);
        this.rulesService.deleteByRelatedIds(relatedIds);
        this.relationshipJoinService.deleteByRelatedIds(relatedIds);
        Optional<ModelRelationship> rootId = deleteModels.stream().filter(x -> x.getParentPath().equals("0")).findFirst();
        if (rootId.isPresent() && HussarUtils.isNotEmpty((Object)(nodeList = this.nodeBusinessService.deleteByModelId(rootId.get().getRelatedId())))) {
            this.apiNamingService.deleteByServiceName(nodeList.stream().map(NodeBusiness::getNodeName).collect(Collectors.toList()));
        }
    }

    private void validate(List<ModelPublishDTO> modelPublish) {
        PluginModelValidateException.throwBy(HussarUtils.isEmpty(modelPublish), "\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (modelPublish.size() == 1) {
            ModelPublishDTO item = modelPublish.get(0);
            this.commonValidate(item);
            PluginModelValidateException.throwBy(item.getRelation() != null, "\u5355\u8868\u4fdd\u5b58\u4e0d\u5141\u8bb8\u6709\u8868\u4e4b\u95f4\u7684\u5173\u7cfb");
            PluginModelValidateException.throwBy(!item.getParentPath().equals("0"), "\u5355\u5355\u8868\u7684parentPath\u9ed8\u8ba4\u4e3a0");
            PluginModelValidateException.throwBy(NodeTypeEnum.isMs((String)item.getType()), "\u5355\u8868\u7684type\u4e0d\u5f97\u4e3a\u4e3b\u5b50");
            PluginModelValidateException.throwBy(HussarUtils.isNotEmpty((Object)item.getOns()), "\u5355\u8868\u7684\u5173\u8054\u5b57\u6bb5\u5e94\u8be5\u4e3a\u7a7a");
        } else {
            long count = modelPublish.stream().map(ModelRelationship::getTfmodelId).distinct().count();
            PluginModelValidateException.throwBy((int)count != modelPublish.size(), "\u6a21\u578bid\u51fa\u73b0\u91cd\u590d");
            Set tableIds = modelPublish.stream().map(ModelRelationship::getTableId).collect(Collectors.toSet());
            List metadataTables = this.metadataTableService.listByIds(tableIds);
            PluginModelValidateException.throwBy(metadataTables == null || metadataTables.size() != tableIds.size(), "\u6a21\u578b\u7684tableId\u5728\u5143\u6570\u636e\u8868\u4e2d\u6ca1\u6709\u627e\u5230");
            List metadataColumns = this.metadataColumnService.listByTableIds(new ArrayList(tableIds));
            Map<Long, Boolean> columnIdMap = metadataColumns.stream().collect(Collectors.toMap(MetadataColumn::getColumnId, x -> true));
            PluginModelValidateException.throwBy(modelPublish.stream().anyMatch(x -> x.getRelatedId() == null), "\u4e3b\u5b50\u6a21\u578b\u5173\u7cfb\u7684relatedId\u4e0d\u5f97\u4e3a\u7a7a");
            Map<Long, ModelPublishDTO> id2ModelPublish = modelPublish.stream().collect(Collectors.toMap(ModelRelationship::getRelatedId, x -> x));
            modelPublish.forEach(x -> {
                this.commonValidate((ModelPublishDTO)x);
                List modelColumns = x.getModelColumns();
                modelColumns.forEach(y -> PluginModelValidateException.throwBy(!columnIdMap.containsKey(y.getColumnId()), "\u6a21\u578b\u5217\u5728\u5143\u6570\u636e\u4e2d\u672a\u627e\u5230"));
                if (HussarUtils.isNotEmpty((Object)x.getOns())) {
                    x.getOns().forEach(z -> PluginModelValidateException.throwBy(!columnIdMap.containsKey(z.getLeftColumnId()) || !columnIdMap.containsKey(z.getRightColumnId()), "\u6a21\u578b\u5173\u8054\u5217\u5728\u5143\u6570\u636e\u4e2d\u672a\u627e\u5230"));
                }
                if (x.getParentPath().equals("0")) {
                    PluginModelValidateException.throwBy(NodeTypeEnum.isMs((String)x.getType()) == false, "\u4e3b\u5b50\u6a21\u578b\u7684type\u5e94\u4e3a\u4e3b\u5b50\u7c7b\u578b\u6216sql\u6a21\u578b");
                    PluginModelValidateException.throwBy(HussarUtils.isNotEmpty((Object)x.getOns()), "\u4e3b\u6a21\u578b\u4e0d\u5e94\u8be5\u6709\u5173\u8054\u5b57\u6bb5");
                    return;
                }
                PluginModelValidateException.throwBy(x.getRelation() == null, "\u5b50\u6a21\u578b\u7684relation\u5b57\u6bb5\u4e0d\u5f97\u4e3a\u7a7a");
                PluginModelValidateException.throwBy(HussarUtils.isEmpty((Object)x.getOns()), "\u5b50\u6a21\u578b\u7684\u5173\u8054\u5b57\u6bb5\u4e0d\u5f97\u4e3a\u7a7a");
                PluginModelValidateException.throwBy(NodeTypeEnum.isMs((String)x.getType()) == false, "\u4e3b\u5b50\u6a21\u578b\u7684type\u5e94\u4e3a\u4e3b\u5b50\u7c7b\u578b");
                PluginModelValidateException.throwBy(HussarUtils.isBlank((CharSequence)x.getParamName()), "\u5b50\u6a21\u578b\u7684paramName\u4e0d\u5f97\u4e3a\u7a7a");
                PluginModelValidateException.throwBy(!id2ModelPublish.containsKey(x.getParentId()), "\u5b50\u6a21\u578b\u7684\u7236\u8def\u5f84\u6709\u8bef");
                long aliasCount = modelColumns.stream().map(ModelColumns::getColumnAlias).distinct().count();
                PluginModelValidateException.throwBy((int)aliasCount != modelColumns.size(), "\u6a21\u578b\u5b57\u6bb5\u540d\u51fa\u73b0\u91cd\u590d");
            });
        }
    }

    private void commonValidate(ModelPublishDTO modelPublish) {
        PluginModelValidateException.throwBy(HussarUtils.isBlank((CharSequence)modelPublish.getParentPath()), "parentPath\u4e0d\u5f97\u4e3a\u7a7a");
        PluginModelValidateException.throwBy(HussarUtils.isEmpty((Object)modelPublish.getModelColumns()), "\u6a21\u578b\u7684\u5b57\u6bb5\u4e0d\u5f97\u4e3a\u7a7a");
        PluginModelValidateException.throwBy(HussarUtils.isBlank((CharSequence)modelPublish.getType()), "type\u5b57\u6bb5\u4e0d\u5f97\u4e3a\u7a7a");
        PluginModelValidateException.throwBy(HussarUtils.isBlank((CharSequence)modelPublish.getTfmodelId()), "\u5929\u65a7\u6a21\u578bid\u4e0d\u5f97\u4e3a\u7a7a");
        PluginModelValidateException.throwBy(modelPublish.getTableId() == null, "\u8868id\u4e0d\u5f97\u4e3a\u7a7a");
    }

    public Long getModelId(String tfModelId) {
        return this.modelRelationshipService.getModelId(tfModelId);
    }

    private List<TableRelation> saveAndGetDropTableRelations(List<ModelPublishDTO> modelPublish) {
        List<ModelRelationship> oldModels = this.modelRelationshipService.batchSaveModels(modelPublish);
        if (HussarUtils.isNotEmpty(oldModels)) {
            oldModels.forEach(x -> DefaultCacheUtil.evict((Object)(MODEL_CACHE + x.getRelatedId())));
            oldModels.forEach(x -> DefaultCacheUtil.evict((Object)(TF_MODEL_CACHE + x.getTfmodelId())));
            List newModels = BeanUtil.copyToList(modelPublish, ModelRelationship.class);
            return this.getDropRelations(newModels, oldModels);
        }
        return new ArrayList<TableRelation>();
    }

    private List<TableRelation> getDropRelations(List<ModelRelationship> newRelationships, List<ModelRelationship> oldRelationships) {
        List<TableRelation> news = this.list2Relation(newRelationships);
        List<TableRelation> olds = this.list2Relation(oldRelationships);
        return olds.stream().filter(x -> !this.hasOldRelation((TableRelation)x, news)).collect(Collectors.toList());
    }

    private boolean hasOldRelation(TableRelation old, List<TableRelation> news) {
        for (TableRelation x : news) {
            if (!Objects.equals(x.getLeftTableId(), old.getLeftTableId()) || !Objects.equals(x.getRightTableId(), old.getRightTableId()) || !x.getRelation().equals((Object)old.getRelation())) continue;
            return true;
        }
        return false;
    }

    private List<TableRelation> list2Relation(List<ModelRelationship> relationships) {
        if (HussarUtils.isEmpty(relationships)) {
            return new ArrayList<TableRelation>();
        }
        Map<Long, ModelRelationship> relatedId2Item = relationships.stream().collect(Collectors.toMap(ModelRelationship::getRelatedId, x -> x));
        ArrayList<TableRelation> relations = new ArrayList<TableRelation>();
        relationships.forEach(x -> {
            if ("0".equals(x.getParentPath())) {
                return;
            }
            ModelRelationship parent = (ModelRelationship)relatedId2Item.get(x.getParentId());
            relations.add(new TableRelation(parent.getTableId(), x.getTableId(), x.getRelation(), x.getRelatedId()));
        });
        return relations;
    }

    @Override
    public ModelTableMappingDTO getModelTableMapping(Long relatedId) {
        ModelTableMappingDTO result = (ModelTableMappingDTO)DefaultCacheUtil.get((Object)(MODEL_CACHE + relatedId));
        if (HussarUtils.isNotEmpty((Object)result)) {
            return result;
        }
        ModelStructure modelStructure = this.modelRelationshipService.getModelStructure(relatedId);
        ModelTableMappingException.throwBy(modelStructure == null, "\u6ca1\u6709\u627e\u5230\u6a21\u578b");
        if (HussarUtils.isNotEmpty(modelStructure.getChildren())) {
            List<RelationshipJoinDto> relationJoins = this.relationshipJoinService.getRelationJoins(modelStructure.getTableRelation());
            result = ModelTableAssembler.toModelTableMappingDTO(modelStructure.getTableId(), relationJoins);
        } else {
            MetadataTable table = (MetadataTable)this.metadataTableService.getById((Serializable)modelStructure.getTableId());
            result = ModelTableMappingDTO.create((MetadataTable)table);
        }
        this.mapping(result, modelStructure, null, null);
        ModelRelationship modelRelationship = (ModelRelationship)this.modelRelationshipService.getById(relatedId);
        this.setModelType(result, modelRelationship.getType());
        DefaultCacheUtil.put((Object)(MODEL_CACHE + relatedId), (Object)result, (long)3600L);
        return result;
    }

    private void setModelType(ModelTableMappingDTO result, String type) {
        result.setModelType(type);
        if (HussarUtils.isNotEmpty((Object)result.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : result.getSlaveTables()) {
                this.setModelType(slaveTable, type);
            }
        }
    }

    public ModelTableMappingDTO getModelTableMapping(String tfModelId) {
        ModelTableMappingDTO result = (ModelTableMappingDTO)DefaultCacheUtil.get((Object)(TF_MODEL_CACHE + tfModelId));
        if (HussarUtils.isNotEmpty((Object)result)) {
            return result;
        }
        ModelRelationship modelRelationship = this.modelRelationshipService.getModelRelationship(tfModelId);
        if (HussarUtils.isEmpty((Object)modelRelationship)) {
            return null;
        }
        result = this.getModelTableMapping(modelRelationship.getRelatedId());
        DefaultCacheUtil.put((Object)(TF_MODEL_CACHE + tfModelId), (Object)result, (long)3600L);
        return result;
    }

    public ModelRelationshipDto getModelByTfModelId(String tfModelId) {
        ModelRelationship modelRelationship = this.modelRelationshipService.getModelRelationship(tfModelId);
        if (modelRelationship == null) {
            return null;
        }
        ModelRelationshipDto result = (ModelRelationshipDto)BeanUtil.copy((Object)modelRelationship, ModelRelationshipDto.class);
        List<ModelColumns> modelColumns = this.modelColumnsService.getModelColumns((List<Long>)ImmutableList.of((Object)result.getRelatedId()));
        result.setModelColumns(modelColumns);
        return result;
    }

    public List<ModelRelationshipDto> getModelsByTfModelIds(List<String> tfModelIds) {
        List<ModelRelationship> relationshipList = this.modelRelationshipService.getModelRelationships(tfModelIds);
        ArrayList<ModelRelationshipDto> resultList = new ArrayList<ModelRelationshipDto>();
        relationshipList.forEach(r -> resultList.add((ModelRelationshipDto)BeanUtil.copy((Object)r, ModelRelationshipDto.class)));
        return resultList;
    }

    public int batchUpdateSerialNum(String tfModelId) {
        ModelTableMappingDTO model = this.getModelTableMapping(tfModelId);
        if (model == null) {
            return 0;
        }
        List allSerialRule = model.getAllSerialRule();
        if (HussarUtils.isEmpty((Object)allSerialRule)) {
            return 0;
        }
        ModelColumnsRules rules = (ModelColumnsRules)allSerialRule.get(0);
        return this.modelSerialNumService.batchUpdateSerialNum(model.getPollName(), model.getColumns(), rules);
    }

    public int batchUpdateTitle(String tfModelId) throws InterruptedException {
        ModelTableMappingDTO model = this.getModelTableMapping(tfModelId);
        if (model == null) {
            return 0;
        }
        List allTitleRule = model.getAllTitleRule();
        if (HussarUtils.isEmpty((Object)allTitleRule)) {
            return 0;
        }
        ModelColumnsRules rules = (ModelColumnsRules)allTitleRule.get(0);
        return this.modelTitleService.updateAllTitle(model.getPollName(), model, rules);
    }

    public TableInfoDto getTableInfoByTfModelId(String tfModelId) {
        ModelRelationship modelRelationship = this.modelRelationshipService.getModelRelationship(tfModelId);
        if (HussarUtils.isEmpty((Object)modelRelationship)) {
            return null;
        }
        return this.metadataTableService.getTableInfoByTableId(modelRelationship.getTableId());
    }

    public List<TableInfoDto> getTableInfosByTfModelIds(List<String> tfModelIds) {
        List<ModelRelationship> modelRelationships = this.modelRelationshipService.getModelRelationships(tfModelIds);
        if (HussarUtils.isEmpty(modelRelationships)) {
            return null;
        }
        ArrayList tableIds = new ArrayList();
        modelRelationships.forEach(mr -> tableIds.add(mr.getTableId()));
        return this.metadataTableService.getTableInfosByTableIds(tableIds);
    }

    @Override
    public List<ModelTableMappingDTO> getModelTableMapping() {
        ArrayList<ModelTableMappingDTO> results = new ArrayList<ModelTableMappingDTO>();
        List<ModelRelationship> allRootNodes = this.modelRelationshipService.getAllRootNodes();
        if (HussarUtils.isEmpty(allRootNodes)) {
            return results;
        }
        allRootNodes.forEach(root -> results.add(this.getModelTableMapping(root.getRelatedId())));
        return results;
    }

    private void mapping(ModelTableMappingDTO table, ModelStructure model, ModelTableMappingDTO parentTable, ModelStructure parentModel) {
        if (!this.isMatching(table, model)) {
            throw new ModelTableMappingException("\u6a21\u578b\u7ed3\u6784\u548c\u8868\u7ed3\u6784\u4e0d\u5339\u914d");
        }
        table.setRelation(model.getRelation());
        table.setParamName(model.getParamName());
        table.setRelatedId(model.getRelatedId());
        table.setParentPath(model.getParentPath());
        table.setTfModelId(model.getTfmodelId());
        this.setColumns(table, model, parentTable, parentModel);
        this.setRules(table);
        if (HussarUtils.isNotEmpty((Object)table.getSlaveTables())) {
            table.getSlaveTables().forEach(tItem -> this.mapping((ModelTableMappingDTO)tItem, model.getChildren().stream().filter(mItem -> mItem.getTableId().equals(tItem.getTableId())).findFirst().orElse(null), table, model));
        }
    }

    private boolean isMatching(ModelTableMappingDTO table, ModelStructure model) {
        return table != null && model != null && table.getTableId().equals(model.getTableId()) && table.getSlaveTables().size() == model.getChildren().size();
    }

    private void setRules(ModelTableMappingDTO table) {
        List<ModelColumnsRules> rules = this.rulesService.getRulesByRelatedId(table.getRelatedId());
        if (HussarUtils.isNotEmpty(rules)) {
            table.setRules(rules);
        }
    }

    private void setColumns(ModelTableMappingDTO table, ModelStructure model, ModelTableMappingDTO parentTable, ModelStructure parentModel) {
        List columns = this.metadataColumnService.listColumnDtoByTableId(table.getTableId());
        ArrayList modelColumnDtos = new ArrayList();
        Map<Long, ModelColumns> columnId2ModelColumnRight = model.getColumns().stream().collect(Collectors.toMap(ModelColumns::getColumnId, x -> x, (k1, k2) -> k1));
        columns.forEach(column -> {
            if (columnId2ModelColumnRight.containsKey(column.getColumnId())) {
                ModelColumnDto modelColumnDto = (ModelColumnDto)BeanUtil.copy((Object)column, ModelColumnDto.class);
                modelColumnDto.setColumnAlias(((ModelColumns)columnId2ModelColumnRight.get(column.getColumnId())).getColumnAlias());
                modelColumnDto.setModelColumnId(((ModelColumns)columnId2ModelColumnRight.get(column.getColumnId())).getModelColumnId());
                modelColumnDto.setTfModelId(table.getTfModelId());
                modelColumnDtos.add(modelColumnDto);
            }
        });
        table.setColumns(modelColumnDtos);
        if (parentTable != null && parentModel != null) {
            List columnOns = table.getColumnOns();
            Map<Long, ModelColumnDto> columnId2TableColumnRight = table.getColumns().stream().collect(Collectors.toMap(MetadataColumn::getColumnId, x -> x, (k1, k2) -> k1));
            Map<Long, ModelColumnDto> columnId2TableColumnLeft = parentTable.getColumns().stream().collect(Collectors.toMap(MetadataColumn::getColumnId, x -> x, (k1, k2) -> k1));
            Map<Long, ModelColumns> columnId2ModelColumnLeft = parentModel.getColumns().stream().collect(Collectors.toMap(ModelColumns::getColumnId, x -> x, (k1, k2) -> k1));
            columnOns.forEach(columnOn -> {
                if (columnId2TableColumnLeft.containsKey(columnOn.getLeftColumnId()) && columnId2TableColumnRight.containsKey(columnOn.getRightColumnId())) {
                    ModelColumnDto leftColumn = (ModelColumnDto)columnId2TableColumnLeft.get(columnOn.getLeftColumnId());
                    ModelColumnDto rightColumn = (ModelColumnDto)columnId2TableColumnRight.get(columnOn.getRightColumnId());
                    if (columnId2ModelColumnLeft.containsKey(columnOn.getLeftColumnId()) && columnId2ModelColumnRight.containsKey(columnOn.getRightColumnId())) {
                        leftColumn.setColumnAlias(((ModelColumns)columnId2ModelColumnLeft.get(columnOn.getLeftColumnId())).getColumnAlias());
                        rightColumn.setColumnAlias(((ModelColumns)columnId2ModelColumnRight.get(columnOn.getRightColumnId())).getColumnAlias());
                    }
                    columnOn.setLeftColumn((MetadataColumnDto)leftColumn);
                    columnOn.setRightColumn((MetadataColumnDto)rightColumn);
                }
            });
        }
    }
}

