/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.action.assemble;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsRulesService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class ModelAssembleAction {
    @Autowired
    protected ModelRelationshipService modelRelationshipService;
    @Autowired
    protected MetadataTableService metadataTableService;
    @Autowired
    protected ModelColumnsRulesService modelColumnsRulesService;

    public abstract List<ModelRelationship> getModelRelationshipsFromDto(ModelInfoDto var1);

    public List<ModelPublishDTO> assembleModelPublishDtos(List<ModelRelationship> relationshipList, ModelMapDto modelMapDto) {
        ArrayList<ModelPublishDTO> publishDTOList = new ArrayList<ModelPublishDTO>();
        for (ModelRelationship relationship : relationshipList) {
            ModelPublishDTO publishDTO = new ModelPublishDTO();
            TableInfoDto tableInfoDto = (TableInfoDto)modelMapDto.getTableInfoDtoMap().get(relationship.getTableId());
            publishDTO.setModelColumns(this.getModelColumnsFromDto(tableInfoDto, relationship.getTfmodelId(), modelMapDto, relationship.getTfmodelName()));
            publishDTO.setParamName(relationship.getParamName());
            publishDTO.setParentPath(relationship.getParentPath());
            publishDTO.setRelatedId(EngineUtil.getId());
            modelMapDto.getRelatedIdMap().put(relationship.getRelatedId(), publishDTO.getRelatedId());
            publishDTO.setTableId((Long)modelMapDto.getMetadataTableIdMap().get(relationship.getTableId()));
            publishDTO.setTfmodelId((String)modelMapDto.getTableNameModelIdMap().get(tableInfoDto.getTableName()));
            publishDTO.setTfmodelName(relationship.getTfmodelName());
            publishDTO.setType(relationship.getType());
            publishDTO.setModelColumnsRules(this.getColumnRulesFromOldData((List)modelMapDto.getColumnRuleListMap().get(relationship.getTfmodelId())));
            publishDTO.setRelation(relationship.getRelation());
            publishDTOList.add(publishDTO);
        }
        this.addRelationshipOn(publishDTOList);
        this.updatePathPathFromDto(publishDTOList, modelMapDto);
        return publishDTOList;
    }

    public abstract void addRelationshipOn(List<ModelPublishDTO> var1);

    public abstract void addTfModelIdToParam(List<MetadataParam> var1, ModelInfoDto var2, ModelMapDto var3);

    public void updatePathPathFromDto(List<ModelPublishDTO> publishDTOList, ModelMapDto modelMapDto) {
        if (HussarUtils.isEmpty(publishDTOList)) {
            return;
        }
        for (ModelPublishDTO publishDTO : publishDTOList) {
            String parentPath = publishDTO.getParentPath();
            if ("0".equals(parentPath)) continue;
            String[] paths = parentPath.split(",");
            ArrayList<String> pathList = new ArrayList<String>();
            for (String relatedId : paths) {
                Long newRelatedId = (Long)modelMapDto.getRelatedIdMap().get(Long.valueOf(relatedId));
                if (HussarUtils.isEmpty((Object)newRelatedId)) {
                    pathList.add(relatedId);
                    continue;
                }
                pathList.add(String.valueOf(newRelatedId));
            }
            publishDTO.setParentPath(CollectionUtil.join(pathList, (CharSequence)","));
        }
    }

    public List<TableInfoDto> getTableInfoDtoFromRelations(List<ModelRelationship> relationshipList) {
        if (HussarUtils.isEmpty(relationshipList)) {
            return new ArrayList<TableInfoDto>();
        }
        return this.metadataTableService.getTableInfosByTableIds(relationshipList.stream().map(ModelRelationship::getTableId).collect(Collectors.toList()));
    }

    public List<ModelColumnsRules> getColumnRulesFromRelations(List<ModelRelationship> relationshipList) {
        if (HussarUtils.isEmpty(relationshipList)) {
            return new ArrayList<ModelColumnsRules>();
        }
        List relateIds = relationshipList.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        return this.modelColumnsRulesService.list((Wrapper)new LambdaQueryWrapper().in(ModelColumnsRules::getRelatedId, relateIds));
    }

    public MetadataParam getMetadataParamFromOldData(TableInfoDto tableInfoDto, ModelMapDto modelMapDto) {
        MetadataParam param = new MetadataParam();
        Long tableId = EngineUtil.getId();
        modelMapDto.getMetadataTableIdMap().put(tableInfoDto.getTableId(), tableId);
        tableInfoDto.setTableId(tableId);
        modelMapDto.getTableIdMap().put(tableInfoDto.getTableName(), tableInfoDto.getTableId());
        tableInfoDto.getColumnList().forEach(c -> {
            Long columnId = EngineUtil.getId();
            c.setColumnId(columnId);
            modelMapDto.getColumnIdMap().put(tableInfoDto.getTableName() + c.getColumnName(), c.getColumnId());
        });
        param.setTableInfo(tableInfoDto);
        param.setColumnInfo(this.getColumnInfosFromOldData(tableInfoDto.getColumnList()));
        return param;
    }

    public List<ColumnInfoDto> getColumnInfosFromOldData(List<MetadataColumn> columnList) {
        ArrayList<ColumnInfoDto> columnInfoDtoList = new ArrayList<ColumnInfoDto>();
        for (MetadataColumn metadataColumn : columnList) {
            ColumnInfoDto columnInfoDto = this.getColumnInfoFromOldData(metadataColumn);
            columnInfoDtoList.add(columnInfoDto);
        }
        return columnInfoDtoList;
    }

    public ColumnInfoDto getColumnInfoFromOldData(MetadataColumn metadataColumn) {
        ColumnInfoDto columnInfoDto = new ColumnInfoDto();
        columnInfoDto.setColumnId(metadataColumn.getColumnId());
        columnInfoDto.setColumnAlias(metadataColumn.getColumnAlias());
        columnInfoDto.setColumnName(metadataColumn.getColumnName());
        columnInfoDto.setDataIsEmpty(metadataColumn.getDataIsEmpty());
        columnInfoDto.setDataLength(metadataColumn.getDataLength());
        columnInfoDto.setDataType(metadataColumn.getDataType());
        columnInfoDto.setJavaType(metadataColumn.getJavaType());
        columnInfoDto.setJdbcType(metadataColumn.getJdbcType());
        columnInfoDto.setNeedChangeIsRequired(false);
        columnInfoDto.setPurpose(metadataColumn.getPurpose());
        if ("primary".equals(metadataColumn.getPurpose())) {
            columnInfoDto.setPk("1");
            columnInfoDto.setPrimarys("1");
        } else {
            columnInfoDto.setPk("0");
            columnInfoDto.setPrimarys("0");
        }
        columnInfoDto.setRequired("0");
        return columnInfoDto;
    }

    public List<Long> getParentIdsFromParentPath(ModelRelationship relationship) {
        Object[] parentIdStrList = relationship.getParentPath().split(",");
        if (HussarUtils.isEmpty((Object[])parentIdStrList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (Object idStr : parentIdStrList) {
            if ("0".equals(idStr)) continue;
            parentIds.add(Long.valueOf((String)idStr));
        }
        return parentIds;
    }

    public List<MetadataParam> getMetadataParamsFromTableInfos(List<TableInfoDto> tableInfoDtoList, ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        if (HussarUtils.isEmpty(tableInfoDtoList)) {
            return new ArrayList<MetadataParam>();
        }
        ArrayList<MetadataParam> paramList = new ArrayList<MetadataParam>();
        tableInfoDtoList.forEach(t -> {
            modelMapDto.getTableInfoDtoMap().put(t.getTableId(), t);
            paramList.add(this.getMetadataParamFromOldData((TableInfoDto)t, modelMapDto));
        });
        this.addTfModelIdToParam(paramList, modelInfoDto, modelMapDto);
        return paramList;
    }

    public List<ModelColumns> getModelColumnsFromDto(TableInfoDto tableInfoDto, String tfModelId, ModelMapDto modelMapDto, String tableName) {
        ArrayList<ModelColumns> modelColumnsList = new ArrayList<ModelColumns>();
        if (HussarUtils.isEmpty((Object)tableInfoDto) || HussarUtils.isEmpty((Object)tableInfoDto.getColumnList())) {
            return modelColumnsList;
        }
        for (MetadataColumn metadataColumn : tableInfoDto.getColumnList()) {
            ModelColumns modelColumns = new ModelColumns();
            modelColumns.setColumnAlias(metadataColumn.getColumnAlias());
            modelColumns.setColumnName(metadataColumn.getColumnName());
            modelColumns.setTfmodelColumnId(metadataColumn.getColumnName());
            modelColumns.setColumnId(metadataColumn.getColumnId());
            modelColumns.setTfmodelId(tfModelId);
            modelColumnsList.add(modelColumns);
        }
        return modelColumnsList;
    }

    public List<ModelColumnsRules> getColumnRulesFromOldData(List<ModelColumnsRules> oldRuleList) {
        ArrayList<ModelColumnsRules> modelColumnsRulesList = new ArrayList<ModelColumnsRules>();
        if (HussarUtils.isEmpty(oldRuleList)) {
            return modelColumnsRulesList;
        }
        for (ModelColumnsRules columnsRule : oldRuleList) {
            ModelColumnsRules modelColumnsRule = new ModelColumnsRules();
            modelColumnsRule.setColumnAlias(columnsRule.getColumnAlias());
            modelColumnsRule.setRuleContent(columnsRule.getRuleContent());
            modelColumnsRule.setRuleType(columnsRule.getRuleType());
            modelColumnsRulesList.add(modelColumnsRule);
        }
        return modelColumnsRulesList;
    }
}

