/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.util;

import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;

public class ModelResultMapUtil {
    private static final Map<String, Integer> TABLE_SHORT_NAME = new HashMap<String, Integer>();
    private static Integer INTEGER = 0;

    public static String getTableShortName(String tableName) {
        Integer number = TABLE_SHORT_NAME.computeIfAbsent(tableName, k -> {
            INTEGER = INTEGER + 1;
            return INTEGER;
        });
        int i = number % 260;
        return (char)(i / 10 + 97) + String.valueOf(i % 10);
    }

    public static String getResultMappingColumn(String tableAlias, String columnAlias) {
        return String.format("%s%s", ModelResultMapUtil.getTableShortName(tableAlias.toLowerCase()), columnAlias);
    }

    public static List<ResultMapping> getResultMappings(ModelTableMappingDTO singleTable, Boolean isMasterTable, Configuration configuration) throws ClassNotFoundException {
        return ModelResultMapUtil.getResultMappingsWithProperty(singleTable, isMasterTable, configuration, new HashMap<Long, String>(), false);
    }

    public static List<ResultMapping> getResultMappingsWithProperty(ModelTableMappingDTO singleTable, Boolean isMasterTable, Configuration configuration, Map<Long, String> propertyMap, Boolean isContainSlave) throws ClassNotFoundException {
        List columns;
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        List list = columns = isContainSlave != false ? singleTable.getAllColumns() : singleTable.getColumns();
        if (HussarUtils.isNotEmpty((Object)columns)) {
            for (MetadataColumnDto columnDto : columns) {
                String columnAlias = Optional.ofNullable(propertyMap.get(columnDto.getColumnId())).orElse(columnDto.getColumnAlias());
                ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
                if (isMasterTable.booleanValue() && HussarUtils.isNotBlank((CharSequence)columnDto.getPrimarys())) {
                    flags.add(ResultFlag.ID);
                }
                resultMappings.add(new ResultMapping.Builder(configuration, columnAlias, ModelResultMapUtil.getResultMappingColumn(columnDto.getTableName(), columnAlias), columnDto.javaType()).flags(flags).build());
            }
        }
        return resultMappings;
    }

    public static ResultMap getResultMap(String singleResultMapId, List<ResultMapping> resultMappings, Configuration configuration) {
        return new ResultMap.Builder(configuration, singleResultMapId, EngineResultEntity.class, resultMappings).build();
    }

    public static <T> List<T> limit(List<T> records, int skipNum, int sizeNum) {
        if (HussarUtils.isEmpty(records) || skipNum < 0 || sizeNum < 0) {
            return new ArrayList();
        }
        return records.stream().skip(skipNum).limit(sizeNum).collect(Collectors.toList());
    }
}

