/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.dto;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.TableRelation;
import java.util.ArrayList;
import java.util.List;

public class ModelStructure {
    private Long relatedId;
    private Long tableId;
    private ModelRelation relation;
    private String paramName;
    private String parentPath;
    private List<ModelColumns> columns = new ArrayList<ModelColumns>();
    private List<ModelStructure> children = new ArrayList<ModelStructure>();
    private String tfmodelId;

    public static ModelStructure create(ModelRelationship ship) {
        ModelStructure modelStructure = new ModelStructure();
        modelStructure.setTableId(ship.getTableId());
        modelStructure.setRelatedId(ship.getRelatedId());
        modelStructure.setRelation(ship.getRelation());
        modelStructure.setParamName(ship.getParamName());
        modelStructure.setTfmodelId(ship.getTfmodelId());
        modelStructure.setParentPath(ship.getParentPath());
        return modelStructure;
    }

    public void addChildren(ModelStructure modelStructure) {
        this.children.add(modelStructure);
    }

    public List<TableRelation> getTableRelation() {
        if (HussarUtils.isEmpty(this.children)) {
            return null;
        }
        ArrayList<TableRelation> results = new ArrayList<TableRelation>();
        this.children.forEach(child -> {
            results.add(new TableRelation(this.tableId, child.tableId, child.getRelation(), child.getRelatedId()));
            List<TableRelation> childRelations = child.getTableRelation();
            if (HussarUtils.isNotEmpty(childRelations)) {
                results.addAll(childRelations);
            }
        });
        return results;
    }

    public Long getRelatedId() {
        return this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public List<ModelColumns> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ModelColumns> columns) {
        this.columns = columns;
    }

    public List<ModelStructure> getChildren() {
        return this.children;
    }

    public void setChildren(List<ModelStructure> children) {
        this.children = children;
    }

    public ModelRelation getRelation() {
        return this.relation;
    }

    public void setRelation(ModelRelation relation) {
        this.relation = relation;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setTfmodelId(String tfmodelId) {
        this.tfmodelId = tfmodelId;
    }

    public String getTfmodelId() {
        return this.tfmodelId;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }
}

