/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.adaptation.operate;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ModelOperationTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.operate.ModelOperateAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.factory.ModelSaveFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.assembler.ModelParamAssembler;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ModelAddAction
extends ModelOperateAction {
    public ModelAddAction() {
        ModelSaveFactory.addOperateAction(ModelOperationTypeEnum.ADD.getValue(), this);
    }

    @Override
    @DSTransactional
    public void saveModel(ModelInfoDto modelInfoDto) throws SQLException {
        ModelMapDto modelMapDto = new ModelMapDto();
        List tableInfoDtoList = this.modelRelateService.getTableInfosByTfModelIds(this.getTfModelIdsFromDto(modelInfoDto));
        Map<Object, Object> tableInfoDtoMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)tableInfoDtoList)) {
            tableInfoDtoList.forEach(t -> this.addTableAndColumnIdToMap((TableInfoDto)t, modelMapDto));
            tableInfoDtoMap = tableInfoDtoList.stream().collect(Collectors.toMap(MetadataTable::getTableName, Function.identity(), (t1, t2) -> t1));
        }
        List<MetadataParam> paramList = ModelParamAssembler.getMetadataParamsFromDto(modelInfoDto, modelMapDto);
        ModelParamAssembler.addOnsFromDto(modelInfoDto, modelMapDto);
        for (MetadataParam param : paramList) {
            MetadataParam ddlParam;
            TableInfoDto tableInfoDto = (TableInfoDto)tableInfoDtoMap.get(param.getTableInfo().getTableName());
            ModelInfoDto currentModelInfoDto = (ModelInfoDto)modelMapDto.getModelInfoDtoMap().get(param.getTfModelId());
            if (HussarUtils.isEmpty((Object)currentModelInfoDto)) continue;
            if (currentModelInfoDto.isSyncToTable()) {
                ddlParam = this.getDdlMetadataParam(param);
                this.hussarDdlService.createTable(ddlParam);
            } else if (currentModelInfoDto.getFieldList().stream().anyMatch(ModelFieldDto::isSyncToTable)) {
                ddlParam = this.getDdlMetadataParam(param);
                List oldColumnInfo = ddlParam.getColumnInfo().stream().filter(c -> c.getOperation().equals("edit")).collect(Collectors.toList());
                this.hussarDdlService.editTable(ddlParam, oldColumnInfo, ddlParam.getTableInfo().getTableName());
            }
            this.hussarDdlService.updateIndex(param);
            if (HussarUtils.isNotEmpty((Object)tableInfoDto)) {
                this.hussarMetadataService.updateTableInfo(param);
                continue;
            }
            this.hussarMetadataService.insertTableInfo(param);
        }
        List<ModelPublishDTO> publishDTOList = ModelParamAssembler.getModelPublishDtosFromDtos(Collections.singletonList(modelInfoDto), modelMapDto);
        if (HussarUtils.isNotEmpty(publishDTOList)) {
            this.modelRelateService.save(publishDTOList);
        }
    }
}

