/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.ModelColumnsRulesMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsRulesService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelTitleService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelColumnsRulesServiceImpl
extends HussarServiceImpl<ModelColumnsRulesMapper, ModelColumnsRules>
implements ModelColumnsRulesService {
    private ConcurrentHashMap<Long, Long> lockMap = new ConcurrentHashMap();
    @Autowired
    private ModelTitleService modelTitleService;
    @Autowired
    private MetadataTableService metadataTableService;

    @Override
    public List<ModelColumnsRules> getRulesByModelColumnIds(List<Long> modelColumnIds) {
        if (HussarUtils.isEmpty(modelColumnIds)) {
            return new ArrayList<ModelColumnsRules>();
        }
        return this.list((Wrapper)Wrappers.lambdaQuery(ModelColumnsRules.class).in(ModelColumnsRules::getModelColumnId, modelColumnIds));
    }

    @Override
    public List<ModelColumnsRules> getRulesByModel(Long modelId, String ruleType) {
        if (HussarUtils.isEmpty((Object)modelId)) {
            return new ArrayList<ModelColumnsRules>();
        }
        return this.list((Wrapper)this.getQueryWrapper(ruleType).eq(ModelColumnsRules::getRelatedId, (Object)modelId));
    }

    @Override
    public List<ModelColumnsRules> getRulesByRelatedId(long relatedId) {
        return this.list((Wrapper)Wrappers.lambdaQuery(ModelColumnsRules.class).eq(ModelColumnsRules::getRelatedId, (Object)relatedId));
    }

    @Override
    public List<ModelColumnsRules> getRulesByRelatedIdList(List<Long> relatedIds) {
        if (HussarUtils.isEmpty(relatedIds)) {
            return new ArrayList<ModelColumnsRules>();
        }
        return this.list((Wrapper)Wrappers.lambdaQuery(ModelColumnsRules.class).in(ModelColumnsRules::getRelatedId, relatedIds));
    }

    private LambdaQueryWrapper<ModelColumnsRules> getQueryWrapper(String ruleType) {
        return (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ModelColumnsRules.class).eq(HussarDelflagEntity::getDelFlag, (Object)0)).eq(HussarUtils.isNotBlank((CharSequence)ruleType), ModelColumnsRules::getRuleType, (Object)ruleType);
    }

    @Override
    public Map<Long, List<ModelColumnsRules>> getRulesByModels(List<Long> modelId, String ruleType) {
        if (HussarUtils.isEmpty(modelId)) {
            return new HashMap<Long, List<ModelColumnsRules>>();
        }
        List list = this.list((Wrapper)this.getQueryWrapper(ruleType).in(ModelColumnsRules::getRelatedId, modelId));
        return list.stream().collect(Collectors.groupingBy(ModelColumnsRules::getRelatedId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRules(List<ModelColumns> modelColumns, List<ModelColumnsRules> newRules, Long modelId, Long tableId) {
        Long oldLock;
        if (modelId == null || tableId == null || HussarUtils.isEmpty(newRules)) {
            return;
        }
        Long lock = this.lockMap.get(modelId);
        if (lock == null && (oldLock = this.lockMap.putIfAbsent(modelId, lock = modelId)) != null) {
            lock = oldLock;
        }
        Long l = lock;
        synchronized (l) {
            this.removeByRelatedIds(Collections.singletonList(modelId));
            if (HussarUtils.isNotEmpty(newRules)) {
                this.saveBatch(newRules);
            }
        }
    }

    @Override
    public void saveRules(List<ModelColumnsRules> newRules, List<Long> modelIds) {
        if (HussarUtils.isEmpty(newRules) || HussarUtils.isEmpty(modelIds)) {
            return;
        }
        this.removeByRelatedIds(modelIds);
        this.saveBatch(newRules);
    }

    @Override
    public void deleteByRelatedIds(List<Long> relatedIds) {
        if (HussarUtils.isEmpty(relatedIds)) {
            return;
        }
        this.removeByRelatedIds(relatedIds);
    }

    private void removeByRelatedIds(List<Long> relatedIds) {
        this.remove((Wrapper)Wrappers.lambdaQuery(ModelColumnsRules.class).in(ModelColumnsRules::getRelatedId, relatedIds));
    }
}

