/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.date.DateUtil;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.EngineDateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DmlWhereEntityUtil {
    static OperatorType[] denyOperatorTypes = new OperatorType[]{OperatorType.NE, OperatorType.NOT_IN, OperatorType.NOT_LIKE, OperatorType.NOT_LEFT_LIKE, OperatorType.NOT_RIGHT_LIKE, OperatorType.NOT_BETWEEN, OperatorType.USER_NE, OperatorType.USER_NOT_IN};

    public static List<WhereEntity> whereIntuitionRebuild(List<WhereEntity> whereEntities) {
        if (HussarUtils.isEmpty(whereEntities)) {
            return whereEntities;
        }
        ArrayList<WhereEntity> results = new ArrayList<WhereEntity>();
        whereEntities.forEach(whereEntity -> {
            if (whereEntity.getOperatorType() != null && DmlWhereEntityUtil.containsDenyCondtion(whereEntity) && !whereEntity.isNoll()) {
                Long parentId = EngineUtil.getId();
                WhereEntity parent = new WhereEntity();
                parent.setId(parentId);
                parent.setParentId(whereEntity.getParentId());
                parent.setMatchType(whereEntity.getMatchType());
                results.add(parent);
                whereEntity.setParentId(parentId);
                whereEntity.setMatchType(MatchTypeEnum.OR);
                results.add((WhereEntity)whereEntity);
                WhereEntity nullWhere = new WhereEntity();
                nullWhere.setParentId(parentId);
                nullWhere.setOperatorType(OperatorType.IS_NULL);
                nullWhere.setColumnEntity(whereEntity.getColumnEntity());
                nullWhere.setMatchType(MatchTypeEnum.OR);
                nullWhere.setParamColumnAlias(whereEntity.getParamColumnAlias());
                nullWhere.initVal(new HashMap<String, Object>());
                results.add(nullWhere);
            } else {
                results.add((WhereEntity)whereEntity);
            }
        });
        return results;
    }

    private static boolean containsDenyCondtion(WhereEntity whereEntity) {
        for (OperatorType item : denyOperatorTypes) {
            if (item != whereEntity.getOperatorType()) continue;
            return whereEntity.getColumnEntity() == null || !PurposeEnum.DEL_FLAG.getValue().equals(whereEntity.getColumnEntity().getPurpose());
        }
        return false;
    }

    public static void resetWhereEntity(WhereEntity whereEntity) {
        if (HussarUtils.isNotBlank((CharSequence)whereEntity.getDefaultValue()) && LocalDateTime.class.getName().equals(whereEntity.getColumnEntity().getColJavaType()) && (whereEntity.getOperatorType() == OperatorType.EQ || whereEntity.getOperatorType() == OperatorType.NE || whereEntity.getOperatorType() == OperatorType.GE || whereEntity.getOperatorType() == OperatorType.GT || whereEntity.getOperatorType() == OperatorType.LE || whereEntity.getOperatorType() == OperatorType.LT)) {
            List<LocalDateTime> startEnd = EngineDateUtil.getStartEnd(whereEntity.getDefaultValue());
            if (HussarUtils.isEmpty(startEnd)) {
                return;
            }
            switch (whereEntity.getOperatorType()) {
                case EQ: {
                    whereEntity.setOperatorType(OperatorType.BETWEEN);
                    whereEntity.setDefaultValue(CollectionUtil.join(startEnd, (CharSequence)",", DateUtil::formatLocalDateTime));
                    break;
                }
                case NE: {
                    whereEntity.setOperatorType(OperatorType.NOT_BETWEEN);
                    whereEntity.setDefaultValue(CollectionUtil.join(startEnd, (CharSequence)",", DateUtil::formatLocalDateTime));
                    break;
                }
                case GT: 
                case LE: {
                    whereEntity.setDefaultValue(DateUtil.formatLocalDateTime((LocalDateTime)startEnd.get(1)));
                    break;
                }
                case GE: 
                case LT: {
                    whereEntity.setDefaultValue(DateUtil.formatLocalDateTime((LocalDateTime)startEnd.get(0)));
                    break;
                }
            }
        }
    }
}

