/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.solidorg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.DataserviceInout;
import com.jxdinfo.hussar.support.engine.api.model.GhDataInOutDto;
import com.jxdinfo.hussar.support.engine.api.model.SQLModel;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.impl.DbAndBpmGainDataGhService;
import com.jxdinfo.hussar.support.engine.core.annotations.SolidService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.TableEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectBySQLEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlParamUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlWhereEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.SQLModelExtendInfo;
import com.jxdinfo.hussar.support.engine.plugin.model.service.SQLModelService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;

@SolidService(value="com.jxdinfo.hussar.support.engine.plugin.dml.support.service.solidorg.SQLModelDataGhServiceImpl", type=NodeTypeEnum.SQL, des="SQL\u6a21\u578b\u5e95\u5c42\u8c03\u7528\u4ee5\u53ca\u62fc\u88c5\u53c2\u6570\u56fa\u5316\u903b\u8f91")
public class SQLModelDataGhServiceImpl
extends DbAndBpmGainDataGhService {
    @Autowired
    private SQLModelService sqlModelService;
    @Autowired
    private DynamicDatasourceService datasourceService;
    @Autowired
    private IEnginePluginModelApp enginePluginModelApp;

    public SQLModelDataGhServiceImpl(DataserviceService dataserviceService) {
        super(dataserviceService);
    }

    public Object[] getParam(String methodName, List<GhDataInOutDto> inList, Object ... arg) {
        Object[] objects = new Object[inList.size()];
        for (DataserviceInout dataserviceInout : inList) {
            String javaType = dataserviceInout.getInoutJavaType();
            if (IPage.class.getName().equals(javaType)) {
                Page<EngineResult> engineResultPage;
                objects[dataserviceInout.getOrderRow().intValue() - 1] = engineResultPage = this.getPage(arg);
                continue;
            }
            if (CustomSqlDto.class.getName().equals(javaType)) {
                objects[dataserviceInout.getOrderRow().intValue() - 1] = this.getCustomSqlDto(methodName, arg);
                continue;
            }
            objects[dataserviceInout.getOrderRow().intValue() - 1] = this.getEntity(methodName, arg);
        }
        return objects;
    }

    private Page<EngineResult> getPage(Object[] arg) {
        HussarException.throwByNull((Object)(arg.length == 0 || !(arg[0] instanceof Map) ? 1 : 0), (Integer)EngineExceptionEnum.PARAM_FAIL.getExceptionCode(), (String)EngineExceptionEnum.PARAM_FAIL.getMessage());
        Map param = (Map)arg[0];
        return DmlParamUtil.getPage(param);
    }

    private Object getEntity(String methodName, Object[] arg) {
        HussarException.throwBy((arg.length < 2 || !(arg[1] instanceof NodeBusinessVo) ? 1 : 0) != 0, (Integer)EngineExceptionEnum.PARAM_FAIL.getExceptionCode(), (String)EngineExceptionEnum.PARAM_FAIL.getMessage());
        Map param = (Map)arg[0];
        ModelTableMappingDTO modelTableMapping = this.enginePluginModelApp.getModelTableMapping((String)param.get("tfModelId"));
        SQLModel sqlModel = this.sqlModelService.getModelByTfId((String)param.get("tfModelId"));
        SelectBySQLEntity selectBySQLEntity = new SelectBySQLEntity();
        selectBySQLEntity.setModel(modelTableMapping);
        selectBySQLEntity.setSqlModel(sqlModel);
        selectBySQLEntity.setBasicSql(sqlModel.getSQLStatement());
        selectBySQLEntity.setParam(param);
        selectBySQLEntity.setDbType(this.getDbType());
        selectBySQLEntity.setConnName(modelTableMapping.getPollName());
        selectBySQLEntity.setResultMapId(String.format("ms.%s", modelTableMapping.getRelatedId()));
        selectBySQLEntity.init();
        return selectBySQLEntity;
    }

    private DbType getDbType() {
        return this.datasourceService.getCurrentDatasource().getDbType();
    }

    public CustomSqlDto getCustomSqlDto(String methodName, Object[] arg) {
        HussarException.throwBy((arg.length < 2 || !(arg[1] instanceof NodeBusinessVo) ? 1 : 0) != 0, (Integer)EngineExceptionEnum.PARAM_FAIL.getExceptionCode(), (String)EngineExceptionEnum.PARAM_FAIL.getMessage());
        Map params = (Map)arg[0];
        SQLModel sqlModel = this.sqlModelService.getModelByTfId((String)params.get("tfModelId"));
        CustomSqlDto customSqlDto = new CustomSqlDto();
        customSqlDto.setParams(params);
        SQLModelExtendInfo sqlModelExtendInfo = (SQLModelExtendInfo)JSON.parseObject((String)sqlModel.getJsonParam(), SQLModelExtendInfo.class);
        customSqlDto.setPollName(sqlModelExtendInfo.getPollName());
        List fieldList = sqlModelExtendInfo.getFieldList();
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        TableEntity tableEntity = new TableEntity();
        tableEntity.setDbType(this.getDbType());
        ArrayList<MetadataColumn> columnList = new ArrayList<MetadataColumn>();
        for (ModelFieldDto modelFieldDto : fieldList) {
            ColumnEntity columnEntity = new ColumnEntity();
            columnEntity.setColJdbcType(modelFieldDto.getJdbcType());
            columnEntity.setColJavaType(modelFieldDto.getJavaType());
            columnEntity.setColName(modelFieldDto.getFieldAlias());
            columnEntity.setColAlias(modelFieldDto.getFieldAlias());
            columnEntity.setTableEntity(tableEntity);
            columnEntityMap.put(columnEntity.getColAlias(), columnEntity);
            MetadataColumn column = new MetadataColumn();
            column.setColumnAlias(modelFieldDto.getFieldAlias());
            column.setColumnName(modelFieldDto.getFieldName());
            column.setJavaType(modelFieldDto.getJavaType());
            column.setJdbcType(modelFieldDto.getJdbcType());
            columnList.add(column);
        }
        customSqlDto.setColumnList(columnList);
        customSqlDto.setSql(sqlModel.getSQLStatement() + this.getWhereSql(params, columnEntityMap) + this.getOrderSql(params));
        customSqlDto.setPage(this.getPage(params));
        return customSqlDto;
    }

    public String getWhereSql(Map<String, Object> params, Map<String, ColumnEntity> columnEntityMap) {
        String pre = "WH";
        Object superQueryObj = params.get("superQueryConditionDto");
        if (HussarUtils.isEmpty((Object)superQueryObj)) {
            return "";
        }
        List conditions = JsonUtil.readList((String)JSON.toJSONString((Object)superQueryObj), EngineQueryConditionDto.class);
        AtomicInteger paramNameSeq = new AtomicInteger(0);
        List<WhereEntity> conditionWhere = DmlEntityUtil.getConditionChildWhere(conditions, null, columnEntityMap, params, paramNameSeq, pre);
        conditionWhere.forEach(x -> x.initVal(params));
        List<WhereEntity> newConditionWhere = DmlWhereEntityUtil.whereIntuitionRebuild(conditionWhere);
        String whereSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(newConditionWhere), false);
        return " WHERE " + whereSqlStr.replace("et.param.", "");
    }

    public String getOrderSql(Map<String, Object> params) {
        Object orders = params.get("orders");
        List orderItems = (List)JSON.parseObject((String)JSON.toJSONString((Object)orders), (TypeReference)new TypeReference<List<OrderItem>>(){}, (Feature[])new Feature[0]);
        StringBuilder stringBuilder = new StringBuilder();
        if (HussarUtils.isEmpty((Object)orderItems)) {
            return "";
        }
        for (OrderItem orderItem : orderItems) {
            stringBuilder.append(String.format("%s %s,", orderItem.getColumn(), orderItem.isAsc() ? "ASC" : "DESC"));
        }
        return " ORDER BY " + stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public Page getPage(Map<String, Object> params) {
        if (HussarUtils.isNotEmpty((Object)params.get("current")) && HussarUtils.isNotEmpty((Object)params.get("size"))) {
            Page page = Page.of((long)Long.valueOf(String.valueOf(params.get("current"))), (long)Long.valueOf(String.valueOf(params.get("size"))));
            if (HussarUtils.isNotEmpty((Object)params.get("optimizeCountSql"))) {
                page.setOptimizeCountSql(HussarUtils.toBoolean((Object)params.get("optimizeCountSql")).booleanValue());
            }
            return page;
        }
        return null;
    }
}

