/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomResultMap;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.model.SQLModel;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.TableEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.SQLModelExtendInfo;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="SQL\u6a21\u578b \u67e5\u8be2\u5b9e\u4f53")
public class SelectBySQLEntity
extends CustomResultMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectBySQLEntity.class);
    @ApiModelProperty(value="resultMapId")
    private String resultMapId;
    @ApiModelProperty(value="\u6a21\u578b\u4fe1\u606f")
    private ModelTableMappingDTO model;
    @ApiModelProperty(value="\u6a21\u578b\u4fe1\u606f")
    private SQLModel sqlModel;
    @ApiModelProperty(value="\u8fde\u63a5\u540d\u79f0")
    private String connName;
    @ApiModelProperty(value="\u53c2\u6570")
    Map<String, Object> param;
    @ApiModelProperty(value="\u6570\u636e\u5e93\u7c7b\u578b")
    private DbType dbType;
    @ApiModelProperty(value="\u57fa\u7840SQL")
    private String basicSql;
    @ApiModelProperty(value="where\u6761\u4ef6")
    private String whereSql;
    @ApiModelProperty(value="\u6392\u5e8f\u6761\u4ef6")
    private String orderBySql;

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public SQLModel getSqlModel() {
        return this.sqlModel;
    }

    public void setSqlModel(SQLModel sqlModel) {
        this.sqlModel = sqlModel;
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String connName) {
        this.connName = connName;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public String getBasicSql() {
        return this.basicSql;
    }

    public void setBasicSql(String basicSql) {
        this.basicSql = basicSql;
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public void setWhereSql(String whereSql) {
        this.whereSql = whereSql;
    }

    public String getOrderBySql() {
        return this.orderBySql;
    }

    public void setOrderBySql(String orderBySql) {
        this.orderBySql = orderBySql;
    }

    public void init() {
        AtomicInteger paramNameSeq = new AtomicInteger(0);
        ArrayList<ModelColumnDto> allColumns = new ArrayList<ModelColumnDto>();
        this.getAllColumns(this.model, allColumns);
        Map<String, ModelColumnDto> columnAliseMap = allColumns.stream().collect(Collectors.toMap(MetadataColumn::getColumnAlias, Function.identity()));
        SQLModelExtendInfo sqlModelExtendInfo = (SQLModelExtendInfo)JSON.parseObject((String)this.sqlModel.getJsonParam(), SQLModelExtendInfo.class);
        Map tableAliasMap = sqlModelExtendInfo.getTableAliasMap();
        this.buildWhereSql(tableAliasMap, columnAliseMap, paramNameSeq);
        this.buildOrderSql(tableAliasMap, columnAliseMap);
    }

    private void buildWhereSql(Map<String, String> tableAliasMap, Map<String, ModelColumnDto> columnAliseMap, AtomicInteger paramNameSeq) {
        StringBuilder stringBuilder = new StringBuilder();
        String pre = "WH";
        Object superQueryObj = this.param.get("superQueryConditionDto");
        if (superQueryObj == null) {
            return;
        }
        List conditions = JsonUtil.readList((String)JSON.toJSONString((Object)superQueryObj), EngineQueryConditionDto.class);
        for (EngineQueryConditionDto condition : conditions) {
            ModelColumnDto columnDto = columnAliseMap.get(condition.getField());
            WhereEntity whereEntity = new WhereEntity();
            ColumnEntity columnEntity = new ColumnEntity(null, columnDto.getColumnId(), columnDto.getColumnName(), columnDto.getColumnAlias(), columnDto.getJavaType(), columnDto.getJdbcType(), true, null, null, null);
            TableEntity tableEntity = new TableEntity();
            tableEntity.setDbType(this.dbType);
            columnEntity.setTableEntity(tableEntity);
            whereEntity.setColumnEntity(columnEntity);
            whereEntity.setMatchType(MatchTypeEnum.getByValue((String)condition.getMatch()));
            whereEntity.setOperatorType(OperatorType.getByValue((String)condition.getRule()));
            String paramColumnAlias = this.genParam(pre, paramNameSeq);
            whereEntity.setParamColumnAlias(paramColumnAlias);
            whereEntity.setVal(condition.getVal());
            whereEntity.processingParam();
            this.param.put(whereEntity.getParamColumnAlias(), whereEntity.getVal());
            if (HussarUtils.isEmpty((Object)whereEntity.getSetSql())) continue;
            String whereSql = whereEntity.getSetSql().trim();
            stringBuilder.append(String.format(" %s %s.%s", Objects.requireNonNull(MatchTypeEnum.getByValue((String)condition.getMatch())).getValue(), tableAliasMap.get(columnDto.getTfModelId()), whereSql));
        }
        this.whereSql = stringBuilder.toString();
    }

    private void addDelFlagCondition(String pre, Map<String, String> tableAliasMap, StringBuilder stringBuilder, AtomicInteger paramNameSeq) {
        MetadataColumnService metadataColumnService = (MetadataColumnService)SpringContextUtil.getBean(MetadataColumnService.class);
        MetadataColumn delFlagColumn = (MetadataColumn)metadataColumnService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MetadataColumn.class).eq(MetadataColumn::getTableId, (Object)this.model.getTableId())).eq(MetadataColumn::getColumnName, (Object)"DEL_FLAG"), false);
        if (HussarUtils.isNotEmpty((Object)delFlagColumn)) {
            String paramName = this.genParam(pre, paramNameSeq);
            this.param.put(paramName, "1");
            if (this.dbType.equals((Object)DbType.MYSQL)) {
                stringBuilder.append(String.format("AND (%s.`DEL_FLAG` <> #{et.param.%s,javaType=%s,jdbcType=%s} OR %s.`DEL_FLAG` IS NULL)", tableAliasMap.get(this.model.getTfModelId()), paramName, delFlagColumn.getJavaType(), delFlagColumn.getJdbcType(), tableAliasMap.get(this.model.getTfModelId())));
            } else {
                stringBuilder.append(String.format("AND (%s.DEL_FLAG <> #{et.param.%s,javaType=%s,jdbcType=%s} OR %s.DEL_FLAG IS NULL)", tableAliasMap.get(this.model.getTfModelId()), paramName, delFlagColumn.getJavaType(), delFlagColumn.getJdbcType(), tableAliasMap.get(this.model.getTfModelId())));
            }
        }
    }

    private void buildOrderSql(Map<String, String> tableAliasMap, Map<String, ModelColumnDto> columnAliseMap) {
        Object orders = this.param.get("orders");
        if (HussarUtils.isEmpty((Object)orders)) {
            return;
        }
        List orderItems = (List)JSON.parseObject((String)JSON.toJSONString((Object)orders), (TypeReference)new TypeReference<List<OrderItem>>(){}, (Feature[])new Feature[0]);
        StringBuilder stringBuilder = new StringBuilder();
        for (OrderItem orderItem : orderItems) {
            ModelColumnDto columnDto = columnAliseMap.get(orderItem.getColumn());
            HussarException.throwBy((columnDto == null ? 1 : 0) != 0, (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5728\u5c55\u793a\u5b57\u6bb5\u5185");
            stringBuilder.append(String.format("%s.%s %s,", tableAliasMap.get(columnDto.getTfModelId()), columnDto.getColumnName(), orderItem.isAsc() ? "ASC" : "DESC"));
        }
        this.orderBySql = stringBuilder.toString();
        this.orderBySql = this.orderBySql.substring(0, this.orderBySql.length() - 1);
    }

    private void getAllColumns(ModelTableMappingDTO model, List<ModelColumnDto> allColumns) {
        allColumns.addAll(model.getColumns());
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                this.getAllColumns(slaveTable, allColumns);
            }
        }
    }

    private String genParam(String pre, AtomicInteger paramNameSeq) {
        return Optional.ofNullable(pre).orElse("") + "MPGENVAL" + paramNameSeq.incrementAndGet();
    }
}

