/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.mss.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class TreeSearch {
    public static <T> T bfs(T root, Function<T, List<T>> getChildren, Predicate<T> predicate) {
        LinkedList<T> queue = new LinkedList<T>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Object peek = queue.poll();
            if (predicate.test(peek)) {
                return (T)peek;
            }
            List<Object> children = getChildren.apply(peek);
            if (children == null) continue;
            children.forEach(queue::offer);
        }
        return null;
    }

    public static <T> T bfsFindParent(T root, Function<T, List<T>> getChildren, Predicate<T> predicate) {
        if (predicate.test(root)) {
            return null;
        }
        LinkedList<T> queue = new LinkedList<T>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Object peek = queue.poll();
            List<T> children = getChildren.apply(peek);
            if (children == null) continue;
            for (T x : children) {
                if (predicate.test(x)) {
                    return (T)peek;
                }
                queue.offer(x);
            }
        }
        return null;
    }
}

