/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.AddDelAssigneeDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.AssistCommonDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.EndProcessDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormRecallDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSubmitDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSubmitRejectDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FreeJumpDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.RejectTaskDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.TaskEntrustDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.MultiMsBpmService;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl.BpmExecuteServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl.BpmExtendServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.bpm.util.BpmResultUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.MultiMsTableService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteBatchDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.bpm.service.impl.multiMsBpm", type=DataServiceType.EXTENDED, des="\u4e3b\u5b50\u5b59\u8868\u5de5\u4f5c\u6d41\u56fa\u5316service")
public class MultiMsBpmServiceImpl
implements MultiMsBpmService,
UnderlyingService {
    private final BpmExecuteServiceImpl executeService;
    private final MultiMsTableService multiMsTableService;
    private final BpmExtendServiceImpl bpmExtendService;

    public MultiMsBpmServiceImpl(BpmExecuteServiceImpl executeService, MultiMsTableService multiMsTableService, BpmExtendServiceImpl bpmExtendService) {
        this.executeService = executeService;
        this.multiMsTableService = multiMsTableService;
        this.bpmExtendService = bpmExtendService;
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u9a73\u56de\u4efb\u610f\u8282\u70b9", paramAlias={"entity", "updateEntity"}, paramDes={"\u9a73\u56de\u4fe1\u606fdto", "\u66f4\u65b0map"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> anyNodeReject(RejectTaskDto arg, List<DmlEntity> updateEntity) {
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, "any");
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u6d41\u7a0b\u7ec8\u6b62", paramDes={"\u4e3b\u5b50\u5b59\u8868\u6d41\u7a0b\u7ec8\u6b62dto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> endProcess(EndProcessDto arg) {
        return this.executeService.endProcess(arg.getTaskId(), arg.getComment());
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u64a4\u56de\u6d41\u7a0b\u8868\u5355", paramDes={"\u4e3b\u5b50\u5b59\u8868\u64a4\u56de\u6d41\u7a0b\u8868\u5355dto", "\u66f4\u65b0map"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowRecall(FormRecallDto recallDto, List<DmlEntity> updateEntity) {
        ApiResponse<Object> withdrawState = this.executeService.withdrawState(recallDto.getTaskId());
        if (HussarUtils.isNotEmpty((Object)withdrawState.getData()) && Boolean.FALSE.equals(((JSONArray)withdrawState.getData()).get(0))) {
            return ApiResponse.fail((String)"\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de");
        }
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.revokeTask(recallDto.getTaskId(), recallDto.getComment(), recallDto.getIsSubmit(), recallDto.getParamMap());
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", paramDes={"\u4e3b\u5b50\u5b59\u8868\u63d0\u4ea4\u8868\u5355\u6570\u636edto", "\u66f4\u65b0\u5bf9\u8c61map"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowSubmit(FormSubmitDto arg, List<DmlEntity> updateEntity) {
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
        DmlEntity entity = updateEntity.get(0);
        StartProcessDto startProcessDto = this.executeService.getColumnRule(entity);
        this.bpmExtendService.fillSecurityLevel(entity, variable);
        this.bpmExtendService.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
        if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
            StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
            startAndCompleteDto.setAppointAssignee(appointMap);
            startAndCompleteDto.setComment(arg.getComment());
            startAndCompleteDto.setParamMap(arg.getParamMap());
            startAndCompleteDto.setMultiNodeTypeMap(arg.getMultiNodeTypeMap());
            this.executeService.startAndComplete(startAndCompleteDto);
        } else {
            if (arg.getNodeParticipantSelect() != null) {
                variable.put("public_appoint_assignee", arg.getNodeParticipantSelect());
            }
            this.executeService.completeTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId(), arg.getMultiNodeTypeMap());
        }
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\uff08\u4f18\u5148\u63d0\u4ea4\u81f3\u9a73\u56de\u8282\u70b9\uff09", paramDes={"\u4e3b\u5b50\u5b59\u8868\u63d0\u4ea4\uff08\u4f18\u5148\u63d0\u4ea4\u81f3\u9a73\u56de\u8282\u70b9\uff09dto", "\u4e1a\u52a1\u4e3b\u952e"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowSubmitReject(FormSubmitRejectDto arg, List<DmlEntity> updateEntity) {
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        arg.setBusinessKey(businessKey);
        HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        DmlEntity entity = updateEntity.get(0);
        StartProcessDto startProcessDto = this.executeService.getColumnRule(entity);
        this.bpmExtendService.fillSecurityLevel(entity, variable);
        this.bpmExtendService.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
        if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
            StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
            startAndCompleteDto.setAppointAssignee(appointMap);
            startAndCompleteDto.setComment(arg.getComment());
            startAndCompleteDto.setParamMap(arg.getParamMap());
            startAndCompleteDto.setMultiNodeTypeMap(arg.getMultiNodeTypeMap());
            this.executeService.startAndComplete(startAndCompleteDto);
        } else {
            this.executeService.completeLeapTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId(), arg.getMultiNodeTypeMap());
        }
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u81ea\u7531\u9a73\u56de", paramDes={"\u9a73\u56de\u4fe1\u606fdto", "\u66f4\u65b0map"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> freeReject(RejectTaskDto arg, List<DmlEntity> updateEntity) {
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, arg.getType());
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u9a73\u56de\u81f3\u7b2c\u4e00\u8282\u70b9", paramDes={"\u9a73\u56de\u4fe1\u606fdto", "\u66f4\u65b0map"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> initialNodeReject(RejectTaskDto arg, List<DmlEntity> updateEntity) {
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, "initial");
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u9a73\u56de\u4e0a\u4e00\u8282\u70b9", paramDes={"\u9a73\u56de\u4fe1\u606fdto", "\u66f4\u65b0\u5bf9\u8c61map"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> prevNodeReject(RejectTaskDto arg, List<DmlEntity> updateEntity) {
        ApiResponse<Object> result = this.saveForm(updateEntity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, "prev");
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u4efb\u52a1\u8f6c\u529e", paramDes={"\u4efb\u52a1\u8f6c\u529edto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> taskEntrust(TaskEntrustDto arg) {
        return this.executeService.entrustTask(arg.getTaskId(), arg.getConsignorSelect(), arg.getComment(), arg.getParamMap());
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u81ea\u7531\u8df3\u8f6c", paramDes={"\u4e3b\u5b50\u5b59\u8868\u81ea\u7531\u8df3\u8f6cDto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> freeJump(FreeJumpDto arg) {
        return this.executeService.freeJump(arg);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u52a0\u7b7e", paramDes={"\u52a0\u51cf\u7b7eDto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> addOrDelAssignee(AddDelAssigneeDto arg) {
        return this.executeService.addOrDelAssignee(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u6279\u91cf\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", paramDes={"\u4e3b\u5b50\u5b59\u8868\u6279\u91cf\u63d0\u4ea4\u8868\u5355\u6570\u636e"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowSubmitBatch(List<List<DmlEntity>> updateEntityList) {
        R result = new R();
        for (List<DmlEntity> dmlEntities : updateEntityList) {
            LinkedHashMap<String, List<String>> errMsg = new LinkedHashMap<String, List<String>>();
            UpdateEntity entity = (UpdateEntity)dmlEntities.get(0);
            String businessKey = entity.getParam().get(entity.getKeyProperty()).toString();
            try {
                FormSubmitDto dto = new FormSubmitDto().build(entity.getParam().get("flowData"));
                this.bpmExtendService.flowSubmitMssSingle(dto, dmlEntities, errMsg);
            }
            catch (Exception e) {
                errMsg.put("reason", Collections.singletonList(e.getMessage()));
            }
            finally {
                BpmResultUtil.handleBpmResult((R<String>)result, errMsg, businessKey);
            }
        }
        return ApiResponse.success((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u6279\u91cf\u9a73\u56de\u6d41\u7a0b\u8868\u5355", paramDes={"\u4e3b\u5b50\u5b59\u8868\u6279\u91cf\u9a73\u56de\u8868\u5355\u6570\u636e"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowRejectBatch(List<List<DmlEntity>> updateEntityList) {
        R result = new R();
        for (List<DmlEntity> dmlEntities : updateEntityList) {
            LinkedHashMap<String, List<String>> errMsg = new LinkedHashMap<String, List<String>>();
            UpdateEntity entity = (UpdateEntity)dmlEntities.get(0);
            String businessKey = entity.getParam().get(entity.getKeyProperty()).toString();
            try {
                RejectTaskDto dto = new RejectTaskDto().build(entity.getParam().get("flowData"));
                this.bpmExtendService.freeRejectMssSingle(dto, dmlEntities, errMsg);
            }
            catch (Exception e) {
                errMsg.put("reason", Collections.singletonList(e.getMessage()));
            }
            finally {
                BpmResultUtil.handleBpmResult((R<String>)result, errMsg, businessKey);
            }
        }
        return ApiResponse.success((Object)result);
    }

    private ApiResponse<Object> saveForm(List<DmlEntity> updateEntity) {
        HussarException.throwByNull(updateEntity, (Integer)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        Object result = this.multiMsTableService.saveOrUpdate(updateEntity);
        if (result instanceof ApiResponse && !((ApiResponse)result).isSuccess()) {
            return (ApiResponse)result;
        }
        return ApiResponse.success((Object)result);
    }

    @Override
    @EngineMethod(des="\u4e3b\u5b50\u5b59\u8868\u542f\u52a8\u5e76\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408(\u5305\u542b\u6d41\u7a0b\u53c2\u6570)"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowStartAndSubmitBatch(List<List<DmlEntity>> updateEntityList) {
        StartAndCompleteBatchDto startAndCompleteBatchDto = new StartAndCompleteBatchDto();
        for (List<DmlEntity> dmlEntities : updateEntityList) {
            DmlEntity entity = dmlEntities.get(0);
            this.bpmExtendService.renderStartAndCompleteBatchDto(entity, startAndCompleteBatchDto);
            this.saveForm(dmlEntities);
        }
        return this.executeService.startAndCompleteBatch(startAndCompleteBatchDto);
    }

    @Override
    @EngineMethod(des="\u6d41\u7a0b\u65b0\u589e\u534f\u529e", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408(\u5305\u542b\u6d41\u7a0b\u53c2\u6570)"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> createAssistTask(AssistCommonDto arg) {
        return this.executeService.createAssistTask(arg);
    }

    @Override
    @EngineMethod(des="\u5b8c\u6210\u534f\u529e", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408(\u5305\u542b\u6d41\u7a0b\u53c2\u6570)"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> completeAssistTask(AssistCommonDto arg, List<DmlEntity> entity) {
        ApiResponse<Object> result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        return this.executeService.completeAssistTask(arg);
    }
}

