/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSubmitDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSubmitRejectDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.RejectTaskDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl.BpmExecuteServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.MultiMsTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.MsTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteBatchDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class BpmExtendServiceImpl {
    private final BpmExecuteServiceImpl executeService;
    private final SingleTableService singleTableService;
    private final MsTableService msTableService;
    private final MultiMsTableService multiMsTableService;

    public BpmExtendServiceImpl(BpmExecuteServiceImpl executeService, SingleTableService singleTableService, MsTableService msTableService, MultiMsTableService multiMsTableService) {
        this.executeService = executeService;
        this.singleTableService = singleTableService;
        this.msTableService = msTableService;
        this.multiMsTableService = multiMsTableService;
    }

    public ApiResponse<Object> flowSubmitSingle(UpdateEntity entity, FormSubmitDto arg, Map<String, List<String>> errMsg) {
        ApiResponse formResult = this.saveForm(entity);
        if (!formResult.isSuccess()) {
            if (HussarUtils.isEmpty(entity.getParam().get("flowData"))) {
                return formResult;
            }
            errMsg.put("reason", Collections.singletonList("\u8868\u5355\u66f4\u65b0\u5f02\u5e38"));
        } else {
            Object businessKey = formResult.getData();
            HashMap<String, Object> variable = new HashMap<String, Object>();
            ModelColumnDto securityColumn = entity.getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL);
            if (HussarUtils.isNotEmpty((Object)securityColumn)) {
                variable.put("security_level", entity.getParam().get(securityColumn.getColumnName()));
            }
            HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
            StartProcessDto startProcessDto = this.executeService.getColumnRule((DmlEntity)entity);
            startProcessDto.setExternal(arg.getExternal());
            this.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
            if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
                StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
                startAndCompleteDto.setAppointAssignee(appointMap);
                startAndCompleteDto.setComment(arg.getComment());
                startAndCompleteDto.setParamMap(arg.getParamMap());
                this.executeService.startAndComplete(startAndCompleteDto);
            } else {
                if (arg.getNodeParticipantSelect() != null) {
                    variable.put("public_appoint_assignee", arg.getNodeParticipantSelect());
                }
                this.executeService.completeTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId());
            }
        }
        return ApiResponse.success((Object)formResult.getData());
    }

    public ApiResponse<Object> freeRejectSingle(UpdateEntity entity, RejectTaskDto arg, Map<String, List<String>> errMsg) {
        ApiResponse formResult = this.saveForm(entity);
        if (!formResult.isSuccess()) {
            if (HussarUtils.isEmpty(entity.getParam().get("flowData"))) {
                return formResult;
            }
            errMsg.put("reason", Collections.singletonList("\u8868\u5355\u66f4\u65b0\u5f02\u5e38"));
        } else {
            this.executeService.rejectTask(arg, arg.getType());
        }
        return ApiResponse.success((Object)formResult.getData());
    }

    private ApiResponse saveForm(UpdateEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        return this.singleTableService.saveOrUpdate(entity);
    }

    public void renderSubmitVariable(FormSubmitRejectDto arg, String businessKey, Map<String, Object> variable, Map<String, List<String>> appointMap, StartProcessDto startProcessDto) {
        String flowSelect = arg.getFlowSelect();
        List<Object> participants = new ArrayList();
        if (HussarUtils.isNotBlank((CharSequence)arg.getParticipantSelect())) {
            participants = Arrays.stream(arg.getParticipantSelect().split(",")).collect(Collectors.toList());
        }
        if (flowSelect == null) {
            appointMap.put("static_appoint_assignee", participants);
            variable.put("bpm_next_node", "");
        } else {
            appointMap.put(flowSelect, participants);
            variable.put("bpm_next_node", flowSelect);
        }
        if (arg.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            for (Map<String, String> map : arg.getSelectBranches()) {
                if (HussarUtils.isNotBlank((CharSequence)map.get("participants"))) {
                    appointMap.put(map.get("flowSelect"), Arrays.stream(map.get("participants").split(",")).collect(Collectors.toList()));
                } else {
                    appointMap.put(map.get("flowSelect"), CollectionUtil.empty());
                }
                nextNodeIds.add(map.get("flowSelect"));
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        startProcessDto.setProcessKey(arg.getProcessDefinitionKey());
        startProcessDto.setUserId(arg.getUserId());
        startProcessDto.setBusinessId(businessKey);
        startProcessDto.setVariables(variable);
    }

    public ApiResponse<Object> flowSubmitMsSingle(FormSubmitDto arg, Map<String, Object> updateEntity, Map<String, List<String>> errMsg) {
        ApiResponse formResult = this.saveMsForm(updateEntity);
        UpdateEntity masterUpdateEntity = (UpdateEntity)updateEntity.get("master");
        Object businessKey = masterUpdateEntity.getParam().get(masterUpdateEntity.getKeyProperty());
        if (!formResult.isSuccess()) {
            if (HussarUtils.isEmpty(masterUpdateEntity.getParam().get("flowData"))) {
                return formResult;
            }
            errMsg.put("reason", Collections.singletonList("\u8868\u5355\u66f4\u65b0\u5f02\u5e38"));
        } else {
            HashMap<String, Object> variable = new HashMap<String, Object>();
            ModelColumnDto securityColumn = masterUpdateEntity.getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL);
            if (HussarUtils.isNotEmpty((Object)securityColumn)) {
                variable.put("security_level", masterUpdateEntity.getParam().get(securityColumn.getColumnName()));
            }
            HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
            StartProcessDto startProcessDto = this.executeService.getColumnRule((DmlEntity)updateEntity.get("master"));
            this.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
            if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
                StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
                startAndCompleteDto.setAppointAssignee(appointMap);
                startAndCompleteDto.setComment(arg.getComment());
                startAndCompleteDto.setParamMap(arg.getParamMap());
                this.executeService.startAndComplete(startAndCompleteDto);
            } else {
                if (arg.getNodeParticipantSelect() != null) {
                    variable.put("public_appoint_assignee", arg.getNodeParticipantSelect());
                }
                this.executeService.completeTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId());
            }
        }
        return ApiResponse.success(businessKey);
    }

    private ApiResponse saveMsForm(Map<String, Object> updateEntity) {
        HussarException.throwByNull(updateEntity, (Integer)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        return this.msTableService.saveOrUpdate(updateEntity);
    }

    public ApiResponse<Object> freeRejectMsSingle(RejectTaskDto arg, Map<String, Object> updateEntity, Map<String, List<String>> errMsg) {
        ApiResponse formResult = this.saveMsForm(updateEntity);
        if (!formResult.isSuccess()) {
            if (HussarUtils.isEmpty(((UpdateEntity)updateEntity.get("master")).getParam().get("flowData"))) {
                return formResult;
            }
            errMsg.put("reason", Collections.singletonList("\u8868\u5355\u66f4\u65b0\u5f02\u5e38"));
        } else {
            this.executeService.rejectTask(arg, arg.getType());
        }
        return ApiResponse.success((Object)formResult.getData());
    }

    public ApiResponse<Object> flowSubmitMssSingle(FormSubmitDto arg, List<DmlEntity> updateEntityList, Map<String, List<String>> errMsg) {
        ApiResponse<Object> formResult = this.saveMssForm(updateEntityList);
        UpdateEntity masterUpdateEntity = (UpdateEntity)updateEntityList.get(0);
        Object businessKey = masterUpdateEntity.getParam().get(masterUpdateEntity.getKeyProperty());
        if (!formResult.isSuccess()) {
            if (HussarUtils.isEmpty(masterUpdateEntity.getParam().get("flowData"))) {
                return formResult;
            }
            errMsg.put("reason", Collections.singletonList("\u8868\u5355\u66f4\u65b0\u5f02\u5e38"));
        } else {
            HashMap<String, Object> variable = new HashMap<String, Object>();
            HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
            StartProcessDto startProcessDto = this.executeService.getColumnRule((DmlEntity)masterUpdateEntity);
            ModelColumnDto securityColumn = masterUpdateEntity.getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL);
            if (HussarUtils.isNotEmpty((Object)securityColumn)) {
                variable.put("security_level", masterUpdateEntity.getParam().get(securityColumn.getColumnName()));
            }
            this.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
            if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
                StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
                startAndCompleteDto.setAppointAssignee(appointMap);
                startAndCompleteDto.setComment(arg.getComment());
                startAndCompleteDto.setParamMap(arg.getParamMap());
                this.executeService.startAndComplete(startAndCompleteDto);
            } else {
                if (arg.getNodeParticipantSelect() != null) {
                    variable.put("public_appoint_assignee", arg.getNodeParticipantSelect());
                }
                this.executeService.completeTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId());
            }
        }
        return ApiResponse.success(businessKey);
    }

    public ApiResponse<Object> freeRejectMssSingle(RejectTaskDto arg, List<DmlEntity> updateEntityList, Map<String, List<String>> errMsg) {
        ApiResponse<Object> formResult = this.saveMssForm(updateEntityList);
        if (!formResult.isSuccess()) {
            if (HussarUtils.isEmpty(((UpdateEntity)updateEntityList.get(0)).getParam().get("flowData"))) {
                return formResult;
            }
            errMsg.put("reason", Collections.singletonList("\u8868\u5355\u66f4\u65b0\u5f02\u5e38"));
        } else {
            this.executeService.rejectTask(arg, arg.getType());
        }
        return ApiResponse.success((Object)formResult.getData());
    }

    private ApiResponse<Object> saveMssForm(List<DmlEntity> updateEntity) {
        HussarException.throwByNull(updateEntity, (Integer)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        this.multiMsTableService.saveOrUpdate(updateEntity);
        UpdateEntity masterEntity = (UpdateEntity)updateEntity.get(0);
        String pkColumnAlias = masterEntity.getModel().getPrimaryColumn().getColumnAlias();
        Object businessKey = masterEntity.getParam().get(pkColumnAlias);
        return ApiResponse.success(businessKey);
    }

    public void renderStartAndCompleteBatchDto(DmlEntity entity, StartAndCompleteBatchDto startAndCompleteBatchDto) {
        Map param;
        ModelTableMappingDTO model;
        if (entity instanceof UpdateEntity) {
            model = ((UpdateEntity)entity).getModel();
            param = ((UpdateEntity)entity).getParam();
        } else if (entity instanceof InsertEntity) {
            model = ((InsertEntity)entity).getModel();
            param = ((InsertEntity)entity).getParam();
        } else {
            return;
        }
        FormSubmitDto dto = new FormSubmitDto().build(param.get("flowData"));
        String businessId = param.get(model.getPrimaryColumn().getColumnName()).toString();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
        StartProcessDto startProcessDto = this.executeService.getColumnRule(entity);
        this.renderSubmitVariable(dto, businessId, variable, appointMap, startProcessDto);
        startAndCompleteBatchDto.getBusinessIdList().add(businessId);
        startAndCompleteBatchDto.setProcessKey(startProcessDto.getProcessKey());
        startAndCompleteBatchDto.setUserId(startProcessDto.getUserId());
        startAndCompleteBatchDto.setComment(dto.getComment());
        startAndCompleteBatchDto.setExternal(dto.getExternal());
        startAndCompleteBatchDto.setParamMap(dto.getParamMap());
        startAndCompleteBatchDto.setEndProcess(dto.getEndProcess());
        startAndCompleteBatchDto.getVariablesMap().put(businessId, variable);
        startAndCompleteBatchDto.getProcessTitleMap().put(businessId, startProcessDto.getProcessTitle());
        startAndCompleteBatchDto.getDataDetailMap().put(businessId, startProcessDto.getDataDetail());
    }

    public void fillSecurityLevel(DmlEntity entity, Map<String, Object> variable) {
        ModelColumnDto securityColumn;
        if (entity instanceof InsertEntity) {
            ModelColumnDto securityColumn2 = ((InsertEntity)entity).getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL);
            if (HussarUtils.isNotEmpty((Object)securityColumn2) && HussarUtils.isNotEmpty(((InsertEntity)entity).getParam().get(securityColumn2.getColumnName()))) {
                variable.put("security_level", ((InsertEntity)entity).getParam().get(securityColumn2.getColumnName()));
            }
        } else if (entity instanceof UpdateEntity && HussarUtils.isNotEmpty((Object)(securityColumn = ((UpdateEntity)entity).getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL))) && HussarUtils.isNotEmpty(((UpdateEntity)entity).getParam().get(securityColumn.getColumnName()))) {
            variable.put("security_level", ((UpdateEntity)entity).getParam().get(securityColumn.getColumnName()));
        }
    }
}

