/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.apinaming.controller;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class EngineApiController {
    private final EngineBussnessdataInvokeService invokeService;
    private final NodeBusinessService nodeBusinessService;
    private final String MULTIPART_REQUEST = "multipartRequest";
    @Value(value="${global.encryptSignOpen:false}")
    private boolean encryptSignOpen;

    public EngineApiController(EngineBussnessdataInvokeService invokeService, NodeBusinessService nodeBusinessService) {
        this.invokeService = invokeService;
        this.nodeBusinessService = nodeBusinessService;
    }

    @PostMapping(value={"/engine/testInvoke"})
    public ApiResponse<Object> invokeTestSql(@RequestBody TestInvokeDto invokeDto) {
        HussarException.throwByNull((Object)invokeDto.getNodeBusiness(), (String)"\u4e1a\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        return ApiResponse.success((Object)this.nodeBusinessService.invoke(invokeDto.getNodeBusiness(), (Map)Optional.ofNullable(invokeDto.getParams()).orElse(new HashMap()), null));
    }

    @RequestMapping(value={"/{api0:^(?:(?!static|webjars).)*$}/**/{api1:^[^.]+$}"})
    public ResponseEntity<ApiResponse<Object>> invoke(RequestEntity<String> request, HttpServletRequest servletRequest) {
        MultipartHttpServletRequest multipartRequest;
        HttpMethod method = request.getMethod();
        String url = request.getUrl().getPath();
        url = this.posixPath(url);
        String businessId = method.name() + " " + url;
        Map methodParams = Optional.ofNullable(this.getDataFromRequest(request)).orElse(new HashMap());
        if (this.isMultipart(servletRequest) && HussarUtils.isNotEmpty((Object)(multipartRequest = (MultipartHttpServletRequest)servletRequest))) {
            methodParams.put("multipartRequest", multipartRequest);
        }
        return new ResponseEntity((Object)this.invokeService.invoke(businessId, methodParams), HttpStatus.OK);
    }

    private String posixPath(String url) {
        boolean leadingSlash = url.startsWith("/") || url.startsWith("\\");
        boolean trailingSlash = url.endsWith("/") || url.endsWith("\\");
        String path = Arrays.stream(url.split("[/\\\\]", -1)).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("/"));
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    private Map<String, Object> getDataFromRequest(RequestEntity<String> request) {
        Object paramMap;
        String contentType = Optional.ofNullable(request.getHeaders().get((Object)"Content-Type")).map(e -> (String)e.get(0)).orElse(null);
        if (HussarUtils.isNotEmpty((Object)contentType)) {
            if (contentType.contains("application/x-www-form-urlencoded")) {
                paramMap = new HashMap();
                this.getUrlQuery((Map<String, Object>)paramMap, (String)request.getBody());
            } else {
                try {
                    paramMap = JSONObject.parseObject((String)((String)request.getBody()));
                }
                catch (JSONException e2) {
                    try {
                        Object obj = JSONObject.parse((String)((String)request.getBody()));
                        paramMap = new HashMap();
                        paramMap.put("value", obj);
                        paramMap.put("type", obj == null ? Object.class : obj.getClass());
                    }
                    catch (JSONException e22) {
                        throw new HussarException(e22.getMessage(), (Throwable)e22);
                    }
                }
            }
        } else {
            paramMap = new HashMap();
            this.getUrlQuery((Map<String, Object>)paramMap, request.getUrl().getRawQuery());
        }
        return paramMap;
    }

    private void getUrlQuery(Map<String, Object> paramMap, String rawQuery) {
        List query = URLEncodedUtils.parse((String)rawQuery, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair pair : query) {
            paramMap.put(pair.getName(), pair.getValue());
        }
    }

    private boolean isMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    private static class TestInvokeDto {
        private NodeBusinessVo nodeBusiness;
        private Map<String, Object> params;

        private TestInvokeDto() {
        }

        public NodeBusinessVo getNodeBusiness() {
            return this.nodeBusiness;
        }

        public void setNodeBusiness(NodeBusinessVo nodeBusiness) {
            this.nodeBusiness = nodeBusiness;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }
    }
}

