/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.api.service;

import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeRelationHolder;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.engine.api.dto.EngineLoadApiDto;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import java.util.ArrayList;
import java.util.List;

public interface BasicApiAction {
    default public EngineLoadApiDto init() {
        EngineLoadApiDto engineLoadApiDto = new EngineLoadApiDto();
        engineLoadApiDto.setBusinessId(this.businessId());
        engineLoadApiDto.setDataServiceCode(this.dataServiceCode());
        SingleTableDto singleTableDto = engineLoadApiDto.getSingleTableDto();
        singleTableDto.setPmList(this.getPmList());
        singleTableDto.setWhereList(this.getWhereList());
        singleTableDto.setSortVOList(this.getSortList());
        singleTableDto.setPagination(this.isPage());
        singleTableDto.setResultTypeList(this.resultTypeList());
        return engineLoadApiDto;
    }

    default public String httpType() {
        return "POST";
    }

    public String path();

    default public String businessId() {
        String prefix = this.httpType() + " " + "/";
        ModelTypeRelationHolder relationHolder = ModelTypeRelationHolder.getInstance();
        NodeTypeEnum nodeTypeEnum = relationHolder.getModelTypeByDataServiceCode(this.dataServiceCode()).getNodeType();
        String nodeType = nodeTypeEnum.getValue().replace("flow", "");
        return prefix + nodeType + this.path();
    }

    public String dataServiceCode();

    default public List<NodeBusinessPm> getPmList() {
        return new ArrayList<NodeBusinessPm>();
    }

    default public List<NodeBusinessPm> getWhereList() {
        return new ArrayList<NodeBusinessPm>();
    }

    default public List<NodeBusinessPm> getSortList() {
        return new ArrayList<NodeBusinessPm>();
    }

    default public boolean isPage() {
        return false;
    }

    default public boolean resultTypeList() {
        return false;
    }

    default public NodeBusinessPm buildPm(ParameterType parameterType, PurposeEnum purposeEnum, String parameterAlias, MatchTypeEnum matchType, OperatorType operatorType, OrderByType orderType) {
        NodeBusinessPm pm = new NodeBusinessPm();
        pm.setParameterType(parameterType);
        pm.setPurpose(purposeEnum);
        pm.setParameterAlias(parameterAlias);
        pm.setMatchType(matchType);
        pm.setOperatorType(operatorType);
        pm.setOrderType(orderType);
        return pm;
    }
}

