/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.api.factory;

import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeInfo;
import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeRelationHolder;
import com.jxdinfo.hussar.support.engine.api.dto.EngineLoadApiDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.Dataservice;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.service.BasicApiAction;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiActionFactory {
    public static Map<String, NodeBusinessVo> apiActionMap = new ConcurrentHashMap<String, NodeBusinessVo>();
    public static Map<String, Dataservice> dataserviceMap = new ConcurrentHashMap<String, Dataservice>();
    private static final Logger logger = LoggerFactory.getLogger(ApiActionFactory.class);

    public static void addApiAction(String businessId, NodeBusinessVo nodeBusinessVo) {
        apiActionMap.putIfAbsent(businessId, nodeBusinessVo);
    }

    public static void setDataServiceMap(Map<String, Dataservice> dataServiceMap) {
        dataserviceMap.putAll(dataServiceMap);
    }

    public static NodeBusinessVo getDynamicApiAction(String nodeName) {
        if (apiActionMap.containsKey(nodeName)) {
            return apiActionMap.get(nodeName);
        }
        for (BasicApiAction apiAction : SpringContextUtil.getBeansByClass(BasicApiAction.class)) {
            if (!HussarUtils.equals((Object)nodeName, (Object)ApiActionFactory.getNodeName(apiAction.businessId()))) continue;
            EngineLoadApiDto apiDto = apiAction.init();
            Dataservice dataservice = dataserviceMap.get(apiDto.getDataServiceCode());
            if (HussarUtils.isEmpty((Object)((Object)dataservice))) {
                logger.info("dataServiceCode:{}", (Object)apiDto.getDataServiceCode());
                DataserviceService dataserviceService = (DataserviceService)SpringContextUtil.getBean(DataserviceService.class);
                DataserviceDto dataserviceDto = dataserviceService.getDataserviceDto(apiDto.getDataServiceCode());
                dataservice = (Dataservice)((Object)BeanUtil.copyProperties((Object)((Object)dataserviceDto), Dataservice.class));
                dataserviceMap.put(apiDto.getDataServiceCode(), dataservice);
            }
            NodeBusinessVo nodeBusinessVo = (NodeBusinessVo)((Object)BeanUtil.copy((Object)apiDto, NodeBusinessVo.class));
            nodeBusinessVo.setNodeName(nodeName);
            nodeBusinessVo.setActionName(dataservice.getMethodName());
            nodeBusinessVo.setNodeDec(dataservice.getMethodDes());
            nodeBusinessVo.setHpeVersion(2);
            ModelTypeInfo modelTypeInfo = ModelTypeRelationHolder.getInstance().getModelTypeBySolidClass(dataservice.getClassName());
            nodeBusinessVo.setNodeType(modelTypeInfo.getNodeType().getValue());
            nodeBusinessVo.setDataServiceActionName(modelTypeInfo.getParamProviderClassName());
            nodeBusinessVo.setJsonParams(apiDto.getJsonParams());
            apiActionMap.putIfAbsent(nodeName, nodeBusinessVo);
            return nodeBusinessVo;
        }
        return null;
    }

    public static String getNodeName(String businessId) {
        return businessId.replace(" ", "").replace("/", ".").replace(":", "").replace("-", ".");
    }
}

