/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.api.enums;

import com.jxdinfo.hussar.support.exception.HussarException;

public enum ModelOperationTypeEnum {
    ADD("0", "add"),
    EDIT("1", "edit"),
    DELETE("2", "delete"),
    LOGIC_DELETE("3", "logicDelete"),
    NONE_OPERATE("4", "noneOperate");

    private final String value;
    private final String operation;

    private ModelOperationTypeEnum(String value, String operation) {
        this.value = value;
        this.operation = operation;
    }

    public String getValue() {
        return this.value;
    }

    public String getOperation() {
        return this.operation;
    }

    public static boolean isDelete(String operate) {
        return DELETE.getValue().equals(operate) || LOGIC_DELETE.getValue().equals(operate);
    }

    public static String getOperationByValue(String operate) {
        for (ModelOperationTypeEnum item : ModelOperationTypeEnum.values()) {
            if (!item.getValue().equals(operate)) continue;
            return item.getOperation();
        }
        throw new HussarException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
    }
}

