/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.api.support.solidorg.service.impl;

import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.cache.Cache;
import com.jxdinfo.hussar.platform.core.utils.cache.CacheUtil;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.model.GhDataDto;
import com.jxdinfo.hussar.support.engine.api.model.GhDataInOutDto;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.impl.AbstractGainDataGhService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Map;

public abstract class DbAndBpmGainDataGhService
extends AbstractGainDataGhService {
    private final Cache<String, GhDataDto> cache = CacheUtil.newLFUCache((int)200);
    protected DataserviceService dataserviceService;

    public DbAndBpmGainDataGhService(DataserviceService dataserviceService) {
        this.dataserviceService = dataserviceService;
    }

    @Override
    public GhDataDto getGhDataDto(NodeBusinessVo nodeBusinessVo, Map<String, Object> params) {
        String dataServiceCode = nodeBusinessVo.getDataServiceCode();
        GhDataDto ghDataDto = (GhDataDto)this.cache.get((Object)dataServiceCode);
        if (HussarUtils.isNotEmpty((Object)ghDataDto)) {
            return ghDataDto;
        }
        ghDataDto = new GhDataDto();
        DataserviceDto dataserviceDto = this.dataserviceService.getDataserviceDto(dataServiceCode);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)dataserviceDto)), (Integer)EngineExceptionEnum.GAIN_CODE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.GAIN_CODE_FAIL.getMessage());
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)dataserviceDto.getClassName()), (Integer)EngineExceptionEnum.GAIN_CODE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.GAIN_CODE_FAIL.getMessage());
        ghDataDto.setClassName(dataserviceDto.getClassName());
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)dataserviceDto.getMethodName()), (Integer)EngineExceptionEnum.GAIN_CODE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.GAIN_CODE_FAIL.getMessage());
        ghDataDto.setMethodName(dataserviceDto.getMethodName());
        ArrayList<GhDataInOutDto> ghDataInOutDtos = new ArrayList<GhDataInOutDto>();
        for (int i = 0; i < dataserviceDto.getIns().size(); ++i) {
            GhDataInOutDto dataInOutDto = (GhDataInOutDto)((Object)BeanUtil.copy((Object)((Object)dataserviceDto.getIns().get(i)), GhDataInOutDto.class));
            ghDataInOutDtos.add(dataInOutDto);
        }
        ghDataDto.setIns(ghDataInOutDtos);
        this.cache.put((Object)dataServiceCode, (Object)ghDataDto);
        return ghDataDto;
    }
}

