/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.core.enums.ColumnRuleType;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelTableMappingDTO {
    private Long tableId;
    private String tableName;
    private String tableDesc;
    private Long relatedId;
    private String tfModelId;
    private String joinType;
    private String pollName;
    private String paramName;
    private String parentPath;
    private ModelRelation relation;
    private List<RelationshipOnDto> columnOns;
    private List<ModelColumnDto> columns;
    private List<ModelTableMappingDTO> slaveTables;
    private List<ModelColumnsRules> rules;

    public ModelTableMappingDTO() {
        this.setSlaveTables(new ArrayList<ModelTableMappingDTO>());
        this.setColumns(new ArrayList<ModelColumnDto>());
        this.setColumnOns(new ArrayList<RelationshipOnDto>());
    }

    public ModelColumnDto getModelColumnInfo(long modelColumnId) {
        List columnDtos = this.columns.stream().filter(x -> x.getModelColumnId() == modelColumnId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(columnDtos)) {
            return (ModelColumnDto)((Object)columnDtos.get(0));
        }
        return null;
    }

    public Map<Long, List<ModelColumnsRules>> columnId2Rules(String ruleType) {
        if (HussarUtils.isNotBlank((CharSequence)ruleType) && HussarUtils.isNotEmpty(this.rules)) {
            HashMap<Long, List<ModelColumnsRules>> map = new HashMap<Long, List<ModelColumnsRules>>();
            this.rules.stream().filter(x -> ruleType.equals(x.getRuleType())).forEach(x -> {
                ModelColumnDto modelColumnInfo;
                if (x.getModelColumnId() != null && (modelColumnInfo = this.getModelColumnInfo(x.getModelColumnId())) != null) {
                    map.compute(modelColumnInfo.getColumnId(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<ModelColumnsRules>();
                        }
                        v.add(x);
                        return v;
                    });
                }
            });
            return map;
        }
        return null;
    }

    @JsonIgnore
    public List<ModelColumnsRules> getAllTitleRule() {
        if (HussarUtils.isEmpty(this.rules)) {
            return null;
        }
        ArrayList<ModelColumnsRules> res = new ArrayList<ModelColumnsRules>();
        this.getRuleByRuleType(res, ColumnRuleType.TITLE);
        return res;
    }

    @JsonIgnore
    public List<ModelColumnsRules> getAllSerialRule() {
        if (HussarUtils.isEmpty(this.rules)) {
            return null;
        }
        ArrayList<ModelColumnsRules> res = new ArrayList<ModelColumnsRules>();
        this.getRuleByRuleType(res, ColumnRuleType.SERIAL);
        return res;
    }

    @JsonIgnore
    public List<ModelColumnsRules> getAllDataDetailRule() {
        if (HussarUtils.isEmpty(this.rules)) {
            return null;
        }
        ArrayList<ModelColumnsRules> res = new ArrayList<ModelColumnsRules>();
        this.getRuleByRuleType(res, ColumnRuleType.SUMMARY);
        return res;
    }

    public List<ModelTableMappingDTO> getModelsByTableIds(List<Long> tableIds) {
        if (HussarUtils.isEmpty(tableIds)) {
            return new ArrayList<ModelTableMappingDTO>();
        }
        List<ModelTableMappingDTO> allModels = this.getAllModels();
        return allModels.stream().filter(x -> tableIds.contains(x.getTableId())).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<ModelTableMappingDTO> getAllModels() {
        ArrayList<ModelTableMappingDTO> res = new ArrayList<ModelTableMappingDTO>();
        res.add(this);
        if (HussarUtils.isNotEmpty(this.slaveTables)) {
            this.slaveTables.forEach(x -> res.addAll(x.getAllModels()));
        }
        return res;
    }

    @JsonIgnore
    public ModelColumnDto getPrimaryColumn() {
        if (HussarUtils.isEmpty(this.getColumns())) {
            return null;
        }
        return this.getColumns().stream().filter(x -> PurposeEnum.PRIMARY.getValue().equals(x.getPurpose())).findFirst().orElse(null);
    }

    public ModelColumnDto getColumnByPurpose(PurposeEnum purpose) {
        if (HussarUtils.isEmpty(this.getColumns())) {
            return null;
        }
        return this.getColumns().stream().filter(x -> purpose.getValue().equals(x.getPurpose())).findFirst().orElse(null);
    }

    public ModelColumnDto getColumnByPurposeFromAllColumn(PurposeEnum purpose) {
        List<ModelColumnDto> allColumns = this.getAllColumns();
        if (HussarUtils.isEmpty(allColumns)) {
            return null;
        }
        return allColumns.stream().filter(x -> purpose.getValue().equals(x.getPurpose())).findFirst().orElse(null);
    }

    public ModelColumnDto getColumnByAlias(String alias) {
        if (HussarUtils.isEmpty(this.getColumns()) || HussarUtils.isBlank((CharSequence)alias)) {
            return null;
        }
        return this.getColumns().stream().filter(x -> alias.equals(x.getColumnAlias())).findFirst().orElse(null);
    }

    public void getRuleByRuleType(List<ModelColumnsRules> res, ColumnRuleType ruleType) {
        if (HussarUtils.isNotEmpty(this.rules)) {
            res.addAll(this.rules.stream().filter(x -> ruleType.getValue().equals(x.getRuleType())).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty(this.slaveTables)) {
            this.slaveTables.forEach(x -> x.getRuleByRuleType(res, ruleType));
        }
    }

    public static ModelTableMappingDTO create(MetadataTable metadataTable) {
        return ModelTableMappingDTO.create(metadataTable, null);
    }

    public static ModelTableMappingDTO create(MetadataTable metadataTable, RelationshipJoinDto join) {
        ModelTableMappingDTO modelTableMapping = new ModelTableMappingDTO();
        modelTableMapping.setTableId(metadataTable.getTableId());
        modelTableMapping.setTableName(metadataTable.getTableName());
        modelTableMapping.setTableDesc(metadataTable.getTableDec());
        modelTableMapping.setPollName(metadataTable.getPollName());
        if (join != null) {
            modelTableMapping.setJoinType(join.getJoinType().name());
            modelTableMapping.setColumnOns(join.getOnDtoList());
        }
        return modelTableMapping;
    }

    public void addSlaveTable(ModelTableMappingDTO mapping) {
        this.slaveTables.add(mapping);
    }

    public void addSlaveTables(List<ModelTableMappingDTO> mapping) {
        if (HussarUtils.isNotEmpty(mapping)) {
            this.slaveTables.addAll(mapping);
        }
    }

    @JsonIgnore
    public List<ModelColumnDto> getAllColumns() {
        ArrayList<ModelColumnDto> result = new ArrayList<ModelColumnDto>();
        this.columns.forEach(x -> result.add((ModelColumnDto)((Object)x)));
        if (HussarUtils.isNotEmpty(this.slaveTables)) {
            this.slaveTables.forEach(table -> result.addAll(table.getAllColumns()));
        }
        return result;
    }

    public boolean hasGrandSonTable() {
        if (HussarUtils.isEmpty(this.slaveTables)) {
            return false;
        }
        return this.slaveTables.stream().anyMatch(slave -> HussarUtils.isNotEmpty(slave.getSlaveTables()));
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(String tableDesc) {
        this.tableDesc = tableDesc;
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String getPollName() {
        return this.pollName;
    }

    public void setPollName(String pollName) {
        this.pollName = pollName;
    }

    public ModelRelation getRelation() {
        return this.relation;
    }

    public void setRelation(ModelRelation relation) {
        this.relation = relation;
    }

    public List<RelationshipOnDto> getColumnOns() {
        return this.columnOns;
    }

    public void setColumnOns(List<RelationshipOnDto> columnOns) {
        this.columnOns = columnOns;
    }

    public List<ModelColumnDto> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ModelColumnDto> columns) {
        this.columns = columns;
    }

    public List<ModelTableMappingDTO> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<ModelTableMappingDTO> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public Long getRelatedId() {
        return this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public String getTfModelId() {
        return this.tfModelId;
    }

    public void setTfModelId(String tfModelId) {
        this.tfModelId = tfModelId;
    }

    public List<ModelColumnsRules> getRules() {
        return this.rules;
    }

    public void setRules(List<ModelColumnsRules> rules) {
        this.rules = rules;
    }

    public ModelColumnDto getColumnById(Long modelColumnId) {
        if (HussarUtils.isEmpty(this.columns)) {
            return null;
        }
        return this.columns.stream().filter(c -> c.getModelColumnId().equals(modelColumnId)).findFirst().orElse(null);
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void getToNModel(List<ModelTableMappingDTO> results) {
        if (HussarUtils.isNotEmpty(this.slaveTables)) {
            this.slaveTables.forEach(table -> {
                if (table.getRelation() == ModelRelation.ONE_N || table.getRelation() == ModelRelation.N_N) {
                    results.add((ModelTableMappingDTO)table);
                }
                if (HussarUtils.isNotEmpty(table.getSlaveTables())) {
                    table.getToNModel(results);
                }
            });
        }
    }
}

