/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.choreo.api.constant;

import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeInfo;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class ModelTypeRelationHolder {
    private static volatile ModelTypeRelationHolder instance;
    private static final List<ModelTypeInfo> modelTypeRelations;

    private ModelTypeRelationHolder() {
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.SINGLE, "com.jxdinfo.hussar.support.engine.plugin.dml.service.impl.engineSingleTable", "com.jxdinfo.hussar.support.engine.plugin.dml.support.service.solidorg.SingTableGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.MASTER, "com.jxdinfo.hussar.support.engine.plugin.dml.service.impl.engineMsTable", "com.jxdinfo.hussar.support.engine.plugin.dml.support.service.solidorg.MsTableGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.MULTI_MASTER, "com.jxdinfo.hussar.support.engine.plugin.mss.service.impl.engineMssTable", "com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.solidorg.MultiMsTableGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.SINGLEFLOW, "com.jxdinfo.hussar.support.engine.plugin.bpm.service.impl.singleBpm", "com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.solidorg.SingleBpmGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.MSFLOW, "com.jxdinfo.hussar.support.engine.plugin.bpm.service.impl.multiBpm", "com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.solidorg.MuliBpmGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.MULTI_MSFLOW, "com.jxdinfo.hussar.support.engine.plugin.bpm.service.impl.multiMsBpm", "com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.solidorg.MultiMsBpmGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.API, null, "com.jxdinfo.hussar.support.engine.plugin.rmi.support.solidorg.RmiGainDataGhServiceImpl"));
        modelTypeRelations.add(new ModelTypeInfo(NodeTypeEnum.FILE, "com.jxdinfo.hussar.support.engine.plugin.file.support.service.impl.file", "com.jxdinfo.hussar.support.engine.plugin.file.support.service.solidorg.FileGainDataGhServiceImpl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelTypeRelationHolder getInstance() {
        if (instance != null) return instance;
        Class<ModelTypeRelationHolder> clazz = ModelTypeRelationHolder.class;
        synchronized (ModelTypeRelationHolder.class) {
            if (instance != null) return instance;
            instance = new ModelTypeRelationHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getProviderByType(NodeTypeEnum nodeType) {
        return modelTypeRelations.stream().filter(x -> x.getNodeType().equals((Object)nodeType)).findFirst().map(ModelTypeInfo::getParamProviderClassName).orElse(null);
    }

    public ModelTypeInfo getModelTypeBySolidClass(String solidClass) {
        return modelTypeRelations.stream().filter(x -> x.getSolidClassName().equals(solidClass)).findFirst().orElse(null);
    }

    public ModelTypeInfo getModelTypeByDataServiceCode(String dataServiceCode) {
        String prefix = dataServiceCode.substring(0, dataServiceCode.indexOf("_"));
        return modelTypeRelations.stream().filter(x -> x.getSolidClassName().endsWith(prefix)).findFirst().orElse(null);
    }

    static {
        modelTypeRelations = new ArrayList<ModelTypeInfo>();
    }
}

