/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.dsmanager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysdatasource"})
@Api(value="datasource", tags={"\u6570\u636e\u6e90\u7ba1\u7406"})
public class DataSourceController {
    @Autowired
    private DatasourceService datasourceService;

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636edbId\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f", notes="\u6839\u636edbId\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f")
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u6839\u636edbId\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> detail(@ApiParam(value="\u6570\u636e\u6e90id") @RequestParam(value="dbId") String dbId) {
        SysDataSourceDto sysDataSourceDto = this.datasourceService.getDataSourceById(Long.valueOf(dbId));
        return ApiResponse.success((Object)sysDataSourceDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u5206\u9875\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u6e90\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/getList"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6570\u636e\u6e90\u5206\u9875\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysDataSource>> querylist(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysDataSource> page, @ApiParam(value="\u6570\u636e\u6e90\u5b9e\u4f53") SysDataSource sysDataSource) {
        return ApiResponse.success((Object)this.datasourceService.listDataSource(page, sysDataSource));
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", notes="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f")
    @PostMapping(value={"/edit"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<SysDataSource> edit(@ApiParam(value="\u6570\u636e\u6e90\u5b9e\u4f53") @RequestBody SysDataSourceDto sysDatasource) {
        return ApiResponse.success((Object)this.datasourceService.updateDatasource(sysDatasource));
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", notes="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f")
    @PostMapping(value={"/remove"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<SysDataSource> remove(@ApiParam(value="\u6570\u636e\u6e90id") @RequestBody List<String> ids) {
        this.datasourceService.deleteDataSource(ids);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u68c0\u67e5\u6570\u636e\u6e90", notes="\u68c0\u67e5\u6570\u636e\u6e90")
    @PostMapping(value={"/checkSource"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u68c0\u67e5\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> checkSource(@ApiParam(value="\u6570\u636e\u6e90\u4fdd\u5b58\u4fee\u6539dto") @RequestBody SysDataSourceDto sysDataSource) {
        return this.datasourceService.saveDataSourceWithCheck(sysDataSource, true);
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6e90(\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09", notes="\u65b0\u589e\u6570\u636e\u6e90(\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09")
    @PostMapping(value={"/save"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u6570\u636e\u6e90(\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<SysDataSource> checkDataSource(@ApiParam(value="\u6570\u636e\u6e90\u4fdd\u5b58\u4fee\u6539dto") @RequestBody SysDataSourceDto sysDataSource) {
        return this.datasourceService.saveDataSourceWithCheck(sysDataSource, false);
    }
}

