/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.menus.DatasourceException;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.dao.MetadataTableMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MetadataTableServiceImpl
extends HussarServiceImpl<MetadataTableMapper, MetadataTable>
implements MetadataTableService {
    private static Logger LOGGER = LoggerFactory.getLogger(MetadataTableServiceImpl.class);
    private final MetadataColumnService metadataColumnService;

    public MetadataTableServiceImpl(MetadataColumnService metadataColumnService) {
        this.metadataColumnService = metadataColumnService;
    }

    @Override
    public TableInfoDto getTableInfoByName(String tableName, Long dataSourceId) {
        HussarException.throwByNull((Object)tableName, (Integer)DatasourceException.TABLE_NAME_FAIL.getCode(), (String)DatasourceException.TABLE_NAME_FAIL.getMessage());
        List<MetadataTable> tableList = this.getMetadataTableList(tableName, dataSourceId);
        if (HussarUtils.isEmpty(tableList)) {
            return null;
        }
        TableInfoDto tableInfo = (TableInfoDto)BeanUtil.copy((Object)tableList.get(0), TableInfoDto.class);
        assert (tableInfo != null);
        Long tableId = tableInfo.getTableId();
        tableInfo.setColumnList(this.metadataColumnService.listByTableId(tableId));
        return tableInfo;
    }

    @Override
    public MetadataTable getTableInfoById(Long tableId) {
        if (tableId == null) {
            return null;
        }
        return (MetadataTable)this.getById(tableId);
    }

    private List<MetadataTable> getMetadataTableList(String tableName, Long dataSourceId) {
        List tables;
        LambdaQueryWrapper tableQw = (LambdaQueryWrapper)Wrappers.lambdaQuery(MetadataTable.class).eq(MetadataTable::getTableName, (Object)tableName);
        if (dataSourceId != null) {
            tableQw.eq(MetadataTable::getDatasourceId, (Object)dataSourceId);
        }
        if ((tables = ((MetadataTableMapper)this.baseMapper).selectList((Wrapper)tableQw)).isEmpty()) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230\u5143\u6570\u636e\u4fe1\u606f\uff0c\u8868\u540d\uff1a{}\uff0c\u6570\u636e\u6e90id\uff1a{}", (Object)tableName, (Object)dataSourceId);
        }
        return tables;
    }

    @Override
    public MetadataTable getMetadataTableByName(String tableName, Long dataSourceId) {
        List<MetadataTable> tableList = this.getMetadataTableList(tableName, dataSourceId);
        if (HussarUtils.isEmpty(tableList)) {
            return null;
        }
        return tableList.get(0);
    }

    @Override
    public void deleteByTableIds(List<Long> tableIds, UnaryOperator<List<Long>> tableRef) {
        if (HussarUtils.isEmpty(tableIds) || tableRef == null) {
            return;
        }
        List refTableIds = (List)tableRef.apply(tableIds);
        List<Long> toDeleteTableIds = null;
        if (HussarUtils.isEmpty((Object)refTableIds)) {
            toDeleteTableIds = tableIds;
        } else if (refTableIds.size() != tableIds.size()) {
            tableIds.removeAll(refTableIds);
            toDeleteTableIds = tableIds;
        }
        if (HussarUtils.isNotEmpty(toDeleteTableIds)) {
            this.removeByIds(toDeleteTableIds);
            this.metadataColumnService.deleteByTableIds(toDeleteTableIds);
        }
    }

    @Override
    public TableInfoDto getTableInfoByTableId(Long tableId) {
        HussarException.throwByNull((Object)tableId, (Integer)DatasourceException.TABLE_NAME_FAIL.getCode(), (String)DatasourceException.TABLE_NAME_FAIL.getMessage());
        MetadataTable table = this.getTableInfoById(tableId);
        if (HussarUtils.isEmpty((Object)table)) {
            return null;
        }
        TableInfoDto tableInfo = (TableInfoDto)BeanUtil.copy((Object)table, TableInfoDto.class);
        assert (tableInfo != null);
        tableInfo.setColumnList(this.metadataColumnService.listByTableId(tableId));
        return tableInfo;
    }

    @Override
    public List<TableInfoDto> getTableInfosByNames(List<Pair<String, Long>> pairList) {
        for (Pair<String, Long> pair : pairList) {
            HussarException.throwByNull((Object)pair.getKey(), (Integer)DatasourceException.TABLE_NAME_FAIL.getCode(), (String)DatasourceException.TABLE_NAME_FAIL.getMessage());
        }
        List<MetadataTable> tableList = this.getMetadataTableList(pairList);
        if (HussarUtils.isEmpty(tableList)) {
            return null;
        }
        ArrayList<TableInfoDto> tableInfoDtoList = new ArrayList<TableInfoDto>();
        for (MetadataTable metadataTable : tableList) {
            tableInfoDtoList.add((TableInfoDto)BeanUtil.copy((Object)metadataTable, TableInfoDto.class));
        }
        List<Long> tableIds = tableInfoDtoList.stream().map(MetadataTable::getTableId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(tableIds)) {
            List<MetadataColumn> metadataColumnList = this.metadataColumnService.listByTableIds(tableIds);
            Map<Long, List<MetadataColumn>> map = this.getTableColumnMap(metadataColumnList);
            tableInfoDtoList.forEach(t -> t.setColumnList((List)map.get(t.getTableId())));
        }
        return tableInfoDtoList;
    }

    private List<MetadataTable> getMetadataTableList(List<Pair<String, Long>> pairList) {
        if (HussarUtils.isEmpty(pairList)) {
            return new ArrayList<MetadataTable>();
        }
        LambdaQueryWrapper tableQw = Wrappers.lambdaQuery(MetadataTable.class);
        for (Pair<String, Long> pair : pairList) {
            ((LambdaQueryWrapper)tableQw.or()).eq(MetadataTable::getTableName, pair.getKey());
            if (pair.getValue() == null) continue;
            tableQw.eq(MetadataTable::getDatasourceId, pair.getValue());
        }
        return ((MetadataTableMapper)this.baseMapper).selectList((Wrapper)tableQw);
    }

    private Map<Long, List<MetadataColumn>> getTableColumnMap(List<MetadataColumn> metadataColumnList) {
        HashMap<Long, List<MetadataColumn>> map = new HashMap<Long, List<MetadataColumn>>();
        for (MetadataColumn column : metadataColumnList) {
            ArrayList<MetadataColumn> columnList = (ArrayList<MetadataColumn>)map.get(column.getTableId());
            if (HussarUtils.isEmpty((Object)columnList)) {
                columnList = new ArrayList<MetadataColumn>();
            }
            columnList.add(column);
            map.put(column.getTableId(), columnList);
        }
        return map;
    }

    @Override
    public List<TableInfoDto> getTableInfosByTableIds(List<Long> tableIds) {
        if (HussarUtils.isEmpty(tableIds)) {
            return new ArrayList<TableInfoDto>();
        }
        List tableList = this.listByIds(tableIds);
        if (HussarUtils.isEmpty((Object)tableList)) {
            return new ArrayList<TableInfoDto>();
        }
        ArrayList<TableInfoDto> tableInfoDtoList = new ArrayList<TableInfoDto>();
        for (MetadataTable metadataTable : tableList) {
            tableInfoDtoList.add((TableInfoDto)BeanUtil.copy((Object)metadataTable, TableInfoDto.class));
        }
        List<MetadataColumn> metadataColumnList = this.metadataColumnService.listByTableIds(tableIds);
        Map<Long, List<MetadataColumn>> map = this.getTableColumnMap(metadataColumnList);
        tableInfoDtoList.forEach(t -> t.setColumnList((List)map.get(t.getTableId())));
        return tableInfoDtoList;
    }
}

