/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.menus.DatasourceException;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.dao.MetadataColumnMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.CacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MetadataColumnServiceImpl
extends HussarServiceImpl<MetadataColumnMapper, MetadataColumn>
implements MetadataColumnService {
    @Override
    public List<MetadataColumnDto> listColumnDtoByTableId(Long tableId) {
        HussarException.throwByNull((Object)tableId, (String)DatasourceException.ID_FAIL.getMessage());
        return (List)CacheUtil.get((String)("engine:metadata:column:" + tableId), () -> ((MetadataColumnMapper)this.baseMapper).listColumnDtoByTableId(tableId));
    }

    @Override
    public MetadataColumnDto getColumnDtoById(Long id) {
        HussarException.throwByNull((Object)id, (Integer)DatasourceException.COLUMN_ID_FAIL.getCode(), (String)DatasourceException.COLUMN_ID_FAIL.getMessage());
        return ((MetadataColumnMapper)this.baseMapper).getColumnDtoById(id);
    }

    @Override
    public List<MetadataColumn> listByTableId(Long tableId) {
        return this.list((Wrapper)Wrappers.lambdaQuery(MetadataColumn.class).eq(MetadataColumn::getTableId, (Object)tableId));
    }

    @Override
    public List<MetadataColumn> listByTableIds(List<Long> tableIds) {
        return this.list((Wrapper)Wrappers.lambdaQuery(MetadataColumn.class).in(MetadataColumn::getTableId, tableIds));
    }

    @Override
    public void deleteByTableIds(List<Long> tableIds) {
        if (HussarUtils.isEmpty(tableIds)) {
            return;
        }
        this.remove((Wrapper)Wrappers.lambdaQuery(MetadataColumn.class).in(MetadataColumn::getTableId, tableIds));
    }
}

