/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.engine.core.util.CacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.stereotype.Service;

@Service
public class HussarMetadataServiceImpl
implements HussarMetadataService {
    private final MetadataTableService metadataTableService;
    private final MetadataColumnService metadataColumnService;
    private final SqlSessionFactory sqlSessionFactory;

    public HussarMetadataServiceImpl(MetadataTableService metadataTableService, MetadataColumnService metadataColumnService, SqlSessionFactory sqlSessionFactory) {
        this.metadataTableService = metadataTableService;
        this.metadataColumnService = metadataColumnService;
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @DSTransactional
    public boolean insertTableInfo(MetadataParam paramData) {
        TableInfoDto tableInfo = paramData.getTableInfo();
        MetadataTable copy = (MetadataTable)BeanUtil.copy((Object)tableInfo, MetadataTable.class);
        assert (copy != null);
        this.metadataTableService.save(copy);
        List columns = BeanUtil.copy((Collection)paramData.getColumnInfo(), MetadataColumn.class);
        for (MetadataColumn column : columns) {
            column.setTableId(copy.getTableId());
            column.setTableName(copy.getTableName());
        }
        tableInfo.setTableId(copy.getTableId());
        this.metadataColumnService.saveBatch(columns);
        CacheUtil.evict((String)("engine:metadata:column:" + copy.getTableId()));
        return true;
    }

    @DSTransactional
    public boolean updateTableInfo(MetadataParam paramData) {
        TableInfoDto tableInfo = paramData.getTableInfo();
        Long tableId = tableInfo.getTableId();
        this.metadataTableService.updateById(tableInfo);
        List<MetadataColumn> oldColumns = this.metadataColumnService.listByTableId(tableId);
        Map<String, Long> columnIds = oldColumns.stream().collect(Collectors.toMap(MetadataColumn::getColumnName, MetadataColumn::getColumnId, (k1, k2) -> k1));
        List columns = BeanUtil.copy((Collection)paramData.getColumnInfo(), MetadataColumn.class);
        ArrayList<MetadataColumn> updateColumns = new ArrayList<MetadataColumn>();
        ArrayList<MetadataColumn> saveColumns = new ArrayList<MetadataColumn>();
        for (MetadataColumn column : columns) {
            Long columnId = columnIds.get(column.getColumnName());
            if (HussarUtils.isNotEmpty((Object)columnId)) {
                column.setColumnId(columnId);
                updateColumns.add(column);
                columnIds.remove(column.getColumnName());
            } else {
                saveColumns.add(column);
            }
            column.setTableId(tableId);
            column.setTableName(tableInfo.getTableName());
        }
        if (HussarUtils.isNotEmpty(columnIds.values())) {
            this.metadataColumnService.removeByIds(columnIds.values());
        }
        if (HussarUtils.isNotEmpty(updateColumns)) {
            this.metadataColumnService.updateBatchById(updateColumns);
        }
        if (HussarUtils.isNotEmpty(saveColumns)) {
            this.metadataColumnService.saveBatch(saveColumns);
        }
        this.cleanResultMap(String.format("table.%s.%s", tableId, tableInfo.getTableAlias()));
        CacheUtil.evict((String)("engine:metadata:column:" + tableId));
        return true;
    }

    public void cleanResultMap(String resultMapId) {
        if (resultMapId == null || this.sqlSessionFactory == null) {
            return;
        }
        Configuration configuration = this.sqlSessionFactory.getConfiguration();
        if (configuration.hasResultMap(resultMapId)) {
            configuration.getResultMaps().remove(configuration.getResultMap(resultMapId));
        }
    }

    public void addResultMap(Configuration configuration, ResultMap resultMap) {
        if (resultMap == null || configuration == null && this.sqlSessionFactory == null) {
            return;
        }
        Configuration configuration2 = configuration = configuration == null ? this.sqlSessionFactory.getConfiguration() : configuration;
        if (!configuration.hasResultMap(resultMap.getId())) {
            configuration.addResultMap(resultMap);
        } else {
            Set newColumns;
            ResultMap oldResultMap = configuration.getResultMap(resultMap.getId());
            Set oldColumns = oldResultMap.getMappedColumns();
            if (!oldColumns.containsAll(newColumns = resultMap.getMappedColumns())) {
                configuration.getResultMapNames().remove(resultMap.getId());
                configuration.addResultMap(resultMap);
            }
        }
    }

    public TableInfoDto getTableInfoByTableId(Long tableId) {
        return this.metadataTableService.getTableInfoByTableId(tableId);
    }

    public TableInfoDto getTableInfoByName(String tableName) {
        return this.metadataTableService.getTableInfoByName(tableName, null);
    }

    public MetadataTable getMetadataTableByName(String tableName) {
        return this.metadataTableService.getMetadataTableByName(tableName, null);
    }

    public List<MetadataColumnDto> listColumnDtoByTableId(Long tableId) {
        return this.metadataColumnService.listColumnDtoByTableId(tableId);
    }

    public List<TableInfoDto> getTableInfosByNames(List<String> tableNames) {
        ArrayList<Pair<String, Long>> pairList = new ArrayList<Pair<String, Long>>();
        for (String tableName : tableNames) {
            pairList.add((Pair<String, Long>)Pair.of((Object)tableName, null));
        }
        return this.metadataTableService.getTableInfosByNames(pairList);
    }
}

