/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.handler;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.ParameterExpression;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;

public class EngineParamTokenHandler
extends BaseBuilder
implements TokenHandler {
    private Map<String, String> params;
    private Set<String> bindValue = new HashSet<String>();

    public EngineParamTokenHandler(Configuration configuration, Map<String, String> params) {
        super(configuration);
        this.params = params;
    }

    public String handleToken(String content) {
        ParameterExpression propertiesMap = new ParameterExpression(content);
        content = "#{" + content + "}";
        String property = (String)propertiesMap.get("property");
        if (this.bindValue.contains(property)) {
            return content;
        }
        Class propertyType = JdbcType.CURSOR.name().equals(propertiesMap.get("jdbcType")) ? ResultSet.class : Object.class;
        String alias = (String)propertiesMap.get("javaType");
        if (alias != null) {
            try {
                propertyType = this.resolveAlias(alias);
            }
            catch (Exception e) {
                throw new BuilderException("Error resolving class. Cause: " + e, (Throwable)e);
            }
        }
        this.params.put(property, propertyType.getName());
        return content;
    }

    public void addBindValue(String bindValue) {
        this.bindValue.add(bindValue);
    }
}

