/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.oracle;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.oracle.dao.OracleDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OracleEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(OracleEditTableAction.class);
    @Resource
    private OracleDdlMapper ddlMapper;

    public OracleEditTableAction() {
        ActionFactory.addAction(DbType.ORACLE.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void del(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getDelCols())) {
            for (ColumnInfoDto delCol : updateTableDto.getDelCols()) {
                this.ddlMapper.delTableCol(updateTableDto.getSchemaName(), newTableName, delCol.getColumnName());
            }
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealOracleColumn(column);
    }

    @Override
    public void addPk(UpdateTableDto updateTableDto) {
        if (updateTableDto.isDropPk() && updateTableDto.isNeedSetPk()) {
            List pkColumnNameList = updateTableDto.getPkColumnName();
            ArrayList<String> setPkColumnNameList = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)pkColumnNameList)) {
                for (String columnName : pkColumnNameList) {
                    int checkPkHasNull = this.getMapper().checkPkHasNull(updateTableDto.getSchemaName(), updateTableDto.getTableName(), columnName);
                    int checkPkHasDuplicates = this.getMapper().checkPkHasDuplicates(updateTableDto.getSchemaName(), updateTableDto.getTableName(), columnName);
                    if (checkPkHasNull > 0 || checkPkHasDuplicates > 0) continue;
                    setPkColumnNameList.add(columnName);
                }
            }
            if (HussarUtils.isNotEmpty(setPkColumnNameList)) {
                this.getMapper().setPk(updateTableDto.getSchemaName(), updateTableDto.getTableName(), setPkColumnNameList);
            }
        }
    }
}

