/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.highgo;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.highgo.dao.HgDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HgEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(HgEditTableAction.class);
    @Resource
    private HgDdlMapper ddlMapper;

    public HgEditTableAction() {
        ActionFactory.addAction(DbType.HIGH_GO.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void dropPk(UpdateTableDto updateTableDto) {
        if (updateTableDto.isDropPk() && updateTableDto.isHavePk()) {
            String keyName = this.ddlMapper.getPrimaryKey(updateTableDto.getSchemaName(), updateTableDto.getTableName());
            this.ddlMapper.dropPrimaryKey2(updateTableDto.getSchemaName(), updateTableDto.getTableName(), keyName);
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealOracleColumn(column);
    }
}

