/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.pg;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CreateTableDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableSqlAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.pg.dao.PgDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.RenderUtil;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PgEditTableSqlAction
extends EditTableSqlAction {
    @Resource
    private PgDdlMapper ddlMapper;

    public PgEditTableSqlAction() {
        ActionFactory.addAction(DbType.POSTGRE_SQL.getDb(), this, EditTableSqlAction.class);
    }

    @Override
    public String createTableSql(CreateTableDto createTableDto) throws IOException {
        return RenderUtil.templateRender((String)"ddl/pg_creat_sql.ftl", (Object)createTableDto);
    }

    @Override
    public String editTableSql(UpdateTableDto updateTableDto) throws IOException {
        String primaryKey = this.ddlMapper.getPrimaryKey(updateTableDto.getSchemaName(), updateTableDto.getOldTableName());
        if (HussarUtils.isEmpty((Object)primaryKey)) {
            updateTableDto.setHavePk(false);
        } else {
            updateTableDto.getOtherParams().put("primaryKey", primaryKey);
        }
        return RenderUtil.templateRender((String)"ddl/pg_edit_sql.ftl", (Object)updateTableDto);
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealOracleColumn(column);
    }
}

