/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.gauss;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CreateTableDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableSqlAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.gauss.dao.GaussDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.RenderUtil;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class GaussEditTableSqlAction
extends EditTableSqlAction {
    @Resource
    private GaussDdlMapper ddlMapper;

    public GaussEditTableSqlAction() {
        ActionFactory.addAction(DbType.GAUSS.getDb(), this, EditTableSqlAction.class);
    }

    @Override
    public String createTableSql(CreateTableDto createTableDto) throws IOException {
        return RenderUtil.templateRender((String)"ddl/gauss_creat_sql.ftl", (Object)createTableDto);
    }

    @Override
    public String editTableSql(UpdateTableDto updateTableDto) throws IOException {
        String primaryKey = this.ddlMapper.getPrimaryKey(updateTableDto.getSchemaName(), updateTableDto.getOldTableName());
        if (HussarUtils.isEmpty((Object)primaryKey)) {
            updateTableDto.setHavePk(false);
        } else {
            updateTableDto.getOtherParams().put("primaryKey", primaryKey);
        }
        return RenderUtil.templateRender((String)"ddl/gauss_edit_sql.ftl", (Object)updateTableDto);
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealOracleColumn(column);
    }

    @Override
    public void handleDataTypeBeforeEdit(ColumnInfoDto oldColumn, ColumnInfoDto columnInfoDto, UpdateTableDto updateTableDto) {
        boolean timeStampFlag;
        if (HussarUtils.equals((Object)"VARCHAR", (Object)columnInfoDto.getDataType()) && HussarUtils.isNotEmpty((Object)oldColumn) && HussarUtils.equals((Object)"VARCHAR", (Object)oldColumn.getDataType())) {
            return;
        }
        boolean bl = timeStampFlag = HussarUtils.isNotEmpty((Object)oldColumn) && HussarUtils.equals((Object)"TIMESTAMP", (Object)oldColumn.getDataType());
        if (timeStampFlag && HussarUtils.equals((Object)"TIMESTAMP", (Object)columnInfoDto.getDataType())) {
            return;
        }
        if (timeStampFlag || HussarUtils.equals((Object)"TIMESTAMP", (Object)columnInfoDto.getDataType())) {
            ColumnInfoDto varcharColumnInfoDto = (ColumnInfoDto)HussarUtils.copy((Object)columnInfoDto, ColumnInfoDto.class);
            varcharColumnInfoDto.setDataType("VARCHAR");
            varcharColumnInfoDto.setColumnComment(null);
            columnInfoDto.setOldColumnName(columnInfoDto.getColumnName());
            updateTableDto.getEditCols().add(varcharColumnInfoDto);
        }
    }
}

