<#import './ddl_common_sql' as c>
<#if oldTableName?? && oldTableName != tableName>
    ALTER TABLE `${oldTableName}` RENAME TO `${tableName}`;
</#if>
<#if tableComment??>ALTER TABLE `${tableName}` COMMENT '${tableComment}';</#if>
<#if addCols?? && addCols?size gt 0>
    ALTER TABLE `${tableName}` <#list addCols! as column>ADD COLUMN `${column.columnName!}` ${column.dataType!} <#if column.required?? && column.required == '1'>NOT NULL</#if> <#if column.defaultValue??>DEFAULT '${column.defaultValue!}'</#if> <#if column.columnComment??>COMMENT '${column.columnComment!}'</#if><#sep>,</#list>;
</#if>
<#if dropPk && havePk>
    ALTER TABLE `${tableName}` DROP PRIMARY KEY;
</#if>
<#if editCols?? && editCols?size gt 0>
    ALTER TABLE `${tableName}` <#list editCols! as column>CHANGE COLUMN `${column.oldColumnName}` `${column.columnName}` ${column.dataType} <#if column.required?? && column.required == '1'>NOT NULL</#if> <#if column.defaultValue??>DEFAULT '${column.defaultValue!}'</#if> <#if column.columnComment??>COMMENT '${column.columnComment!}'</#if><#sep>,</#list>;
</#if>
<#if dropPk && needSetPk>
    ALTER TABLE `${tableName}` ADD PRIMARY KEY (<#list pkColumnName! as colName>`${colName}`<#sep>,</#list>);
</#if>
<#if delCols?? && delCols?size gt 0>
    ALTER TABLE `${tableName}` <#list delCols! as column>DROP COLUMN `${column.columnName}`<#sep>,</#list>;
</#if>