/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.gauss;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.gauss.dao.GaussDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GaussEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(GaussEditTableAction.class);
    @Resource
    private GaussDdlMapper ddlMapper;

    public GaussEditTableAction() {
        ActionFactory.addAction(DbType.GAUSS.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void dropPk(UpdateTableDto updateTableDto) {
        if (updateTableDto.isDropPk() && updateTableDto.isHavePk()) {
            String keyName = this.ddlMapper.getPrimaryKey(updateTableDto.getSchemaName(), updateTableDto.getTableName());
            this.ddlMapper.dropPrimaryKey2(updateTableDto.getSchemaName(), updateTableDto.getTableName(), keyName);
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealOracleColumn(column);
    }

    @Override
    public void handleDataTypeBeforeEdit(ColumnInfoDto oldColumn, ColumnInfoDto columnInfoDto, UpdateTableDto updateTableDto) {
        boolean timeStampFlag;
        if (HussarUtils.equals((Object)"VARCHAR", (Object)columnInfoDto.getDataType()) && HussarUtils.isNotEmpty((Object)oldColumn) && HussarUtils.equals((Object)"VARCHAR", (Object)oldColumn.getDataType())) {
            return;
        }
        boolean bl = timeStampFlag = HussarUtils.isNotEmpty((Object)oldColumn) && HussarUtils.equals((Object)"TIMESTAMP", (Object)oldColumn.getDataType());
        if (timeStampFlag && HussarUtils.equals((Object)"TIMESTAMP", (Object)columnInfoDto.getDataType())) {
            return;
        }
        if (timeStampFlag || HussarUtils.equals((Object)"TIMESTAMP", (Object)columnInfoDto.getDataType())) {
            ColumnInfoDto varcharColumnInfoDto = (ColumnInfoDto)HussarUtils.copy((Object)columnInfoDto, ColumnInfoDto.class);
            varcharColumnInfoDto.setDataType("VARCHAR");
            varcharColumnInfoDto.setColumnComment(null);
            columnInfoDto.setOldColumnName(columnInfoDto.getColumnName());
            updateTableDto.getEditCols().add(varcharColumnInfoDto);
        }
    }
}

