if exists (select * from sys.objects where name='${tableName!}' and schema_id = schema_id() and type = 'U')
drop table "${tableName!}"
go
CREATE TABLE "${tableName!}" (
<#list columnInfos! as column>
    "${column.columnName!}" ${column.dataType!}
    <#if column.defaultValue??>DEFAULT '${column.defaultValue!}'</#if>
    <#if column.required?? && column.required == '1'>NOT NULL</#if>
    <#sep>,</#list>
<#if needSetPk>
    ,PRIMARY KEY
    (<#list setPkColumnNames! as pkName>
    "${pkName}"
    <#sep>,</#list>)
</#if>)
go
DECLARE @NAME SYSNAME
SET @NAME=schema_name()
exec sp_addextendedproperty 'MS_Description', '${tableComment!}', 'SCHEMA', @NAME, 'TABLE', '${tableName}'
<#list columnInfos! as column>
exec sp_addextendedproperty 'MS_Description', '${column.columnComment!}', 'SCHEMA', @NAME, 'TABLE', '${tableName}', 'COLUMN', '${column.columnName}'
</#list>
go
