/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.action;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.BasicAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class EditTableAction
extends BasicAction {
    public abstract DdlMapper getMapper();

    public void doEditTable(MetadataParam paramData, List<ColumnInfoDto> oldColumnInfo, String oldTableName) {
        paramData.setSetPkColumnNames(new ArrayList());
        this.init(paramData);
        UpdateTableDto updateTableDto = this.getUpdateTableDto(paramData, oldTableName, oldColumnInfo);
        updateTableDto.setSchemaName(paramData.getSchemaName());
        this.editTable(updateTableDto);
    }

    public void editTable(UpdateTableDto updateTableDto) {
        String oldTableName = updateTableDto.getOldTableName();
        String newTableName = updateTableDto.getTableName();
        this.rename(updateTableDto, oldTableName, newTableName);
        this.add(updateTableDto, newTableName);
        if (updateTableDto.isDropPk()) {
            this.dropPk(updateTableDto);
        }
        this.edit(updateTableDto, newTableName);
        if (updateTableDto.isDropPk()) {
            this.addPk(updateTableDto);
        }
        this.del(updateTableDto, newTableName);
    }

    public void del(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getDelCols())) {
            this.getMapper().delTableCols(updateTableDto.getSchemaName(), newTableName, updateTableDto.getDelCols().stream().map(MetadataColumn::getColumnName).collect(Collectors.toList()));
        }
    }

    public void edit(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getEditCols())) {
            for (ColumnInfoDto editColumn : updateTableDto.getEditCols()) {
                if (HussarUtils.isNotEmpty((Object)editColumn.getOldColumnName()) && !editColumn.getColumnName().equalsIgnoreCase(editColumn.getOldColumnName())) {
                    this.getMapper().renameColumnName(updateTableDto.getSchemaName(), newTableName, editColumn.getOldColumnName(), editColumn.getColumnName());
                }
                this.getMapper().editTableCols(updateTableDto.getSchemaName(), newTableName, Collections.singletonList(editColumn));
                if (!HussarUtils.isNotEmpty((Object)editColumn.getColumnComment())) continue;
                this.getMapper().updateColumnComment(updateTableDto.getSchemaName(), newTableName, editColumn.getColumnName(), editColumn.getColumnComment());
            }
        }
    }

    public void dropPk(UpdateTableDto updateTableDto) {
        if (updateTableDto.isDropPk() && updateTableDto.isHavePk()) {
            this.getMapper().dropPrimaryKey(updateTableDto.getSchemaName(), updateTableDto.getTableName());
        }
    }

    public void addPk(UpdateTableDto updateTableDto) {
        if (updateTableDto.isDropPk() && updateTableDto.isNeedSetPk()) {
            this.getMapper().setPk(updateTableDto.getSchemaName(), updateTableDto.getTableName(), updateTableDto.getPkColumnName());
        }
    }

    public void add(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getAddCols())) {
            this.getMapper().addTableCols(updateTableDto.getSchemaName(), newTableName, updateTableDto.getAddCols());
            for (ColumnInfoDto column : updateTableDto.getAddCols()) {
                if (HussarUtils.isEmpty((Object)column.getColumnComment())) continue;
                this.getMapper().updateColumnComment(updateTableDto.getSchemaName(), newTableName, column.getColumnName(), column.getColumnComment());
            }
        }
    }

    public void rename(UpdateTableDto updateTableDto, String oldTableName, String newTableName) {
        if (!oldTableName.equalsIgnoreCase(newTableName)) {
            this.getMapper().changeTableName(updateTableDto.getSchemaName(), oldTableName, newTableName);
        }
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getTableComment())) {
            this.getMapper().updateTableComment(updateTableDto.getSchemaName(), newTableName, updateTableDto.getTableComment());
        }
    }
}

