/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.entity.SysDatasourceConfig;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.manager.plugin.datasource.dao.DatasourceMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.datasource.service.DatasourceConfigService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.datasource.DataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HussarDs(value="master")
public class DatasourceServiceImpl
extends HussarServiceImpl<DatasourceMapper, SysDataSource>
implements DatasourceService {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceServiceImpl.class);
    private static String CACHE_KEY_PREFIX = "BASE:DATASOURCE:";
    private static String CACHE_NAME = "base:datasource:all";
    private static Long EXPIRE_TIME = 36000L;
    @Resource
    private DatasourceMapper datasourceMapper;
    private final DynamicDatasourceService dynamicDatasourceService;
    private final DatasourceConfigService datasourceConfigService;
    private final DynamicDataSourceProperties dataSourceProperties;
    private final HussarTenantProperties tenantProperties;

    public DatasourceServiceImpl(DynamicDatasourceService dynamicDatasourceService, DatasourceConfigService datasourceConfigService, DynamicDataSourceProperties dataSourceProperties, HussarTenantProperties tenantProperties) {
        this.dynamicDatasourceService = dynamicDatasourceService;
        this.datasourceConfigService = datasourceConfigService;
        this.dataSourceProperties = dataSourceProperties;
        this.tenantProperties = tenantProperties;
    }

    public SysDataSourceDto getDataSourceById(Long dbId) {
        HussarException.throwByNull((Object)dbId, (String)"\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        String key = CACHE_KEY_PREFIX + dbId;
        String str = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)key);
        if (!StringUtils.isEmpty((Object)str)) {
            return (SysDataSourceDto)JSON.parseObject((String)str, SysDataSourceDto.class);
        }
        SysDataSource dataSource = (SysDataSource)this.getById(dbId);
        HussarException.throwByNull((Object)dataSource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        SysDataSourceDto sysDataSourceDto = this.getDataSourceDto(dataSource);
        String string = JSON.toJSONString((Object)sysDataSourceDto);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)string, (long)EXPIRE_TIME);
        return sysDataSourceDto;
    }

    public SysDataSourceDto getDataSourceByConnName(String connName) {
        HussarException.throwByNull((Object)connName, (String)"\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        SysDataSource dataSource = (SysDataSource)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDataSource.class).eq(SysDataSource::getConnName, (Object)connName)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        HussarException.throwByNull((Object)dataSource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        return this.getDataSourceDto(dataSource);
    }

    private SysDataSourceDto getDataSourceDto(SysDataSource dataSource) {
        SysDataSourceDto copy = (SysDataSourceDto)BeanUtil.copy((Object)dataSource, SysDataSourceDto.class);
        assert (copy != null);
        SysDatasourceConfig sysDatasourceConfig = (SysDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)Wrappers.lambdaQuery(SysDatasourceConfig.class).eq(SysDatasourceConfig::getDbId, (Object)copy.getId()));
        if (!HussarUtils.isNull((Object)sysDatasourceConfig)) {
            copy.setProperties(sysDatasourceConfig.getParameterValue());
        }
        return copy;
    }

    @DSTransactional
    public SysDataSourceDto addDatasource(SysDataSourceDto dataSource) {
        this.checkDbName(dataSource.getDbName(), false);
        this.checkConnName(dataSource.getConnName(), dataSource.isThrowWhenConnNameExist());
        this.saveDataSource(dataSource);
        LambdaQueryWrapper sysDataSourceLambdaQueryWrapper = Wrappers.lambdaQuery();
        sysDataSourceLambdaQueryWrapper.eq(SysDataSource::getConnName, (Object)dataSource.getConnName());
        long count = this.count((Wrapper)sysDataSourceLambdaQueryWrapper);
        if (count <= 0L) {
            this.save((BaseEntity)dataSource);
            if (HussarUtils.isNotEmpty((Object)dataSource.getProperties())) {
                Long dbId = dataSource.getId();
                SysDatasourceConfig sysDatasourceConfig = new SysDatasourceConfig();
                sysDatasourceConfig.setConnName(dataSource.getConnName());
                sysDatasourceConfig.setDbId(dbId);
                sysDatasourceConfig.setParameterValue(dataSource.getProperties());
                this.datasourceConfigService.save(sysDatasourceConfig);
            }
        }
        return dataSource;
    }

    @DSTransactional
    public SysDataSourceDto updateDatasource(SysDataSourceDto dataSourceDto) {
        String key_dbId;
        boolean b1;
        String key_connName;
        boolean b;
        String key;
        Boolean containKey;
        SysDataSource dataSource = (SysDataSource)this.getById(dataSourceDto.getId());
        HussarException.throwByNull((Object)dataSource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a");
        if (!HussarUtils.equals((Object)dataSource.getDbName(), (Object)dataSourceDto.getDbName())) {
            this.checkDbName(dataSourceDto.getDbName(), false);
        }
        if (!HussarUtils.equals((Object)dataSource.getConnName(), (Object)dataSourceDto.getConnName())) {
            this.checkConnName(dataSourceDto.getConnName(), true);
        }
        this.checkDruidFiled(dataSourceDto);
        ApiResponse<String> connResult = this.tryConnection(dataSourceDto);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        if (!this.updateById((BaseEntity)dataSourceDto)) {
            throw new DataSourceException("\u4fee\u6539\u6570\u636e\u6e90\u5931\u8d25");
        }
        Long dbId = dataSourceDto.getId();
        this.datasourceConfigService.remove((Wrapper)Wrappers.lambdaQuery(SysDatasourceConfig.class).eq(SysDatasourceConfig::getDbId, (Object)dbId));
        if (HussarUtils.isNotEmpty((Object)dataSourceDto.getProperties())) {
            SysDatasourceConfig sysDatasourceConfig = new SysDatasourceConfig();
            sysDatasourceConfig.setDbId(dbId);
            sysDatasourceConfig.setConnName(dataSource.getConnName());
            sysDatasourceConfig.setParameterValue(dataSourceDto.getProperties());
            this.datasourceConfigService.save(sysDatasourceConfig);
        }
        if ((containKey = Boolean.valueOf(HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key = CACHE_KEY_PREFIX + dbId)))).booleanValue()) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        }
        if (b = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key_connName = CACHE_KEY_PREFIX + dataSourceDto.getConnName()))) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key_connName);
        }
        if (b1 = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)(key_dbId = CACHE_KEY_PREFIX + dataSourceDto.getId()))) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key_dbId);
        }
        return dataSourceDto;
    }

    @DSTransactional
    public List<SysDataSource> deleteDataSource(List<String> ids) {
        if (HussarUtils.isEmpty(ids)) {
            throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
        }
        List idList = ids.stream().map(HussarUtils::toLong).collect(Collectors.toList());
        List list = this.listByIds(idList);
        if (!this.removeByIds(idList)) {
            throw new DataSourceException("\u5220\u9664\u6570\u636e\u6e90\u5931\u8d25");
        }
        this.datasourceConfigService.remove((Wrapper)new LambdaQueryWrapper().in(SysDatasourceConfig::getDbId, idList));
        for (SysDataSource sysDataSource : list) {
            if (!HussarUtils.isNotEmpty((Object)sysDataSource.getConnName())) continue;
            this.dynamicDatasourceService.removeDynamicDatasource(sysDataSource.getConnName());
        }
        return list;
    }

    public List<SysDataSourceDto> listDataSource() {
        List list = this.list((Wrapper)Wrappers.lambdaQuery(SysDataSource.class).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)list)) {
            return new ArrayList<SysDataSourceDto>();
        }
        ArrayList<SysDataSourceDto> result = new ArrayList<SysDataSourceDto>();
        HashMap<Long, SysDataSourceDto> dataSourceDtoMap = new HashMap<Long, SysDataSourceDto>();
        for (SysDataSource dataSource : list) {
            SysDataSourceDto copy = (SysDataSourceDto)BeanUtil.copy((Object)dataSource, SysDataSourceDto.class);
            assert (copy != null);
            result.add(copy);
            dataSourceDtoMap.put(copy.getId(), copy);
        }
        List configs = this.datasourceConfigService.list();
        if (HussarUtils.isNotEmpty((Object)configs)) {
            for (SysDatasourceConfig config : configs) {
                SysDataSourceDto dataSourceDto = (SysDataSourceDto)dataSourceDtoMap.get(config.getDbId());
                if (HussarUtils.isEmpty((Object)dataSourceDto)) continue;
                dataSourceDto.setProperties(config.getParameterValue());
            }
        }
        return result;
    }

    public Boolean checkDbName(String dbName, boolean isThrow) {
        boolean result;
        HussarException.throwByNull((Object)dbName, (String)"\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        boolean bl = result = this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDataSource.class).eq(SysDataSource::getDbName, (Object)dbName)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")) == 0L;
        if (this.tenantProperties.isEnabled()) {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5728\u5f53\u524d\u6216\u5176\u4ed6\u79df\u6237\u4e0b\u5df2\u5b58\u5728\uff01");
        } else {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        return result;
    }

    public Boolean checkConnName(String connName, boolean isThrow) {
        boolean result;
        HussarException.throwByNull((Object)connName, (String)"\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        boolean bl = result = this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDataSource.class).eq(SysDataSource::getConnName, (Object)connName)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")) == 0L;
        if (this.tenantProperties.isEnabled()) {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u8fde\u63a5\u6807\u8bc6\u5728\u5f53\u524d\u6216\u5176\u4ed6\u79df\u6237\u4e0b\u5df2\u5b58\u5728\uff01");
        } else {
            HussarException.throwBy((!result && isThrow ? 1 : 0) != 0, (String)"\u8fde\u63a5\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        return result;
    }

    public IPage<SysDataSource> listDataSource(Page<SysDataSource> page, SysDataSource sysDataSource) {
        if (HussarUtils.isEmpty((Object)sysDataSource) || HussarUtils.isEmpty(page)) {
            throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysDataSource.getDbName()), SysDataSource::getDbName, (Object)sysDataSource.getDbName())).like(!StringUtils.isEmpty((Object)sysDataSource.getDriverClass()), SysDataSource::getDriverClass, (Object)sysDataSource.getDriverClass())).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).eq(HussarUtils.isNotEmpty((Object)sysDataSource.getDatasourceType()), SysDataSource::getDatasourceType, (Object)sysDataSource.getDatasourceType())).orderByDesc(HussarBaseEntity::getCreateTime);
        if (HussarUtils.isEmpty((Object)sysDataSource.getTenantCode())) {
            queryWrapper.eq(SysDataSource::getTenantCode, (Object)"0");
        } else {
            queryWrapper.eq(SysDataSource::getTenantCode, (Object)sysDataSource.getTenantCode());
        }
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    private ApiResponse<String> tryConnection(SysDataSourceDto sysDataSourceDto) {
        if (HussarUtils.isEmpty((Object)sysDataSourceDto) || HussarUtils.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || HussarUtils.isEmpty((Object)sysDataSourceDto.getUserName())) {
            throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
        }
        Connection conn = null;
        try {
            conn = this.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
            if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getCurrentSchema())) {
                DbType databaseType = JdbcUtils.getDbType((String)sysDataSourceDto.getJdbcUrl());
                if (DbType.KINGBASE_ES.equals((Object)databaseType) && "kingbase_pg".equals(sysDataSourceDto.getDbMode())) {
                    databaseType = DbType.POSTGRE_SQL;
                }
                this.checkSchema(conn, sysDataSourceDto.getCurrentSchema(), databaseType);
            }
            String driverName = conn.getMetaData().getDriverName();
            ApiResponse apiResponse = ApiResponse.success((String)driverName.toUpperCase());
            return apiResponse;
        }
        catch (HussarException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void checkSchema(Connection conn, String currentSchema, DbType databaseType) throws SQLException {
        String sql = null;
        switch (databaseType) {
            case SQL_SERVER: 
            case SQL_SERVER2005: {
                sql = "SELECT COUNT(1) FROM SYS.SCHEMAS WHERE NAME = ?";
                break;
            }
            case DM: {
                sql = "SELECT COUNT(1) FROM DBA_OBJECTS WHERE OBJECT_TYPE='SCH' AND OBJECT_NAME = ?";
                break;
            }
            case ORACLE: {
                sql = "SELECT COUNT(1) FROM ALL_USERS WHERE USERNAME = ?";
                break;
            }
            case POSTGRE_SQL: 
            case HIGH_GO: {
                sql = "SELECT COUNT(1) FROM PG_CATALOG.PG_NAMESPACE WHERE NSPNAME = ?";
                break;
            }
            case OSCAR: {
                sql = "SELECT COUNT(1) FROM  INFO_SCHEM.SCHEMATA WHERE SCHEM_NAME = ?";
                break;
            }
            case KINGBASE_ES: {
                sql = "SELECT COUNT(1) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = ?";
                break;
            }
        }
        if (sql == null) {
            return;
        }
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setString(1, currentSchema);
            statement.execute();
            try (ResultSet rs = statement.getResultSet();){
                rs.next();
                if (rs.getLong(1) <= 0L) {
                    throw new HussarException("\u6a21\u5f0f\u540d\u4e0d\u5b58\u5728\uff01");
                }
            }
        }
    }

    @DSTransactional
    public ApiResponse<SysDataSource> saveDataSourceWithCheck(SysDataSourceDto sysDataSource, boolean isCheck) {
        if (!"1".equals(sysDataSource.getIsUpdate())) {
            sysDataSource.setJdbcUrl(sysDataSource.getJdbcUrl().replaceAll("\n", ""));
            this.checkDbName(sysDataSource.getDbName(), false);
            this.checkConnName(sysDataSource.getConnName(), sysDataSource.isThrowWhenConnNameExist());
        }
        ApiResponse<String> connResult = this.tryConnection(sysDataSource);
        if (ResultCode.FAILURE.getCode() == connResult.getCode()) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        if (isCheck) {
            return ApiResponse.success((Object)sysDataSource, (String)String.valueOf(true));
        }
        try {
            String className = DriverManager.getDriver(sysDataSource.getJdbcUrl()).getClass().getName();
            sysDataSource.setDriverClass(className);
        }
        catch (SQLException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
        }
        this.checkDruidFiled(sysDataSource);
        this.setInstantName(sysDataSource);
        this.addDatasource(sysDataSource);
        this.saveCache(sysDataSource);
        return ApiResponse.success((Object)sysDataSource, (String)String.valueOf(true));
    }

    private void saveCache(SysDataSourceDto sysDataSource) {
        Object tokenValue = null;
        String key = CACHE_KEY_PREFIX + sysDataSource.getId();
        Boolean containKey = HussarCacheUtil.containKey((String)CACHE_NAME, (Object)key);
        if (containKey.booleanValue()) {
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        }
        String string = JSON.toJSONString((Object)sysDataSource);
        String key_connName = CACHE_KEY_PREFIX + sysDataSource.getConnName();
        String key_dbId = CACHE_KEY_PREFIX + sysDataSource.getId();
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key_connName, (Object)string, (long)EXPIRE_TIME);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key_dbId, (Object)string, (long)EXPIRE_TIME);
    }

    private void saveDataSource(SysDataSourceDto sysDataSource) {
        try {
            DynamicDataSourceDto dynamicDatasourceDto = this.getDynamicDatasourceDto(sysDataSource);
            String pollName = dynamicDatasourceDto.getPoolName();
            Set allPollName = this.dynamicDatasourceService.getAllDatasourcesName();
            if (HussarUtils.isNotEmpty((Object)allPollName) && allPollName.contains(pollName)) {
                return;
            }
            this.dynamicDatasourceService.addDynamicDatasource(dynamicDatasourceDto);
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    private void setInstantName(SysDataSourceDto sysDataSourceDto) {
        if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getJdbcUrl()) && sysDataSourceDto.getJdbcUrl().startsWith("jdbc:mysql")) {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getDataBaseName());
        } else if (HussarUtils.isNotEmpty((Object)sysDataSourceDto.getJdbcUrl()) && sysDataSourceDto.getJdbcUrl().startsWith("jdbc:oracle")) {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getUserName());
        } else {
            sysDataSourceDto.setInstantName(sysDataSourceDto.getExample());
        }
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    private DynamicDataSourceDto getDynamicDatasourceDto(SysDataSourceDto dataSource) {
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource), (String)"\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getConnName()), (String)"\u6570\u636e\u6e90name\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getUserName()), (String)"\u6570\u636e\u6e90username\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getPassword()), (String)"\u6570\u636e\u6e90password\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getJdbcUrl()), (String)"\u6570\u636e\u6e90url\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getDriverClass()), (String)"\u6570\u636e\u6e90\u9a71\u52a8\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
        dynamicDataSourceDto.setPoolName(dataSource.getConnName());
        dynamicDataSourceDto.setDriverClassName(dataSource.getDriverClass());
        dynamicDataSourceDto.setUrl(dataSource.getJdbcUrl());
        dynamicDataSourceDto.setUserName(dataSource.getUserName());
        dynamicDataSourceDto.setPassword(dataSource.getPassword());
        if (dataSource.getLazyEnable() != null && dataSource.getLazyEnable().equals(0)) {
            dynamicDataSourceDto.setLazyEnable(Boolean.valueOf(false));
        }
        if (HussarUtils.isNotEmpty((Object)dataSource.getCurrentSchema())) {
            dynamicDataSourceDto.setSchemaName(dataSource.getCurrentSchema());
        }
        dynamicDataSourceDto.setDbMode(dataSource.getDbMode());
        DruidConfig druid = DynamicDatasourceUtils.createDataSourceDruid((DynamicDataSourceProperties)this.dataSourceProperties, (String)dataSource.getProperties());
        dynamicDataSourceDto.setDruidConfig(druid);
        return dynamicDataSourceDto;
    }

    private void checkDruidFiled(SysDataSourceDto dataSource) {
        String validationQuery;
        JSONObject map;
        String properties = dataSource.getProperties();
        try {
            map = HussarUtils.isEmpty((Object)properties) ? new JSONObject() : JSON.parseObject((String)properties);
        }
        catch (JSONException e) {
            logger.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new HussarException("\u6570\u636e\u6e90\u914d\u7f6e\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)dataSource.getDriverClass()) && !map.containsKey((Object)"validationQuery") && HussarUtils.isNotBlank((CharSequence)(validationQuery = this.defaultValidationQuery(dataSource.getDriverClass())))) {
            map.put("validationQuery", (Object)validationQuery);
            dataSource.setProperties(JSON.toJSONString((Object)map));
        }
        if (HussarUtils.isNotEmpty((Object)map)) {
            Field[] fields = DruidConfig.class.getDeclaredFields();
            HashSet<String> fieldNames = new HashSet<String>();
            for (Field field : fields) {
                fieldNames.add(field.getName());
            }
            for (String key : map.keySet()) {
                if (fieldNames.contains(key)) continue;
                throw new HussarException("\u975e\u6cd5\u5c5e\u6027\u540d" + key);
            }
        }
    }

    private String defaultValidationQuery(String driverClass) {
        if (driverClass.equals("com.mysql.jdbc.Driver") || driverClass.equals("com.mysql.cj.jdbc.Driver") || driverClass.equals("com.mysql.jdbc.")) {
            return "SELECT 1";
        }
        if (driverClass.equals("oracle.jdbc.OracleDriver") || driverClass.equals("oracle.jdbc.driver.OracleDriver")) {
            return "SELECT 'x' FROM DUAL";
        }
        if (driverClass.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver") || driverClass.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver") || driverClass.equals("net.sourceforge.jtds.jdbc.Driver")) {
            return "SELECT 1";
        }
        if (driverClass.equals("org.postgresql.Driver") || driverClass.equals("com.highgo.jdbc.Driver") || driverClass.equals("com.edb.Driver") || driverClass.equals("com.aliyun.polardb.Driver")) {
            return "SELECT 'x'";
        }
        return null;
    }

    @HussarDs(value="#connName")
    public Boolean checkTableExist(String connName, SysDataSource sysDataSource) {
        String dsName;
        String dbName;
        String url = sysDataSource.getJdbcUrl();
        String userName = sysDataSource.getUserName();
        if (url.startsWith("jdbc:mysql") ? this.datasourceMapper.mysqlTableNum(dbName = (dsName = url.substring(url.indexOf("/") + 2, url.indexOf("?"))).substring(dsName.indexOf("/") + 1)) > 0 : (url.startsWith("jdbc:oracle") ? this.datasourceMapper.oracleTableNum(userName) > 0 : (url.startsWith("jdbc:oscar") ? this.datasourceMapper.oracleTableNum(userName) > 0 : (url.startsWith("jdbc:dm") ? this.datasourceMapper.oracleTableNum(userName) > 0 : this.datasourceMapper.pgSqlTableNum() > 0)))) {
            return false;
        }
        return true;
    }
}

