/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.api.model;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomResultMap;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.reflection.MetaObject;

public class CustomSqlEntity
extends CustomResultMap {
    private ResultMap resultMap;
    private boolean parseSql;
    private String sql;
    private List<MetadataColumn> metaData;

    @Override
    public ResultMap getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(ResultMap resultMap) {
        this.resultMap = resultMap;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean isParseSql() {
        return this.parseSql;
    }

    public void setParseSql(boolean parseSql) {
        this.parseSql = parseSql;
    }

    public List<MetadataColumn> getMetaData() {
        return this.metaData;
    }

    @Override
    public void callback(MetaObject rh, MappedStatement mappedStatement, Statement arg) throws SQLException {
        if (this.isParseSql()) {
            ResultSet resultSet = arg.getResultSet();
            this.metaData = this.getColumnList(resultSet.getMetaData());
        }
    }

    private List<MetadataColumn> getColumnList(ResultSetMetaData metaData) throws SQLException {
        ArrayList<MetadataColumn> list = new ArrayList<MetadataColumn>();
        if (metaData == null) {
            return new ArrayList<MetadataColumn>();
        }
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            MetadataColumn column = new MetadataColumn();
            column.setColumnName(metaData.getColumnName(i));
            column.setColumnAlias(metaData.getColumnLabel(i));
            column.setDataLength(Long.valueOf(metaData.getColumnDisplaySize(i)));
            column.setJavaType(metaData.getColumnClassName(i));
            column.setJdbcType(metaData.getColumnTypeName(i));
            column.setDataDot(metaData.getScale(i));
            column.setDataIsEmpty(metaData.isNullable(i));
            column.setTableName(metaData.getTableName(i));
            list.add(column);
        }
        return list;
    }
}

