/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datascope.plugin.mybatis.handler;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.constant.DataScopeConstant;
import com.jxdinfo.hussar.support.datascope.core.support.handler.ScopeModelHandler;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DefaultScopeModelHandler
implements ScopeModelHandler {
    private static final DataScopeModel SEARCHED_DATA_SCOPE_MODEL = new DataScopeModel(Boolean.TRUE);
    private final JdbcTemplate jdbcTemplate;

    public List<DataScopeModel> getDataScopeByMapper(String mapperId, String roleId) {
        ArrayList<String> args = new ArrayList<String>(Collections.singletonList(mapperId));
        List roleIds = HussarUtils.toLongList((String)roleId);
        args.addAll(roleIds);
        if (HussarUtils.isEmpty((Object)roleIds)) {
            return null;
        }
        return this.jdbcTemplate.query(DataScopeConstant.dataByMapper((int)roleIds.size()), args.toArray(), (RowMapper)new BeanPropertyRowMapper(DataScopeModel.class));
    }

    public DataScopeModel getDataScopeByCode(String code) {
        String dataScopeCodeKey = "dataScope:code:" + code;
        DataScopeModel dataScope = (DataScopeModel)HussarCacheUtil.get((String)"dataScopeCache", (Object)dataScopeCodeKey, DataScopeModel.class);
        if (dataScope == null || !dataScope.getSearched().booleanValue()) {
            List list = this.jdbcTemplate.query("select resource_code, scope_column, scope_field, scope_type, scope_value from blade_scope_data where resource_code = ?", new Object[]{code}, (RowMapper)new BeanPropertyRowMapper(DataScopeModel.class));
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                dataScope = (DataScopeModel)list.iterator().next();
                dataScope.setSearched(Boolean.TRUE);
            } else {
                dataScope = SEARCHED_DATA_SCOPE_MODEL;
            }
            HussarCacheUtil.put((String)"dataScopeCache", (Object)dataScopeCodeKey, (Object)dataScope);
        }
        return StringUtil.isNotBlank((CharSequence)dataScope.getResourceCode()) ? dataScope : null;
    }

    public List<Long> getDeptAncestors(Long deptId) {
        String dataScopeDeptKey = "dataScope:dept:ancestors:" + deptId;
        List ancestors = (List)HussarCacheUtil.get((String)"dataScopeCache", (Object)dataScopeDeptKey, List.class);
        if (CollectionUtil.isEmpty((Collection)ancestors)) {
            ancestors = this.jdbcTemplate.queryForList("SELECT STRU_ID FROM SYS_STRU WHERE STRU_FID LIKE ? AND STRU_TYPE != '9' AND DEL_FLAG = '0'", new Object[]{deptId}, Long.class);
            HussarCacheUtil.put((String)"dataScopeCache", (Object)dataScopeDeptKey, (Object)ancestors);
        }
        return ancestors;
    }

    public DefaultScopeModelHandler(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

